/*
 * Decompiled with CFR 0.152.
 */
package org.softc.armoryexpansion.common.integration.mod_support;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.softc.armoryexpansion.common.integration.aelib.integration.IndependentJsonIntegration;
import org.softc.armoryexpansion.common.util.ConfigFileSuffixEnum;
import slimeknights.tconstruct.library.events.MaterialEvent;
import slimeknights.tconstruct.library.traits.AbstractTrait;

@Mod(modid="armoryexpansion-custommaterials", name="Armory Expansion - Custom Materials", version="2.0.0-alpha", dependencies="required-after:armoryexpansion; ", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class CustomMaterialsIntegration
extends IndependentJsonIntegration {
    private static final String INTEGRATION_ID = "custommaterials";
    private static final String INTEGRATION_NAME = "Custom Materials";
    static final String MODID = "armoryexpansion-custommaterials";
    static final String NAME = "Armory Expansion - Custom Materials";
    static final String DEPENDENCIES = "required-after:armoryexpansion; ";
    private static File configDirFile;
    private Collection<String> traitIdentifierList = new HashSet<String>();

    public CustomMaterialsIntegration() {
        super(INTEGRATION_ID, "armoryexpansion", INTEGRATION_ID);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.modId = INTEGRATION_ID;
        this.enableForceJsonCreation();
        configDirFile = event.getModConfigurationDirectory();
        super.preInit(event);
    }

    @Override
    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        super.init(event);
    }

    @Override
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        this.exportAllTraitsToJson(configDirFile);
        this.exportAllPartsToJson(configDirFile);
    }

    @Override
    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<? super Block> event) {
        super.registerBlocks(event);
    }

    @SubscribeEvent
    public void registerTraits(MaterialEvent.TraitRegisterEvent<? super AbstractTrait> event) {
        this.traitIdentifierList.add(event.trait.getIdentifier());
    }

    private void exportAllTraitsToJson(File configDir) {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting().setLenient();
        Gson gson = builder.create();
        File output = new File(configDir.getPath() + "/armoryexpansion/traits.txt");
        try (FileWriter writer = new FileWriter(output);){
            writer.write(gson.toJson(this.traitIdentifierList));
        }
        catch (IOException e) {
            this.logger.error("Could not write to " + configDir.getPath() + "/armoryexpansion/traits.txt", (Throwable)e);
        }
    }

    private void exportAllPartsToJson(File configDir) {
    }

    @Override
    protected void loadMaterialsFromSource() {
    }

    @Override
    protected void loadAlloysFromSource() {
    }

    @Override
    protected void saveAlloysToJson(File dir, String fileName, boolean forceCreate) {
        if (!this.alloys.values().isEmpty() || forceCreate) {
            Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
            File output = new File(this.getFilePath(dir, fileName, ConfigFileSuffixEnum.ALLOYS_SUFFIX));
            output.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(output);){
                writer.write(this.returnAlloyExample());
                writer.write(gson.toJson(this.alloys.values()));
            }
            catch (IOException e) {
                this.logger.error("Could not write to " + this.getFilePath(dir, fileName, ConfigFileSuffixEnum.ALLOYS_SUFFIX), (Throwable)e);
            }
        }
    }

    @Override
    protected boolean enableForceJsonCreation() {
        return true;
    }

    protected String returnAlloyExample() {
        return "//  {\n//    \"output\": {\n//      \"fluid\": \"iron\",\n//      \"amount\": 144\n//    },\n//    \"inputs\": [\n//      {\n//        \"fluid\": \"copper\",\n//        \"amount\": 108\n//      },\n//      {\n//        \"fluid\": \"lead\",\n//        \"amount\": 36\n//      }\n//    ]\n//  }\n";
    }
}

