/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.toolswap;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.client.render.item.IItemRender;
import com.zeitheron.hammercore.client.render.item.ItemRenderingHandler;
import com.zeitheron.hammercore.lib.zlib.utils.Threading;
import com.zeitheron.toolswap.ConfigTS;
import com.zeitheron.toolswap.RenderItemHook;
import com.zeitheron.toolswap.ToolSwapMod;
import com.zeitheron.toolswap.api.BlockCollection;
import com.zeitheron.toolswap.api.PredefinedSets;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class SwapEvents {
    public static final Predicate<EntityPlayer> CLIENT_PLAYER = pl -> Objects.equals(pl.func_146103_bH().getId(), HammerCore.renderProxy.getClientPlayer().func_146103_bH().getId());
    public static boolean shouldSwap = false;
    public static int swapTime = 0;
    public static IntList slotHistory = new IntArrayList();
    public final File configFile = new File(Loader.instance().getConfigDir(), "toolswap.dat");

    public SwapEvents bindItemRendering() {
        for (Item it : GameRegistry.findRegistry(Item.class).getValuesCollection()) {
            if (!(it instanceof ItemTool)) continue;
            ItemRenderingHandler.INSTANCE.appendItemRender(it, (IItemRender)RenderItemHook.TOOL_HOOK);
        }
        return this;
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            return;
        }
        if (swapTime == 0 && slotHistory.size() > 0) {
            Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c = (Integer)slotHistory.get(0);
            slotHistory.clear();
        }
        if (swapTime > 0) {
            --swapTime;
        }
    }

    @SubscribeEvent
    public void attackEntity(AttackEntityEvent e) {
        EntityPlayer player = e.getEntityPlayer();
        if (!shouldSwap || player == null || !CLIENT_PLAYER.test(player)) {
            return;
        }
        InventoryPlayer p = player.field_71071_by;
        HashMap<Integer, ItemSword> swords = new HashMap<Integer, ItemSword>();
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = p.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemSword)) continue;
            swords.put(i, (ItemSword)stack.func_77973_b());
        }
        int maxS = -1;
        float maxHL = -2.1474836E9f;
        for (Integer slot : swords.keySet().toArray(new Integer[0])) {
            float hl;
            if (slot == null || swords.get(slot) == null || !((hl = Item.ToolMaterial.valueOf((String)((ItemSword)swords.get(slot)).func_150932_j()).func_78000_c()) > maxHL)) continue;
            maxHL = hl;
            maxS = slot;
        }
        if (maxS != -1) {
            player.field_71071_by.field_70461_c = maxS;
        }
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed e) {
        EntityPlayer player = e.getEntityPlayer();
        if (!shouldSwap || player == null || !CLIENT_PLAYER.test(player)) {
            return;
        }
        int maxS = -1;
        try {
            maxS = PredefinedSets.getSlotForBlock(player, e.getPos(), e.getState());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (maxS != -1) {
            int prev = player.field_71071_by.field_70461_c;
            player.field_71071_by.field_70461_c = maxS;
            boolean c = e.getState().func_177230_c().canHarvestBlock((IBlockAccess)player.func_130014_f_(), e.getPos(), player);
            player.field_71071_by.field_70461_c = prev;
            if (c) {
                if (player.field_71071_by.field_70461_c != maxS) {
                    slotHistory.add(player.field_71071_by.field_70461_c);
                }
                player.field_71071_by.field_70461_c = maxS;
                this.setSwapped();
            }
        }
    }

    @SubscribeEvent
    public void clientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent e) {
        Minecraft.func_71410_x().func_152344_a(this::saveOptions);
    }

    @SubscribeEvent
    public void clientConnect(FMLNetworkEvent.ClientConnectedToServerEvent e) {
        Minecraft.func_71410_x().func_152344_a(this::loadOptions);
        Threading.createAndStart((String)"ToolSwapReloaderThread", BlockCollection::reload);
    }

    public void setSwapped() {
        swapTime = ConfigTS.swapDelay;
    }

    public void saveOptions() {
        try (DataOutputStream o = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(this.configFile)));){
            o.writeBoolean(shouldSwap);
        }
        catch (IOException ioe) {
            ToolSwapMod.LOG.error("Failed to save configs!", (Throwable)ioe);
        }
    }

    public void loadOptions() {
        if (this.configFile.isFile()) {
            try (DataInputStream i = new DataInputStream(new GZIPInputStream(new FileInputStream(this.configFile)));){
                shouldSwap = i.readBoolean();
            }
            catch (IOException ioe) {
                ToolSwapMod.LOG.error("Failed to load configs!", (Throwable)ioe);
            }
        } else {
            shouldSwap = true;
        }
    }

    public static boolean isFav(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p().func_74767_n("TSFav");
    }

    public static void toggleFav(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        stack.func_77982_d(nbt);
        nbt.func_74757_a("TSFav", !nbt.func_74767_n("TSFav"));
    }
}

