/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.toolswap;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.lib.zlib.error.JSONException;
import com.zeitheron.hammercore.lib.zlib.io.IOUtils;
import com.zeitheron.hammercore.lib.zlib.json.JSONArray;
import com.zeitheron.hammercore.lib.zlib.json.JSONObject;
import com.zeitheron.hammercore.lib.zlib.json.JSONTokener;
import com.zeitheron.hammercore.lib.zlib.utils.Joiner;
import com.zeitheron.toolswap.CommandTSwap;
import com.zeitheron.toolswap.SwapEvents;
import com.zeitheron.toolswap.api.BlockCollection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="toolswap", name="Tool Swap", version="10a", dependencies="required-after:hammercore@[2.0.0.1,)", certificateFingerprint="4d7b29cd19124e986da685107d16ce4b49bc0a97", clientSideOnly=true, acceptedMinecraftVersions="[1.12.2]")
public class ToolSwapMod {
    public static SwapEvents events;
    public static final Logger LOG;

    @Mod.EventHandler
    public void certificateViolation(FMLFingerprintViolationEvent e) {
        LOG.warn("*****************************");
        LOG.warn("WARNING: Somebody has been tampering with ToolSwap jar!");
        LOG.warn("It is highly recommended that you redownload mod from https://minecraft.curseforge.com/projects/246309 !");
        LOG.warn("*****************************");
        HammerCore.invalidCertificates.put("toolswap", "https://minecraft.curseforge.com/projects/246309");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        ModMetadata meta = e.getModMetadata();
        meta.autogenerated = false;
        meta.authorList = HammerCore.getHCAuthorsArray();
        meta.version = "10a";
        events = new SwapEvents();
        MinecraftForge.EVENT_BUS.register((Object)events);
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandTSwap());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        events.bindItemRendering();
    }

    public static void reloadBC() {
        LOG.info("Reloading built-in overrides...");
        long start = System.currentTimeMillis();
        JSONObject obj = ToolSwapMod.loadOverrides();
        JSONObject items = obj.optJSONObject("items");
        JSONObject tools = obj.optJSONObject("tools");
        IForgeRegistry itemReg = GameRegistry.findRegistry(Item.class);
        IForgeRegistry BlockReg = GameRegistry.findRegistry(Block.class);
        if (items != null) {
            for (String item : items.keySet()) {
                Item it = (Item)itemReg.getValue(new ResourceLocation(item));
                if (it == null) continue;
                JSONArray arr = items.optJSONArray(item);
                int s = arr.length();
                for (int i = 0; i < s; ++i) {
                    Block bl;
                    String str = arr.optString(i);
                    Block block = bl = str != null ? (Block)BlockReg.getValue(new ResourceLocation(str)) : null;
                    if (bl == null) continue;
                    BlockCollection.putItemMapping(it, bl);
                }
            }
        }
        if (tools != null) {
            for (String tool : tools.keySet()) {
                if (tool == null) continue;
                JSONArray arr = tools.optJSONArray(tool);
                int s = arr.length();
                for (int i = 0; i < s; ++i) {
                    Block bl;
                    String str = arr.optString(i);
                    Block block = bl = str != null ? (Block)BlockReg.getValue(new ResourceLocation(str)) : null;
                    if (bl == null) continue;
                    BlockCollection.putToolMapping(tool, bl);
                }
            }
        }
        long end = System.currentTimeMillis();
        LOG.info("  Reloaded in " + (end - start) + " ms.");
    }

    public static JSONObject loadOverrides() {
        JSONObject jo = null;
        try {
            jo = (JSONObject)new JSONTokener(new String(IOUtils.pipeOut((InputStream)ToolSwapMod.class.getResourceAsStream("/tswap_overrides.json")))).nextValue();
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
        File overrides = new File(Loader.instance().getConfigDir(), "toolswap_overrides.json");
        if (!overrides.isFile()) {
            try (FileOutputStream os = new FileOutputStream(overrides);){
                ((OutputStream)os).write(IOUtils.pipeOut((InputStream)ToolSwapMod.class.getResourceAsStream("/tswap_overrides.json")));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        try {
            jo = ToolSwapMod.merge(jo, (JSONObject)new JSONTokener(Joiner.NEW_LINE.join(Files.readAllLines(overrides.toPath()))).nextValue());
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
        try {
            jo = ToolSwapMod.merge(jo, (JSONObject)IOUtils.downloadjson((String)"https://pastebin.com/raw/92QrP2VF"));
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
        return jo;
    }

    /*
     * WARNING - void declaration
     */
    private static JSONArray merge(JSONArray a, JSONArray b) {
        void var5_9;
        void var5_7;
        if (a == b && a == null) {
            return null;
        }
        if (a == null || b == null) {
            return a != null ? a : b;
        }
        HashSet<Object> set = new HashSet<Object>();
        Object[] objectArray = a.values();
        int n = objectArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            Object av = objectArray[var5_7];
            set.add(av);
            ++var5_7;
        }
        objectArray = b.values();
        n = objectArray.length;
        boolean bl2 = false;
        while (var5_9 < n) {
            Object bv = objectArray[var5_9];
            set.add(bv);
            ++var5_9;
        }
        JSONArray arr = new JSONArray();
        for (Object e : set) {
            arr.put(e);
        }
        return arr;
    }

    private static JSONObject merge(JSONObject a, JSONObject b) {
        if (a == b && a == null) {
            return null;
        }
        if (a == null || b == null) {
            return a != null ? a : b;
        }
        JSONObject obj = new JSONObject();
        try {
            for (String keyA : a.keySet()) {
                obj.putOpt(keyA, a.get(keyA));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            for (String keyB : b.keySet()) {
                Object ins = obj.opt(keyB);
                Object bv = b.get(keyB);
                if (ins != null && bv != null) {
                    if (ins instanceof JSONObject && bv instanceof JSONObject) {
                        bv = ToolSwapMod.merge((JSONObject)ins, (JSONObject)bv);
                    }
                    if (ins instanceof JSONArray && bv instanceof JSONArray) {
                        bv = ToolSwapMod.merge((JSONArray)ins, (JSONArray)bv);
                    }
                }
                obj.putOpt(keyB, bv);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return obj;
    }

    static {
        LOG = LogManager.getLogger((String)"Tool Swap");
    }
}

