/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.toolswap.api;

import com.zeitheron.hammercore.lib.zlib.tuple.TwoTuple;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.util.math.Vec3d;

public class EntityStatePredicate {
    public static final Map<String, Predicate<Entity>> PREDICATES = new HashMap<String, Predicate<Entity>>();

    public static void bindWithOpposite(String name, String opposite, Predicate<Entity> pred) {
        EntityStatePredicate.bind(name, pred);
        EntityStatePredicate.bind(opposite, ent -> !EntityStatePredicate.test(name, ent));
    }

    public static void bind(String name, Predicate<Entity> pred) {
        Predicate<Entity> p = PREDICATES.get(name);
        p = p == null ? pred : p.or(pred);
        PREDICATES.put(name, p);
    }

    public static boolean testPredicate(String name, Entity ent, Supplier<Vec3d> pos) {
        Predicate<Entity> pred = null;
        if (name.isEmpty()) {
            return true;
        }
        name = "&" + name;
        while (!name.isEmpty()) {
            int f = name.isEmpty() ? 38 : (int)name.charAt(0);
            name = name.substring(1);
            String token = "";
            while (!name.isEmpty() && name.charAt(0) != '&' && name.charAt(0) != '|') {
                token = token + name.charAt(0);
                name = name.substring(1);
            }
            Predicate<Entity> p = PREDICATES.getOrDefault(token, EntityStatePredicate.compoundPredicate(token, pos));
            pred = pred == null ? p : (f == 124 ? pred.or(p) : pred.and(p));
        }
        return pred == null || pred.test(ent);
    }

    public static Predicate<Entity> compoundPredicate(String str, Supplier<Vec3d> pos) {
        if (str.startsWith("distance")) {
            String sub = str.substring(8);
            if (sub.startsWith(">=")) {
                double num = Double.parseDouble(sub.substring(2));
                return e -> ((Vec3d)pos.get()).func_72438_d(e.func_174791_d()) >= num;
            }
            if (sub.startsWith("<=")) {
                double num = Double.parseDouble(sub.substring(2));
                return e -> ((Vec3d)pos.get()).func_72438_d(e.func_174791_d()) <= num;
            }
            if (sub.startsWith(">")) {
                double num = Double.parseDouble(sub.substring(1));
                return e -> ((Vec3d)pos.get()).func_72438_d(e.func_174791_d()) > num;
            }
            if (sub.startsWith("<")) {
                double num = Double.parseDouble(sub.substring(1));
                return e -> ((Vec3d)pos.get()).func_72438_d(e.func_174791_d()) < num;
            }
        } else if (str.startsWith("color=")) {
            String color = str.substring(6);
            return e -> e instanceof EntitySheep && ((EntitySheep)e).func_175509_cj().func_192396_c().equalsIgnoreCase(color);
        }
        return e -> false;
    }

    public static boolean test(String name, Entity ent) {
        Predicate<Entity> p = PREDICATES.get(name);
        return p == null ? false : p.test(ent);
    }

    private static TwoTuple<Integer, Character> findFirst(String str, char ... cs) {
        int index = str.length() * 2;
        char fo = ' ';
        for (char c : cs) {
            int i = str.indexOf(c);
            if (i == -1 || index <= i) continue;
            index = i;
            fo = c;
        }
        return new TwoTuple((Object)(index > str.length() ? -1 : index), (Object)Character.valueOf(fo));
    }

    static {
        EntityStatePredicate.bindWithOpposite("child", "adult", ent -> {
            if (ent instanceof EntityAgeable) {
                return ((EntityAgeable)ent).func_70631_g_();
            }
            return false;
        });
    }
}

