/*
 * Decompiled with CFR 0.152.
 */
package extracells.block;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGridNode;
import appeng.api.util.AEPartLocation;
import extracells.api.IWrenchHandler;
import extracells.block.BlockEC;
import extracells.block.TGuiBlock;
import extracells.container.ContainerVibrationChamberFluid;
import extracells.gui.GuiVibrationChamberFluid;
import extracells.network.GuiHandler;
import extracells.tileentity.TileEntityVibrationChamberFluid;
import extracells.util.PermissionUtil;
import extracells.util.TileUtil;
import extracells.util.WrenchUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockVibrationChamberFluid
extends BlockEC
implements TGuiBlock {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool STATE = PropertyBool.func_177716_a((String)"state");

    public BlockVibrationChamberFluid() {
        super(Material.field_151573_f, 2.0f, 10.0f);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        ItemStack current = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            TileEntity tile = world.func_175625_s(pos);
            if (!PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, tile)) {
                return false;
            }
            RayTraceResult rayTraceResult = new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), side, pos);
            IWrenchHandler wrenchHandler = WrenchUtil.getHandler(current, player, rayTraceResult, hand);
            if (wrenchHandler != null) {
                BlockVibrationChamberFluid.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((Block)this));
                world.func_175698_g(pos);
                wrenchHandler.wrenchUsed(current, player, rayTraceResult, hand);
                return true;
            }
        }
        GuiHandler.launchGui(0, player, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityVibrationChamberFluid();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getClientGuiElement(EntityPlayer player, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof TileEntityVibrationChamberFluid) {
            return new GuiVibrationChamberFluid(player, (TileEntityVibrationChamberFluid)tileEntity);
        }
        return null;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof TileEntityVibrationChamberFluid) {
            return new ContainerVibrationChamberFluid(player.field_71071_by, (TileEntityVibrationChamberFluid)tileEntity);
        }
        return null;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (worldIn.field_72995_K) {
            return;
        }
        TileUtil.setOwner(worldIn, pos, placer);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityVibrationChamberFluid) {
            TileEntityVibrationChamberFluid vibrationChamberFluid = (TileEntityVibrationChamberFluid)tile;
            state = state.func_177226_a((IProperty)STATE, (Comparable)Boolean.valueOf(vibrationChamberFluid.getBurnTime() > 0));
        }
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, STATE});
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        IGridNode node;
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityVibrationChamberFluid && (node = ((TileEntityVibrationChamberFluid)tile).getGridNode(AEPartLocation.INTERNAL)) != null) {
            node.destroy();
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.field_72995_K) {
            super.func_180663_b(worldIn, pos, state);
            return;
        }
        TileUtil.destroy(worldIn, pos);
        super.func_180663_b(worldIn, pos, state);
    }
}

