/*
 * Decompiled with CFR 0.152.
 */
package extracells.gui.widget.fluid;

import extracells.gui.widget.AbstractWidget;
import extracells.gui.widget.WidgetManager;
import extracells.gui.widget.fluid.IFluidSlotListener;
import extracells.integration.Integration;
import extracells.network.packet.other.PacketFluidSlotSelect;
import extracells.part.gas.PartGasExport;
import extracells.part.gas.PartGasImport;
import extracells.part.gas.PartGasStorage;
import extracells.util.FluidHelper;
import extracells.util.GasUtil;
import extracells.util.NetworkUtil;
import java.util.Collections;
import java.util.List;
import mekanism.api.gas.GasStack;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class WidgetFluidSlot
extends AbstractWidget {
    private int id;
    private Fluid fluid;
    private static final ResourceLocation guiTexture = new ResourceLocation("extracells", "textures/gui/busiofluid.png");
    private IFluidSlotListener listener;
    private IConfigurable configurable;
    private byte configOption;

    public WidgetFluidSlot(WidgetManager widgetManager, IFluidSlotListener listener, int posX, int posY) {
        this(widgetManager, listener, 0, posX, posY, null, 0);
    }

    public WidgetFluidSlot(WidgetManager widgetManager, IFluidSlotListener listener, int id, int posX, int posY) {
        this(widgetManager, listener, id, posX, posY, null, 0);
    }

    public WidgetFluidSlot(WidgetManager widgetManager, IFluidSlotListener listener, int id, int posX, int posY, IConfigurable configurable, byte configOption) {
        super(widgetManager, posX, posY);
        this.width = 18;
        this.height = 18;
        this.listener = listener;
        this.id = id;
        this.configurable = configurable;
        this.configOption = configOption;
    }

    public boolean isVisable() {
        return this.configurable == null || this.configurable.getConfigState() >= this.configOption;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (!this.isVisable()) {
            return;
        }
        TextureManager textureManager = this.manager.mc.func_110434_K();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        textureManager.func_110577_a(guiTexture);
        this.manager.gui.func_73729_b(this.xPos, this.yPos, 79, 39, 18, 18);
        if (this.fluid != null) {
            this.drawFluid(textureManager);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
    }

    @Override
    public void drawOverlay(int mouseX, int mouseY) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        TextureManager textureManager = this.manager.mc.func_110434_K();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        textureManager.func_110577_a(guiTexture);
        this.manager.gui.func_73733_a(this.xPos + 1, this.yPos + 1, this.xPos + 17, this.yPos + 17, -2130706433, -2130706433);
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
    }

    private void drawFluid(TextureManager textureManager) {
        textureManager.func_110577_a(TextureMap.field_110575_b);
        TextureAtlasSprite sprite = this.manager.mc.func_147117_R().func_110572_b(this.fluid.getStill().toString());
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.manager.gui.func_175175_a(this.xPos + 1, this.yPos + 1, sprite, 16, 16);
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        EntityPlayerSP player = this.manager.mc.field_71439_g;
        ItemStack stack = player.field_71071_by.func_70445_o();
        this.handleContainer(stack);
    }

    public void handleContainer(ItemStack stack) {
        if (!this.isVisable()) {
            return;
        }
        if ((this.listener instanceof PartGasImport || this.listener instanceof PartGasExport || this.listener instanceof PartGasStorage) && Integration.Mods.MEKANISMGAS.isEnabled()) {
            this.handleGasContainer(stack);
        } else {
            this.handleFluidContainer(stack);
        }
    }

    public void handleFluidContainer(ItemStack stack) {
        FluidStack fluidStack = FluidHelper.getFluidFromContainer(stack);
        this.fluid = fluidStack == null ? null : fluidStack.getFluid();
        NetworkUtil.sendToServer(new PacketFluidSlotSelect(this.listener, this.id, this.fluid));
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public void handleGasContainer(ItemStack stack) {
        GasStack gasStack = GasUtil.getGasFromContainer(stack);
        FluidStack fluidStack = GasUtil.getFluidStack(gasStack);
        this.fluid = fluidStack == null ? null : fluidStack.getFluid();
        NetworkUtil.sendToServer(new PacketFluidSlotSelect(this.listener, this.id, this.fluid));
    }

    @Override
    public List<String> getToolTip(int mouseX, int mouseY) {
        if (this.fluid == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(I18n.func_74838_a((String)this.fluid.getLocalizedName(new FluidStack(this.fluid, 1000))));
    }

    public void setFluid(Fluid fluid) {
        this.fluid = fluid;
    }

    public static interface IConfigurable {
        public byte getConfigState();
    }
}

