/*
 * Decompiled with CFR 0.152.
 */
package extracells.integration;

import extracells.ExtraCells;
import extracells.integration.appeng.AppEng;
import extracells.integration.buildcraft.tools.BuildcraftTools;
import extracells.integration.cofh.item.CofhItem;
import extracells.integration.igw.IGW;
import extracells.integration.mekanism.Mekanism;
import extracells.integration.mekanism.gas.MekanismGas;
import extracells.integration.opencomputers.OpenComputers;
import extracells.integration.waila.Waila;
import extracells.util.Log;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.relauncher.Side;

public class Integration {
    public void loadConfig(Configuration config) {
        for (Mods mod : Mods.values()) {
            mod.loadConfig(config);
        }
    }

    public void preInit() {
        for (Mods mod : Mods.values()) {
            if (!mod.isEnabled()) continue;
            Log.info("Enable integration for '" + mod.name + " (" + mod.modID + ")'", new Object[0]);
        }
        if (Mods.IGW.correctSide() && Mods.IGW.shouldLoad) {
            IGW.initNotifier();
        }
        if (Mods.MEKANISMGAS.isEnabled()) {
            MekanismGas.preInit();
        }
    }

    public void init() {
        if (Mods.WAILA.isEnabled()) {
            Waila.init();
        }
        if (Mods.OPENCOMPUTERS.isEnabled()) {
            OpenComputers.init();
        }
        if (Mods.MEKANISMGAS.isEnabled()) {
            MekanismGas.init();
        }
        if (Mods.IGW.isEnabled()) {
            IGW.init();
        }
        if (Mods.MEKANISM.isEnabled()) {
            Mekanism.init();
        }
        if (Mods.BUILDCRAFTTOOLS.isEnabled()) {
            BuildcraftTools.init();
        }
        if (Mods.COFHITEM.isEnabled()) {
            CofhItem.init();
        }
        AppEng.init();
    }

    public void postInit() {
        if (Mods.MEKANISMGAS.isEnabled()) {
            MekanismGas.postInit();
        }
    }

    public static enum Mods {
        WAILA("waila"),
        OPENCOMPUTERS("opencomputers"),
        BCFUEL("BuildCraftAPI|fuels", "BuildCraftFuel"),
        MEKANISMGAS("MekanismAPI|gas", "MekanismGas"),
        IGW("igwmod", "IngameWikiMod", Side.CLIENT),
        THAUMATICENERGISTICS("thaumicenergistics", "Thaumatic Energistics"),
        MEKANISM("mekanism"),
        WIRELESSCRAFTING("wct", "AE2 Wireless Crafting Terminal"),
        JEI("jei", "Just Enough Items", Side.CLIENT),
        BUILDCRAFTTOOLS("BuildCraftAPI|tools", "BuildCraft Wrench"),
        COFHITEM("cofhapi|item", "COFH Hammer");

        private final String modID;
        private boolean shouldLoad = true;
        private final String name;
        private final Side side;

        private Mods(String modid) {
            this(modid, modid);
        }

        private Mods(String modid, String modName, Side side) {
            this.modID = modid;
            this.name = modName;
            this.side = side;
        }

        private Mods(String modid, String modName) {
            this(modid, modName, null);
        }

        private Mods(String modid, Side side) {
            this(modid, modid, side);
        }

        public String getModID() {
            return this.modID;
        }

        public String getModName() {
            return this.name;
        }

        public boolean isOnClient() {
            return this.side != Side.SERVER;
        }

        public boolean isOnServer() {
            return this.side != Side.CLIENT;
        }

        public void loadConfig(Configuration config) {
            this.shouldLoad = config.get("Integration", "enable" + this.getModID(), true, "Enable " + this.getModName() + " Integration.").getBoolean(true);
        }

        public boolean isEnabled() {
            return Loader.isModLoaded((String)this.getModID()) && this.shouldLoad && this.correctSide() || ModAPIManager.INSTANCE.hasAPI(this.getModID()) && this.shouldLoad && this.correctSide();
        }

        private boolean correctSide() {
            return ExtraCells.proxy.isClient() ? this.isOnClient() : this.isOnServer();
        }
    }
}

