/*
 * Decompiled with CFR 0.152.
 */
package extracells.inventory;

import extracells.inventory.IInventoryListener;
import extracells.util.ItemStackUtils;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class InventoryPlain
implements IInventory {
    public ItemStack[] slots;
    public String customName;
    private int stackLimit;
    @Nullable
    private IInventoryListener listener;

    public InventoryPlain(String customName, int size, int stackLimit) {
        this(customName, size, stackLimit, null);
    }

    public InventoryPlain(String customName, int size, int stackLimit, IInventoryListener listener) {
        this.slots = new ItemStack[size];
        this.customName = customName;
        this.stackLimit = stackLimit;
        this.listener = listener;
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = ItemStack.field_190927_a;
        }
    }

    public ItemStack func_70298_a(int slotId, int amount) {
        ItemStack itemStack = ItemStackHelper.func_188382_a(Arrays.asList(this.slots), (int)slotId, (int)amount);
        if (itemStack != null && !itemStack.func_190926_b()) {
            this.func_70296_d();
            this.onContentsChanged();
        }
        return itemStack;
    }

    public int func_70297_j_() {
        return this.stackLimit;
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null || this.slots[i].func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public int getSlots() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack == null) {
            return ItemStack.field_190927_a;
        }
        if (!this.func_94041_b(slot, stack)) {
            return ItemStack.field_190927_a;
        }
        if (this.isSlotEmpty(slot)) {
            if (!simulate) {
                this.slots[slot] = stack;
                this.onContentsChanged();
            }
            return stack;
        }
        ItemStack oldStack = this.slots[slot];
        if (!ItemStack.func_77970_a((ItemStack)stack, (ItemStack)oldStack) && oldStack.func_77976_d() > oldStack.func_190916_E()) {
            ItemStack newStack = stack.func_77946_l();
            newStack.func_190920_e(Math.min(newStack.func_190916_E(), oldStack.func_77976_d() - oldStack.func_190916_E()));
            if (!simulate) {
                oldStack.func_190920_e(oldStack.func_190916_E() + newStack.func_190916_E());
                this.onContentsChanged();
            }
            return newStack;
        }
        return ItemStack.field_190927_a;
    }

    private boolean isSlotEmpty(int slot) {
        return this.slots[slot] == null || this.slots[slot].func_190926_b();
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.isSlotEmpty(slot)) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = this.slots[slot].func_77946_l();
        if (amount >= stack.func_190916_E()) {
            if (!simulate) {
                this.slots[slot] = ItemStack.field_190927_a;
                this.onContentsChanged();
            }
            return stack;
        }
        stack.func_190920_e(amount);
        if (!simulate) {
            this.slots[slot].func_190920_e(this.slots[slot].func_190916_E() - amount);
            this.onContentsChanged();
        }
        return stack;
    }

    public int getSlotLimit(int slot) {
        return this.slots[slot] == null || this.slots[slot].func_190926_b() ? 64 : this.slots[slot].func_77976_d();
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(Arrays.asList(this.slots), (int)index);
    }

    public String func_70005_c_() {
        return this.customName;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public ItemStack incrStackSize(int slotId, int amount) {
        ItemStack slot = this.slots[slotId];
        if (ItemStackUtils.isEmpty(slot)) {
            return ItemStack.field_190927_a;
        }
        int stackLimit = this.func_70297_j_();
        if (stackLimit > slot.func_77976_d()) {
            stackLimit = slot.func_77976_d();
        }
        ItemStack added = slot.func_77946_l();
        added.func_190920_e(slot.func_190916_E() + amount > stackLimit ? stackLimit : amount);
        slot.func_190920_e(slot.func_190916_E() + added.func_190916_E());
        this.onContentsChanged();
        return added;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public void func_70296_d() {
        if (this.listener != null) {
            this.listener.onInventoryChanged();
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public void readFromNBT(NBTTagList nbtList) {
        if (nbtList == null) {
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i] = ItemStack.field_190927_a;
            }
            return;
        }
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbtList.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.slots.length) continue;
            this.slots[j] = new ItemStack(nbttagcompound);
        }
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (stack != null && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.slots[index] = stack;
        this.onContentsChanged();
        this.func_70296_d();
    }

    public NBTTagList writeToNBT() {
        NBTTagList nbtList = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(nbttagcompound);
            nbtList.func_74742_a((NBTBase)nbttagcompound);
        }
        return nbtList;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = ItemStack.field_190927_a;
        }
        this.onContentsChanged();
    }

    protected void onContentsChanged() {
    }
}

