/*
 * Decompiled with CFR 0.152.
 */
package extracells.part.fluid;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import extracells.api.IWrenchHandler;
import extracells.api.gas.IAEGasStack;
import extracells.models.PartModels;
import extracells.part.PartECBase;
import extracells.util.AEUtils;
import extracells.util.FluidHelper;
import extracells.util.StorageChannels;
import extracells.util.WrenchUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class PartFluidStorageMonitor
extends PartECBase
implements IStackWatcherHost {
    protected Fluid fluid = null;
    protected long amount = 0L;
    private Object dspList;
    protected boolean locked = false;
    protected IStackWatcher watcher = null;

    public float getCableConnectionLength(AECableType aeCableType) {
        return 1.0f;
    }

    protected void dropItems(World world, BlockPos pos, ItemStack stack) {
        if (world == null) {
            return;
        }
        if (!world.field_72995_K) {
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
            entityitem.func_174867_a(10);
            world.func_72838_d((Entity)entityitem);
        }
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
    }

    protected IMEMonitor<IAEFluidStack> getFluidStorage() {
        IGridNode n = this.getGridNode();
        if (n == null) {
            return null;
        }
        IGrid g = n.getGrid();
        if (g == null) {
            return null;
        }
        IStorageGrid storage = (IStorageGrid)g.getCache(IStorageGrid.class);
        if (storage == null) {
            return null;
        }
        return storage.getInventory((IStorageChannel)StorageChannels.FLUID());
    }

    protected IMEMonitor<IAEGasStack> getGasStorage() {
        IGridNode n = this.getGridNode();
        if (n == null) {
            return null;
        }
        IGrid g = n.getGrid();
        if (g == null) {
            return null;
        }
        IStorageGrid storage = (IStorageGrid)g.getCache(IStorageGrid.class);
        if (storage == null) {
            return null;
        }
        return storage.getInventory((IStorageChannel)StorageChannels.GAS());
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    public List<String> getWailaBodey(NBTTagCompound data, List<String> list) {
        String fluidName;
        super.getWailaBodey(data, list);
        long amount = 0L;
        Fluid fluid = null;
        if (data.func_74764_b("locked") && data.func_74767_n("locked")) {
            list.add(I18n.func_74838_a((String)"waila.appliedenergistics2.Locked"));
        } else {
            list.add(I18n.func_74838_a((String)"waila.appliedenergistics2.Unlocked"));
        }
        if (data.func_74764_b("amount")) {
            amount = data.func_74763_f("amount");
        }
        if (data.func_74764_b("fluid") && !(fluidName = data.func_74779_i("fluid")).isEmpty()) {
            fluid = FluidRegistry.getFluid((String)fluidName);
        }
        if (fluid != null) {
            list.add(I18n.func_74838_a((String)"extracells.tooltip.fluid") + ": " + fluid.getLocalizedName(new FluidStack(fluid, 1000)));
            if (this.isActive()) {
                list.add(I18n.func_74838_a((String)"extracells.tooltip.amount") + ": " + amount + "mB");
            } else {
                list.add(I18n.func_74838_a((String)"extracells.tooltip.amount") + ": 0mB");
            }
        } else {
            list.add(I18n.func_74838_a((String)"extracells.tooltip.fluid") + ": " + I18n.func_74838_a((String)"extracells.tooltip.empty1"));
            list.add(I18n.func_74838_a((String)"extracells.tooltip.amount") + ": 0mB");
        }
        return list;
    }

    @Override
    public NBTTagCompound getWailaTag(NBTTagCompound tag) {
        super.getWailaTag(tag);
        tag.func_74757_a("locked", this.locked);
        tag.func_74772_a("amount", this.amount);
        if (this.fluid == null) {
            tag.func_74778_a("fluid", "");
        } else {
            tag.func_74778_a("fluid", this.fluid.getName());
        }
        return tag;
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (player == null || player.field_70170_p == null) {
            return true;
        }
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        ItemStack s = player.func_184586_b(hand);
        if (s == null || s.func_190926_b()) {
            if (this.locked) {
                return false;
            }
            if (this.fluid == null) {
                return true;
            }
            if (this.watcher != null) {
                this.watcher.remove((IAEStack)AEUtils.createFluidStack(this.fluid));
            }
            this.fluid = null;
            this.amount = 0L;
            IPartHost host = this.getHost();
            if (host != null) {
                host.markForUpdate();
            }
            this.saveData();
            return true;
        }
        RayTraceResult rayTraceResult = new RayTraceResult(pos, this.getFacing(), this.getLocation().getPos());
        IWrenchHandler wrenchHandler = WrenchUtil.getHandler(s, player, rayTraceResult, hand);
        if (wrenchHandler != null) {
            this.locked = !this.locked;
            wrenchHandler.wrenchUsed(s, player, rayTraceResult, hand);
            IPartHost host = this.getHost();
            if (host != null) {
                host.markForUpdate();
            }
            if (this.locked) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.appliedenergistics2.isNowLocked", new Object[0]));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.appliedenergistics2.isNowUnlocked", new Object[0]));
            }
            this.saveData();
            return true;
        }
        if (this.locked) {
            return false;
        }
        if (!FluidHelper.isEmpty(s)) {
            if (this.fluid != null && this.watcher != null) {
                this.watcher.remove((IAEStack)AEUtils.createFluidStack(this.fluid));
            }
            this.fluid = FluidHelper.getFluidFromContainer(s).getFluid();
            if (this.watcher != null) {
                this.watcher.add((IAEStack)AEUtils.createFluidStack(this.fluid));
            }
            this.onStackChange(null, null, null, null, null);
            IPartHost host = this.getHost();
            if (host != null) {
                host.markForUpdate();
            }
            return true;
        }
        return false;
    }

    public void onStackChange(IItemList<?> arg0, IAEStack<?> arg1, IAEStack<?> arg2, IActionSource arg3, IStorageChannel<?> arg4) {
        this.onStackChange();
    }

    protected void onStackChange() {
        if (this.fluid != null) {
            IGridNode n = this.getGridNode();
            if (n == null) {
                return;
            }
            IGrid g = n.getGrid();
            if (g == null) {
                return;
            }
            IStorageGrid storage = (IStorageGrid)g.getCache(IStorageGrid.class);
            if (storage == null) {
                return;
            }
            IMEMonitor<IAEFluidStack> fluids = this.getFluidStorage();
            if (fluids == null) {
                return;
            }
            for (IAEFluidStack s : fluids.getStorageList()) {
                if (s.getFluid() != this.fluid) continue;
                this.amount = s.getStackSize();
                IPartHost host = this.getHost();
                if (host != null) {
                    host.markForUpdate();
                }
                return;
            }
            this.amount = 0L;
            IPartHost host = this.getHost();
            if (host != null) {
                host.markForUpdate();
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("amount")) {
            this.amount = data.func_74763_f("amount");
        }
        if (data.func_74764_b("fluid")) {
            String name = data.func_74779_i("fluid");
            this.fluid = name.isEmpty() ? null : FluidRegistry.getFluid((String)name);
        }
        if (data.func_74764_b("locked")) {
            this.locked = data.func_74767_n("locked");
        }
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        this.amount = data.readLong();
        String name = ByteBufUtils.readUTF8String((ByteBuf)data);
        this.fluid = name.isEmpty() ? null : FluidRegistry.getFluid((String)name);
        this.locked = data.readBoolean();
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(double x, double y, double z, float partialTicks, int destroyStage) {
        if (this.fluid == null) {
            return;
        }
        if (this.dspList == null) {
            this.dspList = GLAllocation.func_74526_a((int)1);
        }
        if (!this.isActive()) {
            return;
        }
        IAEFluidStack aeFluidStack = AEUtils.createFluidStack(this.fluid);
        aeFluidStack.setStackSize(this.amount);
        if (aeFluidStack != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            GlStateManager.func_187423_f((int)((Integer)this.dspList), (int)4865);
            Tessellator tess = Tessellator.func_178181_a();
            this.renderFluid(tess, aeFluidStack);
            GlStateManager.func_187415_K();
            GlStateManager.func_179121_F();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    private void renderFluid(Tessellator tess, IAEFluidStack fluidStack) {
        block11: {
            GL11.glPushAttrib((int)1048575);
            EnumFacing facing = this.getSide().getFacing();
            PartFluidStorageMonitor.moveToFace(facing);
            PartFluidStorageMonitor.rotateToFace(facing, (byte)1);
            GlStateManager.func_179094_E();
            try {
                TextureMap textureMap;
                TextureAtlasSprite fluidIcon;
                int br = 0x1000100;
                int var11 = br % 65536;
                int var12 = br / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)var11 * 0.8f), (float)((float)var12 * 0.8f));
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179140_f();
                GlStateManager.func_179101_C();
                Minecraft mc = Minecraft.func_71410_x();
                ResourceLocation fluidStill = this.fluid.getStill();
                if (fluidStill == null || (fluidIcon = (textureMap = mc.func_147117_R()).func_110572_b(fluidStill.toString())) == null) break block11;
                GL11.glTranslatef((float)0.0f, (float)0.14f, (float)-0.24f);
                GL11.glScalef((float)0.016129032f, (float)0.016129032f, (float)0.016129032f);
                GL11.glTranslated((double)-8.6f, (double)-16.3, (double)-1.2f);
                mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
                BufferBuilder buffer = tess.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                try {
                    buffer.func_181662_b(0.0, 16.0, 0.0).func_187315_a((double)fluidIcon.func_94209_e(), (double)fluidIcon.func_94210_h()).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                    buffer.func_181662_b(16.0, 16.0, 0.0).func_187315_a((double)fluidIcon.func_94212_f(), (double)fluidIcon.func_94210_h()).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                    buffer.func_181662_b(16.0, 0.0, 0.0).func_187315_a((double)fluidIcon.func_94212_f(), (double)fluidIcon.func_94206_g()).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                    buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)fluidIcon.func_94209_e(), (double)fluidIcon.func_94206_g()).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                }
                finally {
                    tess.func_78381_a();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179109_b((float)0.0f, (float)0.14f, (float)-0.24f);
        GlStateManager.func_179152_a((float)0.016129032f, (float)0.016129032f, (float)0.016129032f);
        long qty = fluidStack.getStackSize();
        if (qty > 999999999999L) {
            qty = 999999999999L;
        }
        String msg = Long.toString(qty) + "mB";
        if (qty > 1000000000L) {
            msg = Long.toString(qty / 1000000000L) + "MB";
        } else if (qty > 1000000L) {
            msg = Long.toString(qty / 1000000L) + "KB";
        } else if (qty > 9999L) {
            msg = Long.toString(qty / 1000L) + 'B';
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int width = fr.func_78256_a(msg);
        GlStateManager.func_179109_b((float)(-0.5f * (float)width), (float)0.0f, (float)-1.0f);
        fr.func_78276_b(msg, 0, 0, 0);
        GlStateManager.func_179099_b();
    }

    private static void moveToFace(EnumFacing face) {
        GlStateManager.func_179137_b((double)((double)face.func_82601_c() * 0.77), (double)((double)face.func_96559_d() * 0.77), (double)((double)face.func_82599_e() * 0.77));
    }

    private static void rotateToFace(EnumFacing face, byte spin) {
        switch (face) {
            case UP: {
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)spin * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case DOWN: {
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)spin * -90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
        }
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return PartModels.STORAGE_MONITOR_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return PartModels.STORAGE_MONITOR_ON;
        }
        return PartModels.STORAGE_MONITOR_OFF;
    }

    @Override
    public boolean requireDynamicRender() {
        return true;
    }

    public void updateWatcher(IStackWatcher w) {
        this.watcher = w;
        if (this.fluid != null) {
            w.add((IAEStack)AEUtils.createFluidStack(this.fluid));
        }
        this.onStackChange(null, null, null, null, null);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74772_a("amount", this.amount);
        if (this.fluid == null) {
            data.func_74768_a("fluid", -1);
        } else {
            data.func_74778_a("fluid", this.fluid.getName());
        }
        data.func_74757_a("locked", this.locked);
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeLong(this.amount);
        if (this.fluid == null) {
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)"");
        } else {
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.fluid.getName());
        }
        data.writeBoolean(this.locked);
    }
}

