/*
 * Decompiled with CFR 0.152.
 */
package extracells.registries;

import extracells.integration.Integration;
import extracells.item.ItemFluid;
import extracells.item.ItemFluidPattern;
import extracells.item.ItemGas;
import extracells.item.ItemInternalCraftingPattern;
import extracells.item.ItemOCUpgrade;
import extracells.item.ItemPartECBase;
import extracells.item.ItemWirelessTerminalFluid;
import extracells.item.ItemWirelessTerminalGas;
import extracells.item.ItemWirelessTerminalUniversal;
import extracells.item.storage.ItemStorageCasing;
import extracells.item.storage.ItemStorageCellFluid;
import extracells.item.storage.ItemStorageCellGas;
import extracells.item.storage.ItemStorageCellPhysical;
import extracells.item.storage.ItemStorageCellPortableFluid;
import extracells.item.storage.ItemStorageCellPortableGas;
import extracells.item.storage.ItemStorageComponent;
import extracells.util.CreativeTabEC;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;

public enum ItemEnum {
    PARTITEM("part.base", new ItemPartECBase()),
    FLUIDSTORAGE("storage.fluid", new ItemStorageCellFluid()),
    PHYSICALSTORAGE("storage.physical", new ItemStorageCellPhysical()),
    GASSTORAGE("storage.gas", new ItemStorageCellGas(), Integration.Mods.MEKANISMGAS),
    FLUIDPATTERN("pattern.fluid", new ItemFluidPattern()),
    FLUIDWIRELESSTERMINAL("terminal.fluid.wireless", ItemWirelessTerminalFluid.THIS()),
    STORAGECOMPONET("storage.component", new ItemStorageComponent()),
    STORAGECASING("storage.casing", new ItemStorageCasing()),
    FLUIDITEM("fluid.item", new ItemFluid(), null, null),
    FLUIDSTORAGEPORTABLE("storage.fluid.portable", new ItemStorageCellPortableFluid()),
    GASSTORAGEPORTABLE("storage.gas.portable", new ItemStorageCellPortableGas(), Integration.Mods.MEKANISMGAS),
    CRAFTINGPATTERN("pattern.crafting", new ItemInternalCraftingPattern(), null, null),
    UNIVERSALTERMINAL("terminal.universal.wireless", new ItemWirelessTerminalUniversal()),
    GASWIRELESSTERMINAL("terminal.gas.wireless", ItemWirelessTerminalGas.THIS(), Integration.Mods.MEKANISMGAS),
    OCUPGRADE("oc.upgrade", ItemOCUpgrade.THIS(), Integration.Mods.OPENCOMPUTERS),
    GASITEM("gas.item", ItemGas.INSTANCE(), Integration.Mods.MEKANISMGAS, null);

    private final String internalName;
    private Item item;
    private Integration.Mods mod;

    private ItemEnum(String internalName, Item item) {
        this(internalName, item, null);
    }

    private ItemEnum(String internalName, Item item, Integration.Mods mod) {
        this(internalName, item, mod, CreativeTabEC.INSTANCE);
    }

    private ItemEnum(String internalName, Item item, Integration.Mods mod, CreativeTabs creativeTab) {
        this.internalName = internalName;
        this.item = item;
        this.item.func_77655_b("extracells." + this.internalName);
        this.item.setRegistryName(this.internalName);
        this.mod = mod;
        if (creativeTab != null && (mod == null || mod.isEnabled())) {
            this.item.func_77637_a(creativeTab);
        }
    }

    public ItemStack getDamagedStack(int damage) {
        return new ItemStack(this.item, 1, damage);
    }

    public String getInternalName() {
        return this.internalName;
    }

    public Item getItem() {
        return this.item;
    }

    public ItemStack getSizedStack(int size) {
        return new ItemStack(this.item, size);
    }

    public String getStatName() {
        return I18n.func_74838_a((String)this.item.func_77658_a());
    }

    public Integration.Mods getMod() {
        return this.mod;
    }

    public boolean shouldRegister() {
        return this.mod == null || this.mod.isEnabled();
    }
}

