/*
 * Decompiled with CFR 0.152.
 */
package com.droog71.reactor_turbines.forge_energy;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyStorage
implements IEnergyStorage {
    protected int energy;
    public int capacity;

    public void readFromNBT(NBTTagCompound compound) {
        this.energy = compound.func_74762_e("energy");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("energy", this.energy);
        return compound;
    }

    public int generateEnergy(int amount) {
        int energyAdded = Math.min(this.capacity - this.energy, amount);
        this.energy += energyAdded;
        return energyAdded;
    }

    public int useEnergy(int energyToUse) {
        int energyUsed = Math.min(this.energy, energyToUse);
        this.energy -= energyUsed;
        return energyUsed;
    }

    public List<IEnergyStorage> receivers(World world, BlockPos pos) {
        BlockPos[] sides;
        ArrayList<IEnergyStorage> receiversFound = new ArrayList<IEnergyStorage>();
        for (BlockPos p : sides = new BlockPos[]{pos.func_177982_a(0, 1, 0), pos.func_177982_a(1, 0, 0), pos.func_177982_a(0, 0, 1), pos.func_177982_a(0, -1, 0), pos.func_177982_a(-1, 0, 0), pos.func_177982_a(0, 0, -1)}) {
            TileEntity otherTile = world.func_175625_s(p);
            if (otherTile == null) continue;
            EnumFacing direction = null;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                IEnergyStorage otherStorage = (IEnergyStorage)otherTile.getCapability(CapabilityEnergy.ENERGY, facing);
                if (otherStorage == null || direction != null) continue;
                direction = facing;
            }
            IEnergyStorage otherStorage = (IEnergyStorage)otherTile.getCapability(CapabilityEnergy.ENERGY, direction);
            if (otherStorage == null || !otherStorage.canReceive()) continue;
            receiversFound.add(otherStorage);
        }
        return receiversFound;
    }

    public void giveEnergy(EnergyStorage source, IEnergyStorage sink, int rating) {
        if (sink != null && sink.canReceive()) {
            int demand = sink.getMaxEnergyStored() - sink.getEnergyStored();
            int potential = Math.min(demand, rating);
            int output = Math.min(potential, source.getEnergyStored());
            source.useEnergy(output);
            sink.receiveEnergy(output, false);
        }
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return false;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public boolean canReceive() {
        return false;
    }

    public int receiveEnergy(int amount, boolean simulate) {
        return 0;
    }
}

