/*
 * Decompiled with CFR 0.152.
 */
package com.droog71.reactor_turbines.tile_entity;

import com.droog71.reactor_turbines.config.ConfigHandler;
import com.droog71.reactor_turbines.forge_energy.EnergyStorage;
import com.droog71.reactor_turbines.init.ReactorTurbineBlocks;
import com.droog71.reactor_turbines.init.ReactorTurbineSounds;
import com.droog71.reactor_turbines.tile_entity.TurbineBlockPositions;
import ic2.api.energy.prefab.BasicSource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkDataProvider;
import ic2.api.reactor.IReactor;
import ic2.api.tile.IEnergyStorage;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

public class ReactorTurbineTileEntity
extends TileEntity
implements ITickable {
    public BasicSource ic2EnergySource = new BasicSource((TileEntity)this, 1024.0, 3);
    private EnergyStorage energyStorage = new EnergyStorage();
    private TurbineBlockPositions positions = new TurbineBlockPositions();
    private ReactorTurbineTileEntity mainTurbine;
    public IReactor reactor;
    private int turbineSoundLoopTimer;
    private int alarmSoundLoopTimer;
    private int coolingTimer;
    private int outOfWaterTimer;
    private int waterEvaporated;
    private int enclosureCheckTimer;
    private float reactorHeatGoal;
    private float currentHeatPercentage;
    private boolean built;
    private boolean located;
    private boolean outOfWater;
    public double currentGeneration;
    public int reactorHeat;
    public int numTurbines;
    public boolean isMainTurbine;
    public boolean mainTurbineLoaded;
    public boolean adjacentTurbinesLoaded;
    public boolean enclosureIntact;

    public void onLoad() {
        this.ic2EnergySource.onLoad();
        this.energyStorage.capacity = 4096;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.ic2EnergySource.invalidate();
    }

    public void onChunkUnload() {
        this.ic2EnergySource.onChunkUnload();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.ic2EnergySource.readFromNBT(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        return this.ic2EnergySource.writeToNBT(tag);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (!this.located) {
                this.positions.getPositions(this.field_174879_c);
                this.located = true;
            }
            if (this.aboveReactor()) {
                if (this.adjacentTurbineCount() == 5) {
                    if (this.mainTurbineLoaded && !this.adjacentTurbinesLoaded) {
                        this.reloadAdjacentTurbines();
                    }
                    if (!this.built) {
                        this.buildEnclosure();
                    } else {
                        ++this.enclosureCheckTimer;
                        if (this.enclosureCheckTimer >= 100) {
                            this.checkEnclosure();
                        }
                        if (this.enclosureIntact) {
                            this.generateAsMain();
                        }
                    }
                }
            } else if (this.getMainTurbine() != null) {
                if (!this.mainTurbine.mainTurbineLoaded) {
                    this.reloadMainTurbine();
                } else {
                    this.generateAsAdjacent();
                }
            }
        }
    }

    private boolean aboveReactor() {
        TileEntity reactorPosTileEntity;
        if (this.field_145850_b.func_180495_p(this.positions.reactorPos) != null && this.field_145850_b.func_180495_p(this.positions.reactorPos).func_177230_c() != null && (reactorPosTileEntity = this.field_145850_b.func_175625_s(this.positions.reactorPos)) != null && reactorPosTileEntity instanceof IReactor) {
            this.reactor = (IReactor)reactorPosTileEntity;
            this.isMainTurbine = true;
            return true;
        }
        if (this.isMainTurbine) {
            this.mainTurbineLoaded = false;
        }
        this.isMainTurbine = false;
        return false;
    }

    private ReactorTurbineTileEntity getMainTurbine() {
        for (BlockPos p : this.positions.adjacentTurbinePositions) {
            TileEntity tileEntityAtPosition;
            if (this.field_145850_b.func_180495_p(p) == null || this.field_145850_b.func_180495_p(p).func_177230_c() == null || (tileEntityAtPosition = this.field_145850_b.func_175625_s(p)) == null || !(tileEntityAtPosition instanceof ReactorTurbineTileEntity) || !((ReactorTurbineTileEntity)tileEntityAtPosition).isMainTurbine) continue;
            this.positions.mainTurbinePos = p;
            this.mainTurbine = (ReactorTurbineTileEntity)tileEntityAtPosition;
            return this.mainTurbine;
        }
        return null;
    }

    private int adjacentTurbineCount() {
        this.numTurbines = 1;
        for (BlockPos p : this.positions.adjacentTurbinePositions) {
            TileEntity adjacentTileEntity;
            if (this.field_145850_b.func_180495_p(p) == null || this.field_145850_b.func_180495_p(p).func_177230_c() == null || (adjacentTileEntity = this.field_145850_b.func_175625_s(p)) == null || !(adjacentTileEntity instanceof ReactorTurbineTileEntity) || ((ReactorTurbineTileEntity)adjacentTileEntity).isMainTurbine) continue;
            ++this.numTurbines;
        }
        return this.numTurbines;
    }

    private void reloadAdjacentTurbines() {
        for (BlockPos p : this.positions.adjacentTurbinePositions) {
            this.field_145850_b.func_175698_g(p);
            this.field_145850_b.func_175713_t(p);
            this.field_145850_b.func_175656_a(p, ReactorTurbineBlocks.reactorTurbine.func_176223_P());
        }
        this.adjacentTurbinesLoaded = true;
    }

    private void buildEnclosure() {
        for (BlockPos p : this.positions.enclosurePositions) {
            Block b = this.field_145850_b.func_180495_p(p).func_177230_c();
            if (b != Blocks.field_150350_a && b != Blocks.field_150355_j && b != Blocks.field_150358_i) continue;
            this.field_145850_b.func_175656_a(p, Blocks.field_150359_w.func_176223_P());
        }
        this.built = true;
        this.enclosureIntact = true;
    }

    private boolean checkEnclosure() {
        for (BlockPos p : this.positions.enclosurePositions) {
            Block b = this.field_145850_b.func_180495_p(p).func_177230_c();
            if (b != Blocks.field_150350_a && b != Blocks.field_150355_j && b != Blocks.field_150358_i) continue;
            this.enclosureIntact = false;
            return this.enclosureIntact;
        }
        this.enclosureIntact = true;
        return this.enclosureIntact;
    }

    private void generateAsMain() {
        if (this.reactor != null) {
            this.checkForDisallowedConnections();
            this.negateReactorOutput(this.reactor);
            this.reactorHeat = this.reactor.getHeat();
            if (this.reactorHeat >= 1) {
                this.reactorHeatGoal = (float)this.reactor.getMaxHeat() * 0.25f;
                this.currentHeatPercentage = (float)this.reactor.getHeat() / this.reactorHeatGoal;
                if (this.currentHeatPercentage >= 1.5f) {
                    this.soundAlarm();
                }
                this.checkForWater();
                if (!this.outOfWater) {
                    this.currentGeneration = 512.0f * this.currentHeatPercentage * ConfigHandler.getPowerMultiplier();
                    if (this.currentGeneration > 512.0) {
                        this.currentGeneration = 512.0f * ConfigHandler.getPowerMultiplier();
                    }
                    this.addEnergy(this.currentGeneration);
                    this.reactor.addOutput((float)this.currentGeneration);
                    ++this.coolingTimer;
                    if (this.coolingTimer >= 20) {
                        this.coolReactor(this.reactor);
                        this.coolingTimer = 0;
                    }
                    ++this.waterEvaporated;
                    if ((float)this.waterEvaporated >= 1200.0f / this.currentHeatPercentage) {
                        this.evaporateWater();
                    }
                    ++this.turbineSoundLoopTimer;
                    if (this.turbineSoundLoopTimer > 25) {
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, ReactorTurbineSounds.turbineSoundEvent, SoundCategory.BLOCKS, 0.5f, 1.0f);
                        this.turbineSoundLoopTimer = 0;
                    }
                }
            }
        }
    }

    private void reloadMainTurbine() {
        this.field_145850_b.func_175698_g(this.positions.mainTurbinePos);
        this.field_145850_b.func_175713_t(this.positions.mainTurbinePos);
        this.field_145850_b.func_175656_a(this.positions.mainTurbinePos, ReactorTurbineBlocks.reactorTurbine.func_176223_P());
        ((ReactorTurbineTileEntity)this.field_145850_b.func_175625_s((BlockPos)this.positions.mainTurbinePos)).mainTurbineLoaded = true;
    }

    private void generateAsAdjacent() {
        if (this.mainTurbine.reactor != null && this.mainTurbine.numTurbines == 5 && this.mainTurbine.enclosureIntact && this.mainTurbine.reactor != null) {
            this.checkForWater();
            if (!this.outOfWater) {
                this.reactorHeat = this.mainTurbine.reactorHeat;
                if (this.reactorHeat >= 1) {
                    this.reactorHeatGoal = (float)this.mainTurbine.reactor.getMaxHeat() * 0.25f;
                    this.currentHeatPercentage = (float)this.mainTurbine.reactor.getHeat() / this.reactorHeatGoal;
                    this.currentGeneration = 512.0f * this.currentHeatPercentage * ConfigHandler.getPowerMultiplier();
                    if (this.currentGeneration > 512.0) {
                        this.currentGeneration = 512.0f * ConfigHandler.getPowerMultiplier();
                    }
                    this.addEnergy(this.currentGeneration);
                }
            }
        }
    }

    private void checkForDisallowedConnections() {
        for (BlockPos p : this.positions.reactorAdjacentPositions) {
            TileEntity tE;
            if (this.field_145850_b.func_180495_p(p) == null || this.field_145850_b.func_180495_p(p).func_177230_c() == null || (tE = this.field_145850_b.func_175625_s(p)) == null || !(tE instanceof IEnergyTile) && !(tE instanceof INetworkDataProvider) && !(tE instanceof IEnergyStorage)) continue;
            this.field_145850_b.func_175698_g(p);
        }
    }

    private void coolReactor(IReactor reactor) {
        if (this.currentHeatPercentage < 0.2f) {
            if (reactor.getHeat() >= 24) {
                reactor.addHeat(-24);
            } else {
                reactor.addHeat(reactor.getHeat() * -1);
            }
        } else if (this.currentHeatPercentage >= 0.2f && this.currentHeatPercentage < 0.4f) {
            if (reactor.getHeat() >= 48) {
                reactor.addHeat(-48);
            }
        } else if (this.currentHeatPercentage >= 0.4f && this.currentHeatPercentage < 0.6f) {
            if (reactor.getHeat() >= 72) {
                reactor.addHeat(-72);
            }
        } else if (this.currentHeatPercentage >= 0.6f && this.currentHeatPercentage < 0.8f) {
            if (reactor.getHeat() >= 96) {
                reactor.addHeat(-96);
            }
        } else if (this.currentHeatPercentage >= 0.8f && this.currentHeatPercentage < 1.0f) {
            if (reactor.getHeat() >= 120) {
                reactor.addHeat(-120);
            }
        } else if (this.currentHeatPercentage >= 1.0f && reactor.getHeat() >= 144) {
            reactor.addHeat(-144);
        }
    }

    private void checkForWater() {
        Block waterBlock = this.field_145850_b.func_180495_p(this.positions.thisTurbineWaterPos).func_177230_c();
        if (waterBlock != Blocks.field_150355_j) {
            if (!this.outOfWater) {
                ++this.outOfWaterTimer;
                if (this.outOfWaterTimer >= 200) {
                    this.outOfWaterTimer = 0;
                    this.outOfWater = true;
                }
            }
        } else {
            this.outOfWaterTimer = 0;
            this.outOfWater = false;
        }
    }

    private void evaporateWater() {
        this.field_145850_b.func_184133_a(null, this.field_174879_c, ReactorTurbineSounds.steamSoundEvent, SoundCategory.BLOCKS, 1.0f, 1.0f);
        for (BlockPos p : this.positions.waterPositions) {
            if (this.field_145850_b.func_180495_p(p).func_177230_c() != Blocks.field_150355_j && this.field_145850_b.func_180495_p(p).func_177230_c() != Blocks.field_150358_i) continue;
            this.field_145850_b.func_175698_g(p);
        }
        this.waterEvaporated = 0;
    }

    private void negateReactorOutput(IReactor reactor) {
        if (reactor.getReactorEUEnergyOutput() > 0.0) {
            reactor.addOutput(reactor.getReactorEnergyOutput() * -1.0f);
        }
    }

    private void soundAlarm() {
        ++this.alarmSoundLoopTimer;
        if (this.alarmSoundLoopTimer >= 200) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, ReactorTurbineSounds.alarmSoundEvent, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.alarmSoundLoopTimer = 0;
        }
    }

    private void addEnergy(double amount) {
        if (this.energyStorage.receivers(this.field_145850_b, this.field_174879_c).size() > 0) {
            this.energyStorage.generateEnergy((int)amount * 4);
            for (net.minecraftforge.energy.IEnergyStorage sink : this.energyStorage.receivers(this.field_145850_b, this.field_174879_c)) {
                this.energyStorage.giveEnergy(this.energyStorage, sink, (int)amount * 4);
            }
        } else {
            this.ic2EnergySource.addEnergy(amount);
        }
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energyStorage;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

