/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui;

import java.io.IOException;
import javax.annotation.Nonnull;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.satpipe.SatelliteSetNamePacket;
import logisticspipes.pipes.SatelliteNamingResult;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.InputBar;
import logisticspipes.utils.gui.LogisticsBaseGuiScreen;
import logisticspipes.utils.gui.SmallGuiButton;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import network.rs485.logisticspipes.SatellitePipe;
import org.lwjgl.input.Keyboard;

public class GuiSatellitePipe
extends LogisticsBaseGuiScreen {
    @Nonnull
    private final SatellitePipe satellitePipe;
    @Nonnull
    private String response = "";
    private InputBar input;

    public GuiSatellitePipe(@Nonnull SatellitePipe satellitePipe) {
        super(new Container(){

            public boolean func_75145_c(@Nonnull EntityPlayer entityplayer) {
                return true;
            }
        });
        this.field_146999_f = 116;
        this.field_147000_g = 77;
        this.satellitePipe = satellitePipe;
    }

    @Override
    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        super.func_73866_w_();
        this.field_146292_n.add(new SmallGuiButton(0, this.field_146294_l / 2 - 15 + 35, this.field_146295_m / 2 + 20, 30, 10, "Save"));
        this.input = new InputBar(this.field_146289_q, this, this.field_147003_i + 8, this.field_147009_r + 40, 100, 16);
    }

    @Override
    public void closeGui() throws IOException {
        super.closeGui();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        if (guibutton.field_146127_k == 0) {
            TileEntity container = this.satellitePipe.getContainer();
            if (container != null) {
                MainProxy.sendPacketToServer(PacketHandler.getPacket(SatelliteSetNamePacket.class).setString(this.input.func_146179_b()).setTilePos(container));
            }
        } else {
            super.func_146284_a(guibutton);
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        this.drawCenteredString(StringUtils.translate("gui.satellite.SatelliteName"), 59, 7, 0x404040);
        String name = StringUtils.getCuttedString(this.satellitePipe.getSatellitePipeName(), 100, this.field_146297_k.field_71466_p);
        int yOffset = 0;
        if (!this.response.isEmpty()) {
            this.drawCenteredString(StringUtils.translate("gui.satellite.naming_result." + this.response), this.field_146999_f / 2, 30, this.response.equals("success") ? 0x404040 : 0x5C1111);
            yOffset = 4;
        }
        this.drawCenteredString(name, this.field_146999_f / 2, 24 - yOffset, 0x404040);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        super.func_146976_a(f, x, y);
        GuiGraphics.drawGuiBackGround(this.field_146297_k, this.field_147003_i, this.field_147009_r, this.right, this.bottom, this.field_73735_i, true);
        this.input.func_146194_f();
    }

    @Override
    protected void func_73864_a(int x, int y, int k) throws IOException {
        if (!this.input.handleClick(x, y, k)) {
            super.func_73864_a(x, y, k);
        }
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (!this.input.handleKey(c, i)) {
            super.func_73869_a(c, i);
        }
    }

    public void handleResponse(SatelliteNamingResult result2, String newName) {
        this.response = result2.toString();
        if (result2 == SatelliteNamingResult.SUCCESS) {
            this.satellitePipe.setSatellitePipeName(newName);
        }
    }
}

