/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.hud;

import javax.annotation.Nonnull;
import logisticspipes.gui.hud.BasicHUDGui;
import logisticspipes.interfaces.IHUDConfig;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.hud.BasicHUDButton;
import logisticspipes.utils.item.ItemStackRenderer;
import net.minecraft.client.Minecraft;
import network.rs485.logisticspipes.SatellitePipe;
import org.lwjgl.opengl.GL11;

public class HUDSatellite
extends BasicHUDGui {
    @Nonnull
    private final SatellitePipe pipe;
    private int page;

    public HUDSatellite(@Nonnull SatellitePipe pipe) {
        this.pipe = pipe;
        this.addButton(new BasicHUDButton("<", -2, -40, 8, 8){

            @Override
            public void clicked() {
                if (HUDSatellite.this.page > 0) {
                    HUDSatellite.this.page--;
                }
            }

            @Override
            public boolean shouldRenderButton() {
                return HUDSatellite.this.pipe.getItemList().size() > 0;
            }

            @Override
            public boolean buttonEnabled() {
                return HUDSatellite.this.page > 0;
            }
        });
        this.addButton(new BasicHUDButton(">", 37, -40, 8, 8){

            @Override
            public void clicked() {
                if (HUDSatellite.this.page + 1 < HUDSatellite.this.getMaxPage()) {
                    HUDSatellite.this.page++;
                }
            }

            @Override
            public boolean shouldRenderButton() {
                return HUDSatellite.this.pipe.getItemList().size() > 0;
            }

            @Override
            public boolean buttonEnabled() {
                return HUDSatellite.this.page + 1 < HUDSatellite.this.getMaxPage();
            }
        });
    }

    @Override
    public void renderHeadUpDisplay(double distance, boolean day, boolean shifted, Minecraft mc, IHUDConfig config) {
        if (this.pipe.getItemList().size() > 0) {
            if (day) {
                GL11.glColor4b((byte)64, (byte)64, (byte)64, (byte)64);
            } else {
                GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)64);
            }
            GuiGraphics.drawGuiBackGround(mc, -50, -50, 50, 50, 0.0f, false);
            if (day) {
                GL11.glColor4b((byte)64, (byte)64, (byte)64, (byte)127);
            } else {
                GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)127);
            }
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
            super.renderHeadUpDisplay(distance, day, shifted, mc, config);
            String message = this.pipe.getSatellitePipeName();
            if (mc.field_71466_p.func_78256_a(message) > 40) {
                GL11.glScalef((float)0.45f, (float)0.45f, (float)1.0E-4f);
                mc.field_71466_p.func_78276_b(message, -100, -85, 0);
                GL11.glScalef((float)2.2222223f, (float)2.2222223f, (float)1.0f);
            } else {
                GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0E-4f);
                mc.field_71466_p.func_78276_b(message, -42, -40, 0);
            }
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
            GL11.glScalef((float)0.8f, (float)0.8f, (float)-1.0f);
            ItemStackRenderer.renderItemIdentifierStackListIntoGui(this.pipe.getItemList(), null, this.page, -35, -20, 4, 12, 18, 18, 100.0f, ItemStackRenderer.DisplayAmount.ALWAYS, false, shifted);
            GL11.glScalef((float)0.8f, (float)0.8f, (float)-1.0f);
            message = String.format("(%d/%d)", this.page + 1, this.getMaxPage());
            mc.field_71466_p.func_78276_b(message, 9, -41, 0);
        } else {
            if (day) {
                GL11.glColor4b((byte)64, (byte)64, (byte)64, (byte)64);
            } else {
                GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)64);
            }
            GuiGraphics.drawGuiBackGround(mc, -50, -15, 50, 20, 0.0f, false);
            if (day) {
                GL11.glColor4b((byte)64, (byte)64, (byte)64, (byte)127);
            } else {
                GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)127);
            }
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
            super.renderHeadUpDisplay(distance, day, shifted, mc, config);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0E-4f);
            String message = this.pipe.getSatellitePipeName();
            mc.field_71466_p.func_78276_b(message, -(mc.field_71466_p.func_78256_a(message) / 2), -2, 0);
        }
    }

    public int getMaxPage() {
        int ret = this.pipe.getItemList().size() / 12;
        if (this.pipe.getItemList().size() % 12 != 0 || ret == 0) {
            ++ret;
        }
        return ret;
    }

    @Override
    public boolean display(IHUDConfig config) {
        return config.isHUDSatellite();
    }

    @Override
    public boolean cursorOnWindow(int x, int y) {
        if (this.pipe.getItemList().size() > 0) {
            return -50 < x && x < 50 && -50 < y && y < 50;
        }
        return -50 < x && x < 50 && -15 < y && y < 20;
    }
}

