/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.guis.pipe.ChassiGuiProvider;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.proxy.computers.objects.CCSinkResponder;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import network.rs485.logisticspipes.module.Gui;

public class ChassiModule
extends LogisticsModule
implements Gui {
    private final LogisticsModule[] modules;
    private final PipeLogisticsChassi parentChassis;

    public ChassiModule(int moduleCount, PipeLogisticsChassi parentChassis) {
        this.modules = new LogisticsModule[moduleCount];
        this.parentChassis = parentChassis;
        this.registerPosition(LogisticsModule.ModulePositionType.IN_PIPE, 0);
    }

    public void installModule(int slot, LogisticsModule module) {
        this.modules[slot] = module;
    }

    public void removeModule(int slot) {
        this.modules[slot] = null;
    }

    public LogisticsModule getModule(int slot) {
        return this.modules[slot];
    }

    public boolean hasModule(int slot) {
        return this.modules[slot] != null;
    }

    public LogisticsModule[] getModules() {
        return this.modules;
    }

    @Override
    public SinkReply sinksItem(@Nonnull ItemStack stack, ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit, boolean forcePassive) {
        int roomForItem;
        SinkReply bestresult = null;
        for (LogisticsModule module : this.modules) {
            SinkReply result2;
            if (module == null || forcePassive && !module.recievePassive() || (result2 = module.sinksItem(stack, item, bestPriority, bestCustomPriority, allowDefault, includeInTransit, forcePassive)) == null || result2.maxNumberOfItems < 0) continue;
            bestresult = result2;
            bestPriority = result2.fixedPriority.ordinal();
            bestCustomPriority = result2.customPriority;
        }
        if (bestresult == null) {
            return null;
        }
        IInventoryUtil invUtil = this.parentChassis.getSneakyInventory(LogisticsModule.ModulePositionType.SLOT, ((PipeLogisticsChassi.ChassiTargetInformation)bestresult.addInfo).getModuleSlot());
        if (invUtil == null) {
            return null;
        }
        if (includeInTransit) {
            int onRoute = this.parentChassis.countOnRoute(item);
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(onRoute + item.getMaxStackSize());
            roomForItem = invUtil.roomForItem(copy);
            roomForItem -= onRoute;
        } else {
            roomForItem = invUtil.roomForItem(stack);
        }
        if (roomForItem < 1) {
            return null;
        }
        if (bestresult.maxNumberOfItems == 0) {
            return new SinkReply(bestresult, roomForItem);
        }
        return new SinkReply(bestresult, Math.min(bestresult.maxNumberOfItems, roomForItem));
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbttagcompound) {
        for (int i = 0; i < this.modules.length; ++i) {
            NBTTagCompound slot;
            if (this.modules[i] == null || (slot = nbttagcompound.func_74775_l("slot" + i)) == null) continue;
            this.modules[i].readFromNBT(slot);
        }
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbttagcompound) {
        for (int i = 0; i < this.modules.length; ++i) {
            if (this.modules[i] == null) continue;
            NBTTagCompound slot = new NBTTagCompound();
            this.modules[i].writeToNBT(slot);
            nbttagcompound.func_74782_a("slot" + i, (NBTBase)slot);
        }
    }

    @Override
    public void tick() {
        for (LogisticsModule module : this.modules) {
            if (module == null) continue;
            module.tick();
        }
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        for (LogisticsModule module : this.modules) {
            if (module == null || !module.recievePassive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<CCSinkResponder> queueCCSinkEvent(ItemIdentifierStack item) {
        ArrayList<CCSinkResponder> list = new ArrayList<CCSinkResponder>();
        for (LogisticsModule module : this.modules) {
            if (module == null) continue;
            list.addAll(module.queueCCSinkEvent(item));
        }
        return list;
    }

    @Override
    @Nonnull
    public ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        return NewGuiHandler.getGui(ChassiGuiProvider.class).setFlag(this.parentChassis.getUpgradeManager().hasUpgradeModuleUpgrade());
    }

    @Override
    @Nonnull
    public ModuleInHandGuiProvider getInHandGuiProvider() {
        throw new UnsupportedOperationException("Chassis GUI can never be opened in hand");
    }
}

