/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IModuleInventoryReceive;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.ISlotUpgradeManager;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.interfaces.routing.ITargetSlotInformation;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.module.inhand.ActiveSupplierInHand;
import logisticspipes.network.guis.module.inpipe.ActiveSupplierSlot;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.module.ModuleInventory;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.pipes.basic.debug.StatusEntry;
import logisticspipes.proxy.MainProxy;
import logisticspipes.request.RequestTree;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.connection.NeighborTileEntity;
import network.rs485.logisticspipes.module.Gui;
import network.rs485.logisticspipes.world.WorldCoordinatesWrapper;

public class ModuleActiveSupplier
extends LogisticsModule
implements IRequestItems,
IRequireReliableTransport,
IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver,
IModuleInventoryReceive,
ISimpleInventoryEventHandler,
Gui {
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private final HashMap<ItemIdentifier, Integer> _requestedItems = new HashMap();
    public int[] slotArray = new int[9];
    private boolean _lastRequestFailed = false;
    private ItemIdentifierInventory dummyInventory = new ItemIdentifierInventory(9, "", 127);
    private SupplyMode _requestMode = SupplyMode.Bulk50;
    private PatternMode _patternMode = PatternMode.Bulk50;
    private boolean isLimited = true;

    public ModuleActiveSupplier() {
        this.dummyInventory.addListener(this);
    }

    public static String getName() {
        return "active_supplier";
    }

    @Override
    @Nonnull
    public List<String> getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Supplied: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ModuleInventory.class).setIdentList(ItemIdentifierStack.getListFromInventory(this.dummyInventory)).setModulePos(this), player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return null;
    }

    @Override
    public void handleInvContent(Collection<ItemIdentifierStack> list) {
        this.dummyInventory.handleItemIdentifierList(list);
    }

    @Override
    public void InventoryChanged(IInventory inventory) {
        if (MainProxy.isServer((IBlockAccess)this._world.getWorld())) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ModuleInventory.class).setIdentList(ItemIdentifierStack.getListFromInventory(this.dummyInventory)).setModulePos(this), this.localModeWatchers);
        }
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    public boolean isRequestFailed() {
        return this._lastRequestFailed;
    }

    public void setRequestFailed(boolean value) {
        this._lastRequestFailed = value;
    }

    public ItemIdentifierInventory getDummyInventory() {
        return this.dummyInventory;
    }

    @Override
    public void tick() {
        if (!this._service.isNthTick(100)) {
            return;
        }
        this._requestedItems.values().stream().filter(amount -> amount > 0).forEach(amount -> this._service.spawnParticle(Particles.VioletParticle, 2));
        WorldCoordinatesWrapper worldCoordinates = new WorldCoordinatesWrapper(this._world.getWorld(), this.getBlockPos());
        worldCoordinates.connectedTileEntities(IPipeInformationProvider.ConnectionPipeType.ITEM).filter(adjacent -> !adjacent.isLogisticsPipe()).map(neighbor -> neighbor.sneakyInsertion().from(this.getUpgradeManager())).map(NeighborTileEntity::getInventoryUtil).filter(Objects::nonNull).filter(invUtil -> invUtil.getSizeInventory() > 0).forEach(invUtil -> {
            if (this.getUpgradeManager().hasPatternUpgrade()) {
                this.createPatternRequest((IInventoryUtil)invUtil);
            } else {
                this.createSupplyRequest((IInventoryUtil)invUtil);
            }
        });
    }

    private void createPatternRequest(IInventoryUtil invUtil) {
        this._service.getDebug().log("Supplier: Start calculating pattern request");
        this.setRequestFailed(false);
        for (int i = 0; i < 9; ++i) {
            int neededCount;
            ItemIdentifierStack needed = this.dummyInventory.getIDStackInSlot(i);
            if (needed == null || invUtil.getSizeInventory() <= this.slotArray[i]) continue;
            ItemStack stack = invUtil.getStackInSlot(this.slotArray[i]);
            ItemIdentifierStack have = null;
            if (!stack.func_190926_b()) {
                have = ItemIdentifierStack.getFromStack(stack);
            }
            int haveCount = 0;
            if (have != null) {
                if (!have.getItem().equals(needed.getItem())) {
                    this._service.getDebug().log("Supplier: Slot for " + i + ", " + needed + " already taken by " + have);
                    this.setRequestFailed(true);
                    continue;
                }
                haveCount = have.getStackSize();
            }
            if (this._patternMode == PatternMode.Bulk50 && haveCount > needed.getStackSize() / 2 || this._patternMode == PatternMode.Bulk100 && haveCount >= needed.getStackSize()) continue;
            Integer requestedCount = this._requestedItems.get(needed.getItem());
            if (requestedCount != null) {
                haveCount += requestedCount.intValue();
            }
            if ((neededCount = needed.getStackSize() - haveCount) < 1) continue;
            ItemIdentifierStack toRequest = new ItemIdentifierStack(needed.getItem(), neededCount);
            this._service.getDebug().log("Supplier: Missing for slot " + i + ": " + toRequest);
            if (!this._service.useEnergy(10)) break;
            boolean success = false;
            PatternSupplierTargetInformation targetInformation = new PatternSupplierTargetInformation(this.slotArray[i], needed.getStackSize());
            if (this._patternMode != PatternMode.Full) {
                this._service.getDebug().log("Supplier: Requesting partial: " + toRequest);
                neededCount = RequestTree.requestPartial(toRequest, this, targetInformation);
                this._service.getDebug().log("Supplier: Requested: " + toRequest.getItem().makeStack(neededCount));
                if (neededCount > 0) {
                    success = true;
                }
            } else {
                this._service.getDebug().log("Supplier: Requesting: " + toRequest);
                success = RequestTree.request(toRequest, this, null, targetInformation);
                if (success) {
                    this._service.getDebug().log("Supplier: Request success");
                } else {
                    this._service.getDebug().log("Supplier: Request failed");
                }
            }
            if (success) {
                Integer currentRequest = this._requestedItems.get(toRequest.getItem());
                if (currentRequest == null) {
                    this._requestedItems.put(toRequest.getItem(), neededCount);
                    continue;
                }
                this._requestedItems.put(toRequest.getItem(), currentRequest + neededCount);
                continue;
            }
            this.setRequestFailed(true);
        }
    }

    private void createSupplyRequest(IInventoryUtil invUtil) {
        this._service.getDebug().log("Supplier: Start calculating supply request");
        HashMap<ItemIdentifier, Integer> needed = new HashMap<ItemIdentifier, Integer>(this.dummyInventory.getItemsAndCount());
        this._service.getDebug().log("Supplier: Needed: " + needed);
        Map<ItemIdentifier, Integer> have = invUtil.getItemsAndCount();
        this._service.getDebug().log("Supplier: Have:   " + have);
        HashMap<ItemIdentifier, Integer> haveUndamaged = new HashMap<ItemIdentifier, Integer>();
        for (Map.Entry<ItemIdentifier, Integer> item : have.entrySet()) {
            haveUndamaged.merge(item.getKey().getUndamaged(), item.getValue(), (a, b) -> a + b);
        }
        for (Map.Entry<ItemIdentifier, Integer> item : needed.entrySet()) {
            Integer requestedCount;
            Integer haveCount = (Integer)haveUndamaged.get(item.getKey().getUndamaged());
            if (haveCount == null) {
                haveCount = 0;
            }
            int spaceAvailable = invUtil.roomForItem(item.getKey().unsafeMakeNormalStack(Integer.MAX_VALUE));
            if (this._requestMode == SupplyMode.Infinite) {
                requestedCount = this._requestedItems.get(item.getKey());
                if (requestedCount != null) {
                    spaceAvailable -= requestedCount.intValue();
                }
                item.setValue(Math.min(item.getKey().getMaxStackSize(), Math.max(0, spaceAvailable)));
                continue;
            }
            if (spaceAvailable < 1 || this._requestMode == SupplyMode.Bulk50 && haveCount > item.getValue() / 2 || this._requestMode == SupplyMode.Bulk100 && haveCount >= item.getValue()) {
                item.setValue(0);
                continue;
            }
            if (haveCount > 0) {
                item.setValue(item.getValue() - haveCount);
                haveUndamaged.put(item.getKey().getUndamaged(), haveCount - item.getValue());
            }
            if ((requestedCount = this._requestedItems.get(item.getKey())) == null) continue;
            item.setValue(item.getValue() - requestedCount);
        }
        this._service.getDebug().log("Supplier: Missing:   " + needed);
        this.setRequestFailed(false);
        for (Map.Entry<ItemIdentifier, Integer> need : needed.entrySet()) {
            Integer amountRequested = need.getValue();
            if (amountRequested == null || amountRequested < 1) continue;
            int neededCount = amountRequested;
            if (!this._service.useEnergy(10)) break;
            boolean success = false;
            SupplierTargetInformation targetInformation = new SupplierTargetInformation();
            if (this._requestMode != SupplyMode.Full) {
                this._service.getDebug().log("Supplier: Requesting partial: " + need.getKey().makeStack(neededCount));
                neededCount = RequestTree.requestPartial(need.getKey().makeStack(neededCount), this, targetInformation);
                this._service.getDebug().log("Supplier: Requested: " + need.getKey().makeStack(neededCount));
                if (neededCount > 0) {
                    success = true;
                }
            } else {
                this._service.getDebug().log("Supplier: Requesting: " + need.getKey().makeStack(neededCount));
                success = RequestTree.request(need.getKey().makeStack(neededCount), this, null, targetInformation);
                if (success) {
                    this._service.getDebug().log("Supplier: Request success");
                } else {
                    this._service.getDebug().log("Supplier: Request failed");
                }
            }
            if (success) {
                Integer currentRequest = this._requestedItems.get(need.getKey());
                if (currentRequest == null) {
                    this._requestedItems.put(need.getKey(), neededCount);
                    this._service.getDebug().log("Supplier: Inserting Requested Items: " + neededCount);
                    continue;
                }
                this._requestedItems.put(need.getKey(), currentRequest + neededCount);
                this._service.getDebug().log("Supplier: Raising Requested Items from: " + currentRequest + " to: " + currentRequest + neededCount);
                continue;
            }
            this.setRequestFailed(true);
        }
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbttagcompound) {
        this.dummyInventory.readFromNBT(nbttagcompound, "");
        if (nbttagcompound.func_74764_b("requestmode")) {
            this._requestMode = SupplyMode.values()[nbttagcompound.func_74765_d("requestmode")];
        }
        if (nbttagcompound.func_74764_b("patternmode")) {
            this._patternMode = PatternMode.values()[nbttagcompound.func_74765_d("patternmode")];
        }
        if (nbttagcompound.func_74764_b("limited")) {
            this.setLimited(nbttagcompound.func_74767_n("limited"));
        }
        if (nbttagcompound.func_74764_b("requestpartials")) {
            boolean oldPartials = nbttagcompound.func_74767_n("requestpartials");
            this._requestMode = oldPartials ? SupplyMode.Partial : SupplyMode.Full;
        }
        for (int i = 0; i < 9; ++i) {
            this.slotArray[i] = nbttagcompound.func_74762_e("slotArray_" + i);
        }
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbttagcompound) {
        this.dummyInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.func_74777_a("requestmode", (short)this._requestMode.ordinal());
        nbttagcompound.func_74777_a("patternmode", (short)this._patternMode.ordinal());
        nbttagcompound.func_74757_a("limited", this.isLimited());
        for (int i = 0; i < 9; ++i) {
            nbttagcompound.func_74768_a("slotArray_" + i, this.slotArray[i]);
        }
    }

    private void decreaseRequested(ItemIdentifierStack item) {
        int remaining = item.getStackSize();
        Integer count2 = this._requestedItems.get(item.getItem());
        if (count2 != null) {
            this._service.getDebug().log("Supplier: Exact match. Still missing: " + Math.max(0, count2 - remaining));
            if (count2 - remaining > 0) {
                this._requestedItems.put(item.getItem(), count2 - remaining);
            } else {
                this._requestedItems.remove(item.getItem());
            }
            remaining -= count2.intValue();
        }
        if (remaining <= 0) {
            return;
        }
        Iterator<Map.Entry<ItemIdentifier, Integer>> it = this._requestedItems.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ItemIdentifier, Integer> e = it.next();
            if (e.getKey().equalsWithoutNBT(item.getItem())) {
                int expected = e.getValue();
                this._service.getDebug().log("Supplier: Fuzzy match with" + e + ". Still missing: " + Math.max(0, expected - remaining));
                if (expected - remaining > 0) {
                    e.setValue(expected - remaining);
                } else {
                    it.remove();
                }
                remaining -= expected;
            }
            if (remaining > 0) continue;
            return;
        }
        this._service.getDebug().log("Supplier: supplier got unexpected item " + item.toString());
    }

    @Override
    public void itemLost(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        this._service.getDebug().log("Supplier: Registered Item Lost: " + item);
        this.decreaseRequested(item);
    }

    @Override
    public void itemArrived(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        this._service.getDebug().log("Supplier: Registered Item Arrived: " + item);
        this.decreaseRequested(item);
    }

    public SupplyMode getSupplyMode() {
        return this._requestMode;
    }

    public void setSupplyMode(SupplyMode mode) {
        this._requestMode = mode;
    }

    public PatternMode getPatternMode() {
        return this._patternMode;
    }

    public void setPatternMode(PatternMode mode) {
        this._patternMode = mode;
    }

    public int[] getSlotsForItemIdentifier(ItemIdentifier item) {
        int size = 0;
        for (int i = 0; i < 9; ++i) {
            if (this.dummyInventory.getIDStackInSlot(i) == null || !this.dummyInventory.getIDStackInSlot(i).getItem().equals(item)) continue;
            ++size;
        }
        int[] array = new int[size];
        int pos = 0;
        for (int i = 0; i < 9; ++i) {
            if (this.dummyInventory.getIDStackInSlot(i) == null || !this.dummyInventory.getIDStackInSlot(i).getItem().equals(item)) continue;
            array[pos++] = i;
        }
        return array;
    }

    public int getInvSlotForSlot(int i) {
        return this.slotArray[i];
    }

    public int getAmountForSlot(int i) {
        return this.dummyInventory.getIDStackInSlot(i).getStackSize();
    }

    public void addStatusInformation(List<StatusEntry> status) {
        StatusEntry entry = new StatusEntry();
        entry.name = "Requested Items";
        entry.subEntry = new ArrayList<StatusEntry>();
        for (Map.Entry<ItemIdentifier, Integer> part : this._requestedItems.entrySet()) {
            StatusEntry subEntry = new StatusEntry();
            subEntry.name = part.toString();
            entry.subEntry.add(subEntry);
        }
        status.add(entry);
    }

    @Override
    @Nonnull
    public ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        boolean hasPatternUpgrade = this.hasPatternUpgrade();
        return NewGuiHandler.getGui(ActiveSupplierSlot.class).setPatternUpgarde(hasPatternUpgrade).setSlotArray(this.slotArray).setMode((hasPatternUpgrade ? this.getPatternMode() : this.getSupplyMode()).ordinal()).setLimit(this.isLimited);
    }

    @Override
    @Nonnull
    public ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(ActiveSupplierInHand.class);
    }

    @Override
    @Nonnull
    public IRouter getRouter() {
        return this._service.getRouter();
    }

    @Override
    public void itemCouldNotBeSend(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        this.itemLost(item, info);
    }

    @Override
    public int getID() {
        return this._service.getRouter().getSimpleID();
    }

    @Override
    public int compareTo(IRequestItems value2) {
        return 0;
    }

    public boolean hasPatternUpgrade() {
        ISlotUpgradeManager upgradeManager = this.getUpgradeManager();
        if (upgradeManager != null) {
            return upgradeManager.hasPatternUpgrade();
        }
        return false;
    }

    public boolean isLimited() {
        return this.isLimited;
    }

    public ModuleActiveSupplier setLimited(boolean isLimited) {
        this.isLimited = isLimited;
        return this;
    }

    public class SupplierTargetInformation
    extends PipeLogisticsChassi.ChassiTargetInformation {
        public SupplierTargetInformation() {
            super(ModuleActiveSupplier.this.getPositionInt());
        }
    }

    public class PatternSupplierTargetInformation
    extends SupplierTargetInformation
    implements ITargetSlotInformation {
        private final int amount;
        private final int targetSlot;

        public PatternSupplierTargetInformation(int targetSlot, int amount) {
            this.targetSlot = targetSlot;
            this.amount = amount;
        }

        @Override
        public int getTargetSlot() {
            return this.targetSlot;
        }

        @Override
        public int getAmount() {
            return this.amount;
        }

        @Override
        public boolean isLimited() {
            return ModuleActiveSupplier.this.isLimited();
        }
    }

    public static enum PatternMode {
        Partial,
        Full,
        Bulk50,
        Bulk100;

    }

    public static enum SupplyMode {
        Partial,
        Full,
        Bulk50,
        Bulk100,
        Infinite;

    }
}

