/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.DelayQueue;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import logisticspipes.blocks.crafting.LogisticsCraftingTableTileEntity;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.interfaces.ISlotUpgradeManager;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IItemSpaceControl;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.logistics.LogisticsManager;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.abstractpackets.ModuleCoordinatesPacket;
import logisticspipes.network.guis.module.inhand.CraftingModuleInHand;
import logisticspipes.network.guis.module.inpipe.CraftingModuleSlot;
import logisticspipes.network.packets.cpipe.CPipeSatelliteImport;
import logisticspipes.network.packets.cpipe.CPipeSatelliteImportBack;
import logisticspipes.network.packets.cpipe.CraftingPipeOpenConnectedGuiPacket;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.pipe.CraftingPipePriorityDownPacket;
import logisticspipes.network.packets.pipe.CraftingPipePriorityUpPacket;
import logisticspipes.network.packets.pipe.CraftingPipeUpdatePacket;
import logisticspipes.network.packets.pipe.CraftingPriority;
import logisticspipes.network.packets.pipe.FluidCraftingAmount;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.PipeFluidSatellite;
import logisticspipes.pipes.PipeItemsCraftingLogistics;
import logisticspipes.pipes.PipeItemsSatelliteLogistics;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.interfaces.ICraftingRecipeProvider;
import logisticspipes.proxy.interfaces.IFuzzyRecipeProvider;
import logisticspipes.request.DictCraftingTemplate;
import logisticspipes.request.ICraftingTemplate;
import logisticspipes.request.IPromise;
import logisticspipes.request.IReqCraftingTemplate;
import logisticspipes.request.ItemCraftingTemplate;
import logisticspipes.request.RequestTree;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.request.resources.DictResource;
import logisticspipes.request.resources.FluidResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ItemResource;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.LogisticsDictPromise;
import logisticspipes.routing.LogisticsExtraDictPromise;
import logisticspipes.routing.LogisticsExtraPromise;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsItemOrder;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.CacheHolder;
import logisticspipes.utils.DelayedGeneric;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.connection.NeighborTileEntity;
import network.rs485.logisticspipes.module.Gui;
import network.rs485.logisticspipes.world.WorldCoordinatesWrapper;

public class ModuleCrafter
extends LogisticsModule
implements ICraftItems,
IHUDModuleHandler,
IModuleWatchReciver,
IGuiOpenControler,
Gui {
    protected final DelayQueue<DelayedGeneric<Pair<ItemIdentifierStack, IAdditionalTargetInformation>>> _lostItems = new DelayQueue();
    protected final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    protected final PlayerCollectionList guiWatcher = new PlayerCollectionList();
    public UUID satelliteUUID = null;
    public UUID[] advancedSatelliteUUIDArray = new UUID[9];
    public UUID liquidSatelliteUUID = null;
    public UUID[] liquidSatelliteUUIDArray = new UUID[3];
    public DictResource[] fuzzyCraftingFlagArray = new DictResource[9];
    public DictResource outputFuzzyFlags = new DictResource(null, null);
    public int priority = 0;
    public boolean[] craftingSigns = new boolean[6];
    public boolean waitingForCraft = false;
    public boolean cleanupModeIsExclude = true;
    public ClientSideSatelliteNames clientSideSatelliteNames = new ClientSideSatelliteNames();
    protected ItemIdentifierInventory _dummyInventory = new ItemIdentifierInventory(11, "Requested items", 127);
    protected ItemIdentifierInventory _liquidInventory = new ItemIdentifierInventory(3, "Fluid items", 1, true);
    protected ItemIdentifierInventory _cleanupInventory = new ItemIdentifierInventory(12, "Cleanup Filter Items", 1);
    protected int[] amount = new int[3];
    protected SinkReply _sinkReply;
    private IRequestItems _invRequester;
    private WeakReference<TileEntity> lastAccessedCrafter = new WeakReference<Object>(null);
    private boolean cachedAreAllOrderesToBuffer;
    private List<NeighborTileEntity<TileEntity>> cachedCrafters = null;
    private UpgradeSatelliteFromIDs updateSatelliteFromIDs = null;

    public ModuleCrafter() {
        for (int i = 0; i < this.fuzzyCraftingFlagArray.length; ++i) {
            this.fuzzyCraftingFlagArray[i] = new DictResource(null, null);
        }
    }

    public ModuleCrafter(PipeItemsCraftingLogistics parent) {
        this._service = parent;
        this._invRequester = parent;
        this._world = parent;
        this.registerPosition(LogisticsModule.ModulePositionType.IN_PIPE, 0);
        for (int i = 0; i < this.fuzzyCraftingFlagArray.length; ++i) {
            this.fuzzyCraftingFlagArray[i] = new DictResource(null, null);
        }
    }

    public static String getName() {
        return "crafter";
    }

    @Override
    public void registerHandler(IWorldProvider world, IPipeServiceProvider service) {
        super.registerHandler(world, service);
        this._invRequester = (IRequestItems)((Object)service);
    }

    @Override
    public void registerPosition(LogisticsModule.ModulePositionType slot, int positionInt) {
        super.registerPosition(slot, positionInt);
        this._sinkReply = new SinkReply(SinkReply.FixedPriority.ItemSink, 0, true, false, 1, 0, new PipeLogisticsChassi.ChassiTargetInformation(this.getPositionInt()));
    }

    @Override
    public SinkReply sinksItem(@Nonnull ItemStack stack, ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit, boolean forcePassive) {
        if (bestPriority > this._sinkReply.fixedPriority.ordinal() || bestPriority == this._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReply.customPriority) {
            return null;
        }
        int itemCount = this.spaceFor(stack, item, includeInTransit);
        if (itemCount > 0) {
            return new SinkReply(this._sinkReply, itemCount, this.areAllOrderesToBuffer() ? SinkReply.BufferMode.DESTINATION_BUFFERED : SinkReply.BufferMode.NONE);
        }
        return null;
    }

    protected int spaceFor(@Nonnull ItemStack stack, ItemIdentifier item, boolean includeInTransit) {
        Pair<String, ItemIdentifier> key = new Pair<String, ItemIdentifier>("spaceFor", item);
        Object cache = this._service.getCacheHolder().getCacheFor(CacheHolder.CacheTypes.Inventory, key);
        int onRoute = 0;
        if (includeInTransit) {
            onRoute = this._service.countOnRoute(item);
        }
        if (cache != null) {
            return (Integer)cache - onRoute;
        }
        WorldCoordinatesWrapper worldCoordinates = new WorldCoordinatesWrapper(this._world.getWorld(), this.getBlockPos());
        if (includeInTransit) {
            stack = stack.func_77946_l();
            stack.func_190917_f(onRoute);
        }
        ItemStack finalStack = stack;
        int count2 = worldCoordinates.connectedTileEntities(IPipeInformationProvider.ConnectionPipeType.ITEM).map(neighbor -> neighbor.sneakyInsertion().from(this.getUpgradeManager())).filter(NeighborTileEntity::isItemHandler).map(NeighborTileEntity::getUtilForItemHandler).map(invUtil -> invUtil.roomForItem(finalStack)).reduce(Integer::sum).orElse(0);
        this._service.getCacheHolder().setCache(CacheHolder.CacheTypes.Inventory, key, count2);
        return count2 - onRoute;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int amount) {
        this.priority = amount;
    }

    public void onAllowedRemoval() {
    }

    private UUID getUUIDForSatelliteName(String name) {
        for (PipeItemsSatelliteLogistics pipe : PipeItemsSatelliteLogistics.AllSatellites) {
            if (!pipe.getSatellitePipeName().equals(name)) continue;
            return pipe.getRouter().getId();
        }
        return null;
    }

    private UUID getUUIDForFluidSatelliteName(String name) {
        for (PipeFluidSatellite pipe : PipeFluidSatellite.AllSatellites) {
            if (!pipe.getSatellitePipeName().equals(name)) continue;
            return pipe.getRouter().getId();
        }
        return null;
    }

    @Override
    public void tick() {
        this.enabledUpdateEntity();
        if (this.updateSatelliteFromIDs != null && this._service.isNthTick(100)) {
            UUID uuid;
            UUID uuid2;
            int i;
            boolean canBeRemoved;
            if (this.updateSatelliteFromIDs.advancedSatelliteIdArray != null) {
                canBeRemoved = true;
                for (i = 0; i < this.updateSatelliteFromIDs.advancedSatelliteIdArray.length; ++i) {
                    if (this.updateSatelliteFromIDs.advancedSatelliteIdArray[i] == -1) continue;
                    uuid2 = this.getUUIDForSatelliteName(Integer.toString(this.updateSatelliteFromIDs.advancedSatelliteIdArray[i]));
                    if (uuid2 != null) {
                        this.updateSatelliteFromIDs.advancedSatelliteIdArray[i] = -1;
                        this.advancedSatelliteUUIDArray[i] = uuid2;
                        continue;
                    }
                    canBeRemoved = false;
                }
                if (canBeRemoved) {
                    this.updateSatelliteFromIDs.advancedSatelliteIdArray = null;
                }
            }
            if (this.updateSatelliteFromIDs.liquidSatelliteIdArray != null) {
                canBeRemoved = true;
                for (i = 0; i < this.updateSatelliteFromIDs.liquidSatelliteIdArray.length; ++i) {
                    if (this.updateSatelliteFromIDs.liquidSatelliteIdArray[i] == -1) continue;
                    uuid2 = this.getUUIDForFluidSatelliteName(Integer.toString(this.updateSatelliteFromIDs.liquidSatelliteIdArray[i]));
                    if (uuid2 != null) {
                        this.updateSatelliteFromIDs.liquidSatelliteIdArray[i] = -1;
                        this.liquidSatelliteUUIDArray[i] = uuid2;
                        continue;
                    }
                    canBeRemoved = false;
                }
                if (canBeRemoved) {
                    this.updateSatelliteFromIDs.liquidSatelliteIdArray = null;
                }
            }
            if (this.updateSatelliteFromIDs.liquidSatelliteId != -1 && (uuid = this.getUUIDForFluidSatelliteName(Integer.toString(this.updateSatelliteFromIDs.liquidSatelliteId))) != null) {
                this.updateSatelliteFromIDs.liquidSatelliteId = -1;
                this.liquidSatelliteUUID = uuid;
            }
            if (this.updateSatelliteFromIDs.satelliteId != -1 && (uuid = this.getUUIDForFluidSatelliteName(Integer.toString(this.updateSatelliteFromIDs.satelliteId))) != null) {
                this.updateSatelliteFromIDs.satelliteId = -1;
                this.satelliteUUID = uuid;
            }
            if (this.updateSatelliteFromIDs.advancedSatelliteIdArray == null && this.updateSatelliteFromIDs.liquidSatelliteId == -1 && this.updateSatelliteFromIDs.liquidSatelliteIdArray == null && this.updateSatelliteFromIDs.satelliteId == -1) {
                this.updateSatelliteFromIDs = null;
            }
        }
        if (this._lostItems.isEmpty()) {
            return;
        }
        DelayedGeneric lostItem = (DelayedGeneric)this._lostItems.poll();
        int rerequested = 0;
        while (lostItem != null && rerequested < 100) {
            SinkReply reply;
            Pair pair = (Pair)lostItem.get();
            if (this._service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.CRAFTING) && ((reply = LogisticsManager.canSink(((ItemIdentifierStack)pair.getValue1()).makeNormalStack(), this.getRouter(), null, true, ((ItemIdentifierStack)pair.getValue1()).getItem(), null, true, true, false)) == null || reply.maxNumberOfItems < 1)) {
                this._lostItems.add(new DelayedGeneric<Pair>(pair, 9000 + (int)(Math.random() * 2000.0)));
                lostItem = (DelayedGeneric)this._lostItems.poll();
                continue;
            }
            int received = RequestTree.requestPartial((ItemIdentifierStack)pair.getValue1(), (CoreRoutedPipe)this._service, (IAdditionalTargetInformation)pair.getValue2());
            ++rerequested;
            if (received < ((ItemIdentifierStack)pair.getValue1()).getStackSize()) {
                ((ItemIdentifierStack)pair.getValue1()).setStackSize(((ItemIdentifierStack)pair.getValue1()).getStackSize() - received);
                this._lostItems.add(new DelayedGeneric<Pair>(pair, 4500 + (int)(Math.random() * 1000.0)));
            }
            lostItem = (DelayedGeneric)this._lostItems.poll();
        }
    }

    @Override
    public void itemArrived(ItemIdentifierStack item, IAdditionalTargetInformation info) {
    }

    @Override
    public void itemLost(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        this._lostItems.add(new DelayedGeneric<Pair<ItemIdentifierStack, IAdditionalTargetInformation>>(new Pair<ItemIdentifierStack, IAdditionalTargetInformation>(item, info), 5000L));
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public void collectSpecificInterests(@Nonnull Collection<ItemIdentifier> itemidCollection) {
        List<ItemIdentifierStack> result2 = this.getCraftedItems();
        if (result2 == null) {
            return;
        }
        result2.stream().map(ItemIdentifierStack::getItem).forEach(itemidCollection::add);
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return false;
    }

    @Override
    public void canProvide(RequestTreeNode tree, RequestTree root, List<IFilter> filters) {
        if (!this._service.getItemOrderManager().hasExtras() || tree.hasBeenQueried(this._service.getItemOrderManager())) {
            return;
        }
        IResource requestedItem = tree.getRequestType();
        if (!this.canCraft(requestedItem)) {
            return;
        }
        for (IFilter iFilter : filters) {
            if (iFilter.isBlocked() != iFilter.isFilteredItem(requestedItem) && !iFilter.blockProvider()) continue;
            return;
        }
        int remaining = 0;
        for (LogisticsItemOrder extra : this._service.getItemOrderManager()) {
            if (extra.getType() != IOrderInfoProvider.ResourceType.EXTRA || !extra.getResource().getItem().equals(requestedItem.getAsItem())) continue;
            remaining += extra.getResource().stack.getStackSize();
        }
        if ((remaining -= root.getAllPromissesFor(this, this.getCraftedItem().getItem())) < 1) {
            return;
        }
        if (this.getUpgradeManager().isFuzzyUpgrade() && this.outputFuzzyFlags.getBitSet().nextSetBit(0) != -1) {
            DictResource dictResource = new DictResource(this.getCraftedItem(), null).loadFromBitSet(this.outputFuzzyFlags.getBitSet());
            LogisticsExtraDictPromise promise = new LogisticsExtraDictPromise(dictResource, Math.min(remaining, tree.getMissingAmount()), (IProvideItems)this, true);
            tree.addPromise(promise);
        } else {
            LogisticsExtraPromise logisticsExtraPromise = new LogisticsExtraPromise(this.getCraftedItem().getItem(), Math.min(remaining, tree.getMissingAmount()), (IProvideItems)this, true);
            tree.addPromise(logisticsExtraPromise);
        }
        tree.setQueried(this._service.getItemOrderManager());
    }

    @Override
    public LogisticsItemOrder fullFill(LogisticsPromise promise, IRequestItems destination, IAdditionalTargetInformation info) {
        if (promise instanceof LogisticsExtraDictPromise) {
            this._service.getItemOrderManager().removeExtras(((LogisticsExtraDictPromise)promise).getResource());
        }
        if (promise instanceof LogisticsExtraPromise) {
            this._service.getItemOrderManager().removeExtras(new DictResource(new ItemIdentifierStack(promise.item, promise.numberOfItems), null));
        }
        if (promise instanceof LogisticsDictPromise) {
            this._service.spawnParticle(Particles.WhiteParticle, 2);
            return this._service.getItemOrderManager().addOrder(((LogisticsDictPromise)promise).getResource(), destination, IOrderInfoProvider.ResourceType.CRAFTING, info);
        }
        this._service.spawnParticle(Particles.WhiteParticle, 2);
        return this._service.getItemOrderManager().addOrder(new ItemIdentifierStack(promise.item, promise.numberOfItems), destination, IOrderInfoProvider.ResourceType.CRAFTING, info);
    }

    @Override
    public void getAllItems(Map<ItemIdentifier, Integer> list, List<IFilter> filter2) {
    }

    @Override
    @Nonnull
    public IRouter getRouter() {
        return this._service.getRouter();
    }

    @Override
    public void itemCouldNotBeSend(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        this._invRequester.itemCouldNotBeSend(item, info);
    }

    @Override
    public int getID() {
        return this._service.getRouter().getSimpleID();
    }

    @Override
    public int compareTo(IRequestItems value2) {
        return 0;
    }

    @Override
    public void registerExtras(IPromise promise) {
        if (promise instanceof LogisticsDictPromise) {
            this._service.getItemOrderManager().addExtra(((LogisticsDictPromise)promise).getResource());
        } else {
            ItemIdentifierStack stack = new ItemIdentifierStack(promise.getItemType(), promise.getAmount());
            this._service.getItemOrderManager().addExtra(new DictResource(stack, null));
        }
    }

    @Override
    public ICraftingTemplate addCrafting(IResource toCraft) {
        int i;
        List<ItemIdentifierStack> stack = this.getCraftedItems();
        if (stack == null) {
            return null;
        }
        IReqCraftingTemplate template = null;
        if (this.getUpgradeManager().isFuzzyUpgrade() && this.outputFuzzyFlags.getBitSet().nextSetBit(0) != -1) {
            if (toCraft instanceof DictResource) {
                for (ItemIdentifierStack craftable : stack) {
                    DictResource dict = new DictResource(craftable, null);
                    dict.loadFromBitSet(this.outputFuzzyFlags.getBitSet());
                    if (!toCraft.matches(craftable.getItem(), IResource.MatchSettings.NORMAL) || !dict.matches(((DictResource)toCraft).getItem(), IResource.MatchSettings.NORMAL) || !dict.getBitSet().equals(((DictResource)toCraft).getBitSet())) continue;
                    template = new DictCraftingTemplate(dict, this, this.priority);
                    break;
                }
            }
        } else {
            for (ItemIdentifierStack craftable : stack) {
                if (!toCraft.matches(craftable.getItem(), IResource.MatchSettings.NORMAL)) continue;
                template = new ItemCraftingTemplate(craftable, this, this.priority);
                break;
            }
        }
        if (template == null) {
            return null;
        }
        IRequestItems[] target = new IRequestItems[9];
        for (int i2 = 0; i2 < 9; ++i2) {
            target[i2] = this;
        }
        boolean hasSatellite = this.isSatelliteConnected();
        if (!hasSatellite) {
            return null;
        }
        if (!this.getUpgradeManager().isAdvancedSatelliteCrafter()) {
            IRouter r = this.getSatelliteRouter(-1);
            if (r != null) {
                CoreRoutedPipe sat = r.getPipe();
                for (i = 6; i < 9; ++i) {
                    target[i] = sat;
                }
            }
        } else {
            for (int i3 = 0; i3 < 9; ++i3) {
                IRouter r = this.getSatelliteRouter(i3);
                if (r == null) continue;
                target[i3] = r.getPipe();
            }
        }
        for (int i4 = 0; i4 < 9; ++i4) {
            IResource req;
            ItemIdentifierStack resourceStack = this.getMaterials(i4);
            if (resourceStack == null || resourceStack.getStackSize() == 0) continue;
            if (this.getUpgradeManager().isFuzzyUpgrade() && this.fuzzyCraftingFlagArray[i4].getBitSet().nextSetBit(0) != -1) {
                DictResource dict = new DictResource(resourceStack, target[i4]);
                req = dict;
                dict.loadFromBitSet(this.fuzzyCraftingFlagArray[i4].getBitSet());
            } else {
                req = new ItemResource(resourceStack, target[i4]);
            }
            template.addRequirement(req, new CraftingChassieInformation(i4, this.getPositionInt()));
        }
        int liquidCrafter = this.getUpgradeManager().getFluidCrafter();
        IRequestFluid[] liquidTarget = new IRequestFluid[liquidCrafter];
        if (!this.getUpgradeManager().isAdvancedSatelliteCrafter()) {
            IRouter r = this.getFluidSatelliteRouter(-1);
            if (r != null) {
                IRequestFluid sat = (IRequestFluid)((Object)r.getPipe());
                for (int i5 = 0; i5 < liquidCrafter; ++i5) {
                    liquidTarget[i5] = sat;
                }
            }
        } else {
            for (i = 0; i < liquidCrafter; ++i) {
                IRouter r = this.getFluidSatelliteRouter(i);
                if (r == null) continue;
                liquidTarget[i] = (IRequestFluid)((Object)r.getPipe());
            }
        }
        for (int i6 = 0; i6 < liquidCrafter; ++i6) {
            FluidIdentifier liquid = this.getFluidMaterial(i6);
            int amount = this.getFluidAmount()[i6];
            if (liquid == null || amount <= 0 || liquidTarget[i6] == null) continue;
            template.addRequirement(new FluidResource(liquid, amount, liquidTarget[i6]), null);
        }
        if (this.getUpgradeManager().hasByproductExtractor() && this.getByproductItem() != null) {
            template.addByproduct(this.getByproductItem());
        }
        return template;
    }

    public boolean isSatelliteConnected() {
        if (!this.getUpgradeManager().isAdvancedSatelliteCrafter()) {
            if (this.satelliteUUID == null) {
                return true;
            }
            int satelliteRouterId = SimpleServiceLocator.routerManager.getIDforUUID(this.satelliteUUID);
            if (satelliteRouterId != -1) {
                List<ExitRoute> rt = this.getRouter().getRouteTable().get(satelliteRouterId);
                return rt != null && !rt.isEmpty();
            }
        } else {
            boolean foundAll = true;
            for (int i = 0; i < 9; ++i) {
                List<ExitRoute> rt;
                boolean foundOne = false;
                if (this.advancedSatelliteUUIDArray[i] == null) continue;
                int satelliteRouterId = SimpleServiceLocator.routerManager.getIDforUUID(this.advancedSatelliteUUIDArray[i]);
                if (satelliteRouterId != -1 && (rt = this.getRouter().getRouteTable().get(satelliteRouterId)) != null && !rt.isEmpty()) {
                    foundOne = true;
                }
                foundAll &= foundOne;
            }
            return foundAll;
        }
        return false;
    }

    @Override
    public boolean canCraft(IResource toCraft) {
        if (this.getCraftedItem() == null) {
            return false;
        }
        if (toCraft instanceof ItemResource || toCraft instanceof DictResource) {
            return toCraft.matches(this.getCraftedItem().getItem(), IResource.MatchSettings.NORMAL);
        }
        return false;
    }

    @Override
    public List<ItemIdentifierStack> getCraftedItems() {
        ArrayList<ItemIdentifierStack> list = new ArrayList<ItemIdentifierStack>(1);
        if (this.getCraftedItem() != null) {
            list.add(this.getCraftedItem());
        }
        return list;
    }

    public ItemIdentifierStack getCraftedItem() {
        return this._dummyInventory.getIDStackInSlot(9);
    }

    @Override
    public int getTodo() {
        return this._service.getItemOrderManager().totalAmountCountInAllOrders();
    }

    private IRouter getSatelliteRouter(int x) {
        UUID satelliteUUID = x == -1 ? this.satelliteUUID : this.advancedSatelliteUUIDArray[x];
        int satelliteRouterId = SimpleServiceLocator.routerManager.getIDforUUID(satelliteUUID);
        return SimpleServiceLocator.routerManager.getRouter(satelliteRouterId);
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbttagcompound) {
        String liquidSatelliteUUIDString;
        int i;
        int i2;
        this._dummyInventory.readFromNBT(nbttagcompound, "");
        this._liquidInventory.readFromNBT(nbttagcompound, "FluidInv");
        this._cleanupInventory.readFromNBT(nbttagcompound, "CleanupInv");
        String satelliteUUIDString = nbttagcompound.func_74779_i("satelliteUUID");
        this.satelliteUUID = satelliteUUIDString.isEmpty() ? null : UUID.fromString(satelliteUUIDString);
        this.priority = nbttagcompound.func_74762_e("priority");
        for (i2 = 0; i2 < 9; ++i2) {
            String advancedSatelliteUUIDArrayString = nbttagcompound.func_74779_i("advancedSatelliteUUID" + i2);
            this.advancedSatelliteUUIDArray[i2] = advancedSatelliteUUIDArrayString.isEmpty() ? null : UUID.fromString(advancedSatelliteUUIDArrayString);
        }
        if (nbttagcompound.func_74764_b("fuzzyCraftingFlag0")) {
            for (i2 = 0; i2 < 9; ++i2) {
                byte flags = nbttagcompound.func_74771_c("fuzzyCraftingFlag" + i2);
                DictResource dict = this.fuzzyCraftingFlagArray[i2];
                if ((flags & 1) != 0) {
                    dict.use_od = true;
                }
                if ((flags & 2) != 0) {
                    dict.ignore_dmg = true;
                }
                if ((flags & 4) != 0) {
                    dict.ignore_nbt = true;
                }
                if ((flags & 8) == 0) continue;
                dict.use_category = true;
            }
        }
        if (nbttagcompound.func_74764_b("fuzzyFlags")) {
            NBTTagList lst = nbttagcompound.func_150295_c("fuzzyFlags", 10);
            for (int i3 = 0; i3 < 9; ++i3) {
                NBTTagCompound comp = lst.func_150305_b(i3);
                this.fuzzyCraftingFlagArray[i3].ignore_dmg = comp.func_74767_n("ignore_dmg");
                this.fuzzyCraftingFlagArray[i3].ignore_nbt = comp.func_74767_n("ignore_nbt");
                this.fuzzyCraftingFlagArray[i3].use_od = comp.func_74767_n("use_od");
                this.fuzzyCraftingFlagArray[i3].use_category = comp.func_74767_n("use_category");
            }
        }
        if (nbttagcompound.func_74764_b("outputFuzzyFlags")) {
            NBTTagCompound comp = nbttagcompound.func_74775_l("outputFuzzyFlags");
            this.outputFuzzyFlags.ignore_dmg = comp.func_74767_n("ignore_dmg");
            this.outputFuzzyFlags.ignore_nbt = comp.func_74767_n("ignore_nbt");
            this.outputFuzzyFlags.use_od = comp.func_74767_n("use_od");
            this.outputFuzzyFlags.use_category = comp.func_74767_n("use_category");
        }
        for (i = 0; i < 6; ++i) {
            this.craftingSigns[i] = nbttagcompound.func_74767_n("craftingSigns" + i);
        }
        for (i = 0; i < 3; ++i) {
            String liquidSatelliteUUIDArrayString = nbttagcompound.func_74779_i("liquidSatelliteUUIDArray" + i);
            this.liquidSatelliteUUIDArray[i] = liquidSatelliteUUIDArrayString.isEmpty() ? null : UUID.fromString(liquidSatelliteUUIDArrayString);
        }
        if (nbttagcompound.func_74764_b("FluidAmount")) {
            this.amount = nbttagcompound.func_74759_k("FluidAmount");
        }
        if (this.amount.length < 3) {
            this.amount = new int[3];
        }
        this.liquidSatelliteUUID = (liquidSatelliteUUIDString = nbttagcompound.func_74779_i("liquidSatelliteId")).isEmpty() ? null : UUID.fromString(liquidSatelliteUUIDString);
        this.cleanupModeIsExclude = nbttagcompound.func_74767_n("cleanupModeIsExclude");
        if (nbttagcompound.func_74764_b("satelliteid")) {
            int i4;
            this.updateSatelliteFromIDs = new UpgradeSatelliteFromIDs();
            this.updateSatelliteFromIDs.satelliteId = nbttagcompound.func_74762_e("satelliteid");
            for (i4 = 0; i4 < 9; ++i4) {
                this.updateSatelliteFromIDs.advancedSatelliteIdArray[i4] = nbttagcompound.func_74762_e("advancedSatelliteId" + i4);
            }
            for (i4 = 0; i4 < 3; ++i4) {
                this.updateSatelliteFromIDs.liquidSatelliteIdArray[i4] = nbttagcompound.func_74762_e("liquidSatelliteIdArray" + i4);
            }
            this.updateSatelliteFromIDs.liquidSatelliteId = nbttagcompound.func_74762_e("liquidSatelliteId");
        }
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbttagcompound) {
        int i;
        this._dummyInventory.writeToNBT(nbttagcompound, "");
        this._liquidInventory.writeToNBT(nbttagcompound, "FluidInv");
        this._cleanupInventory.writeToNBT(nbttagcompound, "CleanupInv");
        nbttagcompound.func_74778_a("satelliteUUID", this.satelliteUUID == null ? "" : this.satelliteUUID.toString());
        nbttagcompound.func_74768_a("priority", this.priority);
        for (int i2 = 0; i2 < 9; ++i2) {
            nbttagcompound.func_74778_a("advancedSatelliteUUID" + i2, this.advancedSatelliteUUIDArray[i2] == null ? "" : this.advancedSatelliteUUIDArray[i2].toString());
        }
        NBTTagList lst = new NBTTagList();
        for (int i3 = 0; i3 < 9; ++i3) {
            NBTTagCompound comp = new NBTTagCompound();
            comp.func_74757_a("ignore_dmg", this.fuzzyCraftingFlagArray[i3].ignore_dmg);
            comp.func_74757_a("ignore_nbt", this.fuzzyCraftingFlagArray[i3].ignore_nbt);
            comp.func_74757_a("use_od", this.fuzzyCraftingFlagArray[i3].use_od);
            comp.func_74757_a("use_category", this.fuzzyCraftingFlagArray[i3].use_category);
            lst.func_74742_a((NBTBase)comp);
        }
        nbttagcompound.func_74782_a("fuzzyFlags", (NBTBase)lst);
        NBTTagCompound comp = new NBTTagCompound();
        comp.func_74757_a("ignore_dmg", this.outputFuzzyFlags.ignore_dmg);
        comp.func_74757_a("ignore_nbt", this.outputFuzzyFlags.ignore_nbt);
        comp.func_74757_a("use_od", this.outputFuzzyFlags.use_od);
        comp.func_74757_a("use_category", this.outputFuzzyFlags.use_category);
        nbttagcompound.func_74782_a("outputFuzzyFlags", (NBTBase)comp);
        for (i = 0; i < 6; ++i) {
            nbttagcompound.func_74757_a("craftingSigns" + i, this.craftingSigns[i]);
        }
        for (i = 0; i < 3; ++i) {
            nbttagcompound.func_74778_a("liquidSatelliteUUIDArray" + i, this.liquidSatelliteUUIDArray[i] == null ? "" : this.liquidSatelliteUUIDArray[i].toString());
        }
        nbttagcompound.func_74783_a("FluidAmount", this.amount);
        nbttagcompound.func_74778_a("liquidSatelliteId", this.liquidSatelliteUUID == null ? "" : this.liquidSatelliteUUID.toString());
        nbttagcompound.func_74757_a("cleanupModeIsExclude", this.cleanupModeIsExclude);
    }

    public ModernPacket getCPipePacket() {
        return PacketHandler.getPacket(CraftingPipeUpdatePacket.class).setAmount(this.amount).setLiquidSatelliteNameArray(this.getSatelliteNamesForUUIDs(this.liquidSatelliteUUIDArray)).setLiquidSatelliteName(this.getSatelliteNameForUUID(this.liquidSatelliteUUID)).setSatelliteName(this.getSatelliteNameForUUID(this.satelliteUUID)).setAdvancedSatelliteNameArray(this.getSatelliteNamesForUUIDs(this.advancedSatelliteUUIDArray)).setPriority(this.priority).setModulePos(this);
    }

    private String getSatelliteNameForUUID(UUID id) {
        if (id == null) {
            return "";
        }
        int simpleId = SimpleServiceLocator.routerManager.getIDforUUID(id);
        IRouter router = SimpleServiceLocator.routerManager.getRouter(simpleId);
        if (router != null) {
            CoreRoutedPipe pipe = router.getPipe();
            if (pipe instanceof PipeItemsSatelliteLogistics) {
                return ((PipeItemsSatelliteLogistics)pipe).getSatellitePipeName();
            }
            if (pipe instanceof PipeFluidSatellite) {
                return ((PipeFluidSatellite)pipe).getSatellitePipeName();
            }
        }
        return "UNKNOWN NAME";
    }

    private String[] getSatelliteNamesForUUIDs(UUID[] ids) {
        return (String[])Arrays.stream(ids).map(this::getSatelliteNameForUUID).toArray(String[]::new);
    }

    public void handleCraftingUpdatePacket(CraftingPipeUpdatePacket packet) {
        if (!MainProxy.isClient((IBlockAccess)this._world.getWorld())) {
            throw new UnsupportedOperationException();
        }
        this.amount = packet.getAmount();
        this.clientSideSatelliteNames.liquidSatelliteNameArray = packet.getLiquidSatelliteNameArray();
        this.clientSideSatelliteNames.liquidSatelliteName = packet.getLiquidSatelliteName();
        this.clientSideSatelliteNames.satelliteName = packet.getSatelliteName();
        this.clientSideSatelliteNames.advancedSatelliteNameArray = packet.getAdvancedSatelliteNameArray();
        this.priority = packet.getPriority();
    }

    @Override
    public ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        return NewGuiHandler.getGui(CraftingModuleSlot.class).setAdvancedSat(this.getUpgradeManager().isAdvancedSatelliteCrafter()).setLiquidCrafter(this.getUpgradeManager().getFluidCrafter()).setAmount(this.amount).setHasByproductExtractor(this.getUpgradeManager().hasByproductExtractor()).setFuzzy(this.getUpgradeManager().isFuzzyUpgrade()).setCleanupSize(this.getUpgradeManager().getCrafterCleanup()).setCleanupExclude(this.cleanupModeIsExclude);
    }

    @Override
    public ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(CraftingModuleInHand.class).setAmount(this.amount).setCleanupExclude(this.cleanupModeIsExclude);
    }

    public ItemIdentifierInventory getDummyInventory() {
        return this._dummyInventory;
    }

    public ItemIdentifierInventory getFluidInventory() {
        return this._liquidInventory;
    }

    public IInventory getCleanupInventory() {
        return this._cleanupInventory;
    }

    public void setDummyInventorySlot(int slot, @Nonnull ItemStack itemstack) {
        this._dummyInventory.func_70299_a(slot, itemstack);
    }

    public void importFromCraftingTable(EntityPlayer player) {
        if (MainProxy.isClient((IBlockAccess)this._world.getWorld())) {
            ModuleCoordinatesPacket packet = PacketHandler.getPacket(CPipeSatelliteImport.class).setModulePos(this);
            MainProxy.sendPacketToServer(packet);
        } else {
            WorldCoordinatesWrapper worldCoordinates = new WorldCoordinatesWrapper(this._world.getWorld(), this.getBlockPos());
            block0: for (NeighborTileEntity adjacent : worldCoordinates.connectedTileEntities(IPipeInformationProvider.ConnectionPipeType.ITEM).collect(Collectors.toList())) {
                for (ICraftingRecipeProvider provider : SimpleServiceLocator.craftingRecipeProviders) {
                    if (!provider.importRecipe((TileEntity)adjacent.getTileEntity(), this._dummyInventory)) continue;
                    if (!(provider instanceof IFuzzyRecipeProvider)) continue block0;
                    ((IFuzzyRecipeProvider)provider).importFuzzyFlags((TileEntity)adjacent.getTileEntity(), this._dummyInventory, this.fuzzyCraftingFlagArray, this.outputFuzzyFlags);
                    continue block0;
                }
            }
            ModuleCoordinatesPacket packet = PacketHandler.getPacket(CPipeSatelliteImportBack.class).setInventory(this._dummyInventory).setModulePos(this);
            if (player != null) {
                MainProxy.sendPacketToPlayer(packet, player);
            }
            MainProxy.sendPacketToAllWatchingChunk(this, (ModernPacket)packet);
        }
    }

    public void priorityUp(EntityPlayer player) {
        ++this.priority;
        if (MainProxy.isClient((IBlockAccess)player.field_70170_p)) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(CraftingPipePriorityUpPacket.class).setModulePos(this));
        } else if (MainProxy.isServer((IBlockAccess)player.field_70170_p)) {
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(CraftingPriority.class).setInteger(this.priority).setModulePos(this), player);
        }
    }

    public void priorityDown(EntityPlayer player) {
        --this.priority;
        if (MainProxy.isClient((IBlockAccess)player.field_70170_p)) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(CraftingPipePriorityDownPacket.class).setModulePos(this));
        } else if (MainProxy.isServer((IBlockAccess)player.field_70170_p)) {
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(CraftingPriority.class).setInteger(this.priority).setModulePos(this), player);
        }
    }

    public ItemIdentifierStack getByproductItem() {
        return this._dummyInventory.getIDStackInSlot(10);
    }

    public ItemIdentifierStack getMaterials(int slotnr) {
        return this._dummyInventory.getIDStackInSlot(slotnr);
    }

    public FluidIdentifier getFluidMaterial(int slotnr) {
        ItemIdentifierStack stack = this._liquidInventory.getIDStackInSlot(slotnr);
        if (stack == null) {
            return null;
        }
        return FluidIdentifier.get(stack.getItem());
    }

    public void changeFluidAmount(int change, int slot, EntityPlayer player) {
        if (MainProxy.isClient((IBlockAccess)player.field_70170_p)) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(FluidCraftingAmount.class).setInteger2(slot).setInteger(change).setModulePos(this));
        } else {
            int n = slot;
            this.amount[n] = this.amount[n] + change;
            if (this.amount[slot] <= 0) {
                this.amount[slot] = 0;
            }
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(FluidCraftingAmount.class).setInteger2(slot).setInteger(this.amount[slot]).setModulePos(this), player);
        }
    }

    public void defineFluidAmount(int integer, int slot) {
        if (MainProxy.isClient((IBlockAccess)this._world.getWorld())) {
            this.amount[slot] = integer;
        }
    }

    public int[] getFluidAmount() {
        return this.amount;
    }

    public void setFluidAmount(int[] amount) {
        if (MainProxy.isClient((IBlockAccess)this._world.getWorld())) {
            this.amount = amount;
        }
    }

    private IRouter getFluidSatelliteRouter(int x) {
        UUID liquidSatelliteUUID = x == -1 ? this.liquidSatelliteUUID : this.liquidSatelliteUUIDArray[x];
        int satelliteRouterId = SimpleServiceLocator.routerManager.getIDforUUID(liquidSatelliteUUID);
        return SimpleServiceLocator.routerManager.getRouter(satelliteRouterId);
    }

    public void openAttachedGui(EntityPlayer player) {
        int i;
        if (MainProxy.isClient((IBlockAccess)player.field_70170_p)) {
            if (player instanceof EntityPlayerMP) {
                player.func_71053_j();
            } else if (player instanceof EntityPlayerSP) {
                player.func_71053_j();
            }
            MainProxy.sendPacketToServer(PacketHandler.getPacket(CraftingPipeOpenConnectedGuiPacket.class).setModulePos(this));
            return;
        }
        int savedEquipped = player.field_71071_by.field_70461_c;
        boolean foundSlot = false;
        for (i = 0; i < 9; ++i) {
            if (!player.field_71071_by.func_70301_a(i).func_190926_b()) continue;
            foundSlot = true;
            player.field_71071_by.field_70461_c = i;
            break;
        }
        if (!foundSlot) {
            for (i = 0; i < 9; ++i) {
                ItemStack is = player.field_71071_by.func_70301_a(i);
                if (!(is.func_77973_b() instanceof ItemBlock)) continue;
                foundSlot = true;
                player.field_71071_by.field_70461_c = i;
                break;
            }
        }
        if (!foundSlot) {
            player.field_71071_by.field_70461_c = (player.field_71071_by.field_70461_c + 1) % 9;
        }
        WorldCoordinatesWrapper worldCoordinates = new WorldCoordinatesWrapper(this._world.getWorld(), this.getBlockPos());
        worldCoordinates.connectedTileEntities(IPipeInformationProvider.ConnectionPipeType.ITEM).anyMatch(adjacent -> {
            boolean found = SimpleServiceLocator.craftingRecipeProviders.stream().anyMatch(provider -> provider.canOpenGui((TileEntity)adjacent.getTileEntity()));
            if (!found) {
                boolean bl = found = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil((NeighborTileEntity<TileEntity>)adjacent) != null;
            }
            if (found) {
                BlockPos pos = adjacent.getTileEntity().func_174877_v();
                IBlockState blockState = this._world.getWorld().func_180495_p(pos);
                return !blockState.func_177230_c().isAir(blockState, (IBlockAccess)this._world.getWorld(), pos) && blockState.func_177230_c().func_180639_a(this._world.getWorld(), pos, adjacent.getTileEntity().func_145831_w().func_180495_p(pos), player, EnumHand.MAIN_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f);
            }
            return false;
        });
        player.field_71071_by.field_70461_c = savedEquipped;
    }

    public void enabledUpdateEntity() {
        if (this._service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA)) {
            if (this._service.isNthTick(6)) {
                this.cacheAreAllOrderesToBuffer();
            }
            if (this._service.getItemOrderManager().isFirstOrderWatched()) {
                TileEntity tile = (TileEntity)this.lastAccessedCrafter.get();
                if (tile != null) {
                    this._service.getItemOrderManager().setMachineProgress(SimpleServiceLocator.machineProgressProvider.getProgressForTile(tile));
                } else {
                    this._service.getItemOrderManager().setMachineProgress((byte)0);
                }
            }
        } else {
            this.cachedAreAllOrderesToBuffer = false;
        }
        if (!this._service.isNthTick(6)) {
            return;
        }
        this.waitingForCraft = false;
        if (!this._service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA)) {
            ISlotUpgradeManager upgradeManager = Objects.requireNonNull(this.getUpgradeManager());
            if (upgradeManager.getCrafterCleanup() > 0) {
                NeighborTileEntity<TileEntity> adjacentCrafter;
                List<NeighborTileEntity<TileEntity>> crafters = this.locateCraftersForExtraction();
                ItemStack extracted = ItemStack.field_190927_a;
                Iterator<NeighborTileEntity<TileEntity>> iterator2 = crafters.iterator();
                while (iterator2.hasNext() && (extracted = this.extractFiltered(adjacentCrafter = iterator2.next(), this._cleanupInventory, this.cleanupModeIsExclude, upgradeManager.getCrafterCleanup() * 3)).func_190926_b()) {
                }
                if (!extracted.func_190926_b()) {
                    this._service.queueRoutedItem(SimpleServiceLocator.routedItemHelper.createNewTravelItem(extracted), EnumFacing.UP);
                    this._service.getCacheHolder().trigger(CacheHolder.CacheTypes.Inventory);
                }
            }
            return;
        }
        this.waitingForCraft = true;
        List<NeighborTileEntity<TileEntity>> adjacentCrafters = this.locateCraftersForExtraction();
        if (adjacentCrafters.size() < 1) {
            if (this._service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA)) {
                this._service.getItemOrderManager().sendFailed();
            }
            return;
        }
        List<ItemIdentifierStack> wanteditem = this.getCraftedItems();
        if (wanteditem == null || wanteditem.isEmpty()) {
            return;
        }
        this._service.spawnParticle(Particles.VioletParticle, 2);
        int itemsleft = this.itemsToExtract();
        int stacksleft = this.stacksToExtract();
        block1: while (itemsleft > 0 && stacksleft > 0 && this._service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA)) {
            NeighborTileEntity<TileEntity> adjacentCrafter;
            LogisticsItemOrder nextOrder = (LogisticsItemOrder)this._service.getItemOrderManager().peekAtTopRequest(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA);
            int maxtosend = Math.min(itemsleft, nextOrder.getResource().stack.getStackSize());
            maxtosend = Math.min(nextOrder.getResource().getItem().getMaxStackSize(), maxtosend);
            ItemStack extracted = ItemStack.field_190927_a;
            NeighborTileEntity<TileEntity> adjacent = null;
            Iterator<NeighborTileEntity<TileEntity>> iterator3 = adjacentCrafters.iterator();
            while (iterator3.hasNext() && (extracted = this.extract(adjacent = (adjacentCrafter = iterator3.next()), nextOrder.getResource(), maxtosend)).func_190926_b()) {
            }
            if (extracted.func_190926_b()) {
                this._service.getItemOrderManager().deferSend();
                break;
            }
            this._service.getCacheHolder().trigger(CacheHolder.CacheTypes.Inventory);
            Objects.requireNonNull(adjacent);
            this.lastAccessedCrafter = new WeakReference<TileEntity>(adjacent.getTileEntity());
            ItemIdentifier extractedID = ItemIdentifier.get(extracted);
            while (!extracted.func_190926_b()) {
                if (!this.doesExtractionMatch(nextOrder, extractedID)) {
                    LogisticsItemOrder startOrder = nextOrder;
                    if (this._service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA)) {
                        do {
                            this._service.getItemOrderManager().deferSend();
                        } while (!this.doesExtractionMatch(nextOrder = (LogisticsItemOrder)this._service.getItemOrderManager().peekAtTopRequest(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA), extractedID) && startOrder != nextOrder);
                    }
                    if (startOrder == nextOrder) {
                        int numtosend = Math.min(extracted.func_190916_E(), extractedID.getMaxStackSize());
                        if (numtosend == 0) continue block1;
                        --stacksleft;
                        itemsleft -= numtosend;
                        ItemStack stackToSend = extracted.func_77979_a(numtosend);
                        this._service.sendStack(stackToSend, -1, CoreRoutedPipe.ItemSendMode.Normal, null);
                        continue;
                    }
                }
                int numtosend = Math.min(extracted.func_190916_E(), extractedID.getMaxStackSize());
                if ((numtosend = Math.min(numtosend, nextOrder.getResource().stack.getStackSize())) == 0) continue block1;
                --stacksleft;
                itemsleft -= numtosend;
                ItemStack stackToSend = extracted.func_77979_a(numtosend);
                if (nextOrder.getDestination() != null) {
                    SinkReply reply = LogisticsManager.canSink(stackToSend, nextOrder.getDestination().getRouter(), null, true, ItemIdentifier.get(stackToSend), null, true, false);
                    boolean defersend = false;
                    if (reply == null || reply.bufferMode != SinkReply.BufferMode.NONE || reply.maxNumberOfItems < 1) {
                        defersend = true;
                    }
                    LPTravelingItem.LPTravelingItemServer item = SimpleServiceLocator.routedItemHelper.createNewTravelItem(stackToSend);
                    item.setDestination(nextOrder.getDestination().getRouter().getSimpleID());
                    item.setTransportMode(IRoutedItem.TransportMode.Active);
                    item.setAdditionalTargetInformation(nextOrder.getInformation());
                    this._service.queueRoutedItem(item, adjacent.getDirection());
                    this._service.getItemOrderManager().sendSuccessfull(stackToSend.func_190916_E(), defersend, item);
                } else {
                    this._service.sendStack(stackToSend, -1, CoreRoutedPipe.ItemSendMode.Normal, nextOrder.getInformation());
                    this._service.getItemOrderManager().sendSuccessfull(stackToSend.func_190916_E(), false, null);
                }
                if (!this._service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA)) continue;
                nextOrder = (LogisticsItemOrder)this._service.getItemOrderManager().peekAtTopRequest(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA);
            }
        }
    }

    private boolean doesExtractionMatch(LogisticsItemOrder nextOrder, ItemIdentifier extractedID) {
        return nextOrder.getResource().getItem().equals(extractedID) || this.getUpgradeManager().isFuzzyUpgrade() && nextOrder.getResource().getBitSet().nextSetBit(0) != -1 && nextOrder.getResource().matches(extractedID, IResource.MatchSettings.NORMAL);
    }

    public boolean areAllOrderesToBuffer() {
        return this.cachedAreAllOrderesToBuffer;
    }

    public void cacheAreAllOrderesToBuffer() {
        boolean result2 = true;
        for (LogisticsItemOrder order : this._service.getItemOrderManager()) {
            if (order.getDestination() instanceof IItemSpaceControl) {
                SinkReply reply = LogisticsManager.canSink(order.getResource().stack.makeNormalStack(), order.getDestination().getRouter(), null, true, order.getResource().getItem(), null, true, false);
                if (reply == null || reply.bufferMode != SinkReply.BufferMode.NONE || reply.maxNumberOfItems < 1) continue;
                result2 = false;
                break;
            }
            result2 = false;
            break;
        }
        this.cachedAreAllOrderesToBuffer = result2;
    }

    @Nonnull
    private ItemStack extract(NeighborTileEntity<TileEntity> adjacent, IResource item, int amount) {
        return adjacent.getJavaInstanceOf(LogisticsCraftingTableTileEntity.class).map(adjacentCraftingTable -> this.extractFromLogisticsCraftingTable((NeighborTileEntity<LogisticsCraftingTableTileEntity>)adjacentCraftingTable, item, amount)).orElseGet(() -> adjacent.isItemHandler() ? this.extractFromInventory(adjacent.getUtilForItemHandler(), item, amount) : ItemStack.field_190927_a);
    }

    @Nonnull
    private ItemStack extractFiltered(NeighborTileEntity<TileEntity> adjacent, ItemIdentifierInventory inv, boolean isExcluded, int filterInvLimit) {
        return adjacent.isItemHandler() ? this.extractFromInventoryFiltered(adjacent.getUtilForItemHandler(), inv, isExcluded, filterInvLimit) : ItemStack.field_190927_a;
    }

    @Nonnull
    private ItemStack extractFromInventory(@Nonnull IInventoryUtil invUtil, IResource wanteditem, int count2) {
        ItemIdentifier itemToExtract = null;
        if (wanteditem instanceof ItemResource) {
            itemToExtract = ((ItemResource)wanteditem).getItem();
        } else if (wanteditem instanceof DictResource) {
            int max = Integer.MIN_VALUE;
            ItemIdentifier toExtract = null;
            for (Map.Entry<ItemIdentifier, Integer> content : invUtil.getItemsAndCount().entrySet()) {
                if (!wanteditem.matches(content.getKey(), IResource.MatchSettings.NORMAL) || content.getValue() <= max) continue;
                max = content.getValue();
                toExtract = content.getKey();
            }
            if (toExtract == null) {
                return ItemStack.field_190927_a;
            }
            itemToExtract = toExtract;
        }
        int available = invUtil.itemCount(itemToExtract);
        if (available == 0 || !this._service.canUseEnergy(this.neededEnergy() * Math.min(count2, available))) {
            return ItemStack.field_190927_a;
        }
        ItemStack extracted = invUtil.getMultipleItems(itemToExtract, Math.min(count2, available));
        this._service.useEnergy(this.neededEnergy() * extracted.func_190916_E());
        return extracted;
    }

    @Nonnull
    private ItemStack extractFromInventoryFiltered(@Nonnull IInventoryUtil invUtil, ItemIdentifierInventory filter2, boolean isExcluded, int filterInvLimit) {
        ItemIdentifier wanteditem = null;
        boolean found = false;
        for (ItemIdentifier item : invUtil.getItemsAndCount().keySet()) {
            found = this.isFiltered(filter2, filterInvLimit, item, found);
            if (isExcluded == found) continue;
            wanteditem = item;
            break;
        }
        if (wanteditem == null) {
            return ItemStack.field_190927_a;
        }
        int available = invUtil.itemCount(wanteditem);
        if (available == 0 || !this._service.canUseEnergy(this.neededEnergy() * Math.min(64, available))) {
            return ItemStack.field_190927_a;
        }
        ItemStack extracted = invUtil.getMultipleItems(wanteditem, Math.min(64, available));
        this._service.useEnergy(this.neededEnergy() * extracted.func_190916_E());
        return extracted;
    }

    private boolean isFiltered(ItemIdentifierInventory filter2, int filterInvLimit, ItemIdentifier item, boolean found) {
        for (int i = 0; i < filter2.func_70302_i_() && i < filterInvLimit; ++i) {
            ItemIdentifierStack identStack = filter2.getIDStackInSlot(i);
            if (identStack == null || !identStack.getItem().equalsWithoutNBT(item)) continue;
            found = true;
            break;
        }
        return found;
    }

    @Nonnull
    private ItemStack extractFromLogisticsCraftingTable(NeighborTileEntity<LogisticsCraftingTableTileEntity> adjacentCraftingTable, IResource wanteditem, int count2) {
        ItemStack stack;
        ItemStack extracted = this.extractFromInventory(Objects.requireNonNull(adjacentCraftingTable.getInventoryUtil()), wanteditem, count2);
        if (!extracted.func_190926_b()) {
            return extracted;
        }
        ItemStack retstack = ItemStack.field_190927_a;
        while (count2 > 0 && !(stack = adjacentCraftingTable.getTileEntity().getOutput(wanteditem, this._service)).func_190926_b() && !(!retstack.func_190926_b() ? !retstack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)retstack, (ItemStack)stack) : !wanteditem.matches(ItemIdentifier.get(stack), wanteditem instanceof ItemResource ? IResource.MatchSettings.WITHOUT_NBT : IResource.MatchSettings.NORMAL)) && this._service.useEnergy(this.neededEnergy() * stack.func_190916_E())) {
            if (retstack.func_190926_b()) {
                retstack = stack;
            } else {
                retstack.func_190917_f(stack.func_190916_E());
            }
            count2 -= stack.func_190916_E();
            if (!Objects.requireNonNull(this.getUpgradeManager()).isFuzzyUpgrade()) continue;
            break;
        }
        return retstack;
    }

    protected int neededEnergy() {
        return (int)(10.0 * Math.pow(1.1, this.getUpgradeManager().getItemExtractionUpgrade()) * Math.pow(1.2, this.getUpgradeManager().getItemStackExtractionUpgrade()));
    }

    protected int itemsToExtract() {
        return (int)Math.pow(2.0, this.getUpgradeManager().getItemExtractionUpgrade());
    }

    protected int stacksToExtract() {
        return 1 + this.getUpgradeManager().getItemStackExtractionUpgrade();
    }

    public List<NeighborTileEntity<TileEntity>> locateCraftersForExtraction() {
        if (this.cachedCrafters == null) {
            this.cachedCrafters = new WorldCoordinatesWrapper(this._world.getWorld(), this.getBlockPos()).connectedTileEntities(IPipeInformationProvider.ConnectionPipeType.ITEM).filter(neighbor -> neighbor.isItemHandler() || neighbor.getInventoryUtil() != null).collect(Collectors.toList());
        }
        return this.cachedCrafters;
    }

    @Override
    public void clearCache() {
        this.cachedCrafters = null;
    }

    public void importCleanup() {
        int i;
        for (i = 0; i < 10; ++i) {
            this._cleanupInventory.func_70299_a(i, this._dummyInventory.func_70301_a(i));
        }
        for (i = 10; i < this._cleanupInventory.func_70302_i_(); ++i) {
            this._cleanupInventory.func_70299_a(i, ItemStack.field_190927_a);
        }
        this._cleanupInventory.compactFirst(10);
        this._cleanupInventory.recheckStackLimit();
        this.cleanupModeIsExclude = false;
    }

    public void toogleCleaupMode() {
        this.cleanupModeIsExclude = !this.cleanupModeIsExclude;
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return null;
    }

    private void updateSatellitesOnClient() {
        MainProxy.sendToPlayerList(this.getCPipePacket(), this.guiWatcher);
    }

    public void setSatelliteUUID(UUID pipeID) {
        this.satelliteUUID = pipeID;
        this.updateSatellitesOnClient();
        this.updateSatelliteFromIDs = null;
    }

    public void setAdvancedSatelliteUUID(int i, UUID pipeID) {
        this.advancedSatelliteUUIDArray[i] = pipeID;
        this.updateSatellitesOnClient();
        this.updateSatelliteFromIDs = null;
    }

    public void setFluidSatelliteUUID(UUID pipeID) {
        this.liquidSatelliteUUID = pipeID;
        this.updateSatellitesOnClient();
        this.updateSatelliteFromIDs = null;
    }

    public void setAdvancedFluidSatelliteUUID(int i, UUID pipeID) {
        this.liquidSatelliteUUIDArray[i] = pipeID;
        this.updateSatellitesOnClient();
        this.updateSatelliteFromIDs = null;
    }

    @Override
    public void guiOpenedByPlayer(EntityPlayer player) {
        this.guiWatcher.add(player);
    }

    @Override
    public void guiClosedByPlayer(EntityPlayer player) {
        this.guiWatcher.remove(player);
    }

    public static class ClientSideSatelliteNames {
        @Nonnull
        public String satelliteName = "";
        @Nonnull
        public String[] advancedSatelliteNameArray = new String[0];
        @Nonnull
        public String liquidSatelliteName = "";
        @Nonnull
        public String[] liquidSatelliteNameArray = new String[0];
    }

    private static class UpgradeSatelliteFromIDs {
        public int satelliteId;
        public int[] advancedSatelliteIdArray = new int[9];
        public int[] liquidSatelliteIdArray = new int[3];
        public int liquidSatelliteId;

        private UpgradeSatelliteFromIDs() {
        }
    }

    public static class CraftingChassieInformation
    extends PipeLogisticsChassi.ChassiTargetInformation {
        private final int craftingSlot;

        public CraftingChassieInformation(int craftingSlot, int moduleSlot) {
            super(moduleSlot);
            this.craftingSlot = craftingSlot;
        }

        public int getCraftingSlot() {
            return this.craftingSlot;
        }
    }
}

