/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.gui.hud.modules.HUDItemSink;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IModuleInventoryReceive;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.ISlotUpgradeManager;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.abstractpackets.ModuleCoordinatesPacket;
import logisticspipes.network.guis.module.inhand.ItemSinkInHand;
import logisticspipes.network.guis.module.inpipe.ItemSinkSlot;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.module.ModuleInventory;
import logisticspipes.network.packets.modules.ItemSinkDefault;
import logisticspipes.network.packets.modules.ItemSinkFuzzy;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.module.Gui;
import network.rs485.logisticspipes.module.SimpleFilter;

@CCType(name="ItemSink Module")
public class ModuleItemSink
extends LogisticsModule
implements SimpleFilter,
IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver,
ISimpleInventoryEventHandler,
IModuleInventoryReceive,
Gui {
    private final ItemIdentifierInventory _filterInventory = new ItemIdentifierInventory(9, "Requested items", 1);
    private boolean _isDefaultRoute;
    private BitSet ignoreData = new BitSet(this._filterInventory.func_70302_i_());
    private BitSet ignoreNBT = new BitSet(this._filterInventory.func_70302_i_());
    private IHUDModuleRenderer HUD = new HUDItemSink(this);
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private SinkReply _sinkReply;
    private SinkReply _sinkReplyDefault;

    public ModuleItemSink() {
        this._filterInventory.addListener(this);
    }

    public static String getName() {
        return "item_sink";
    }

    @Override
    @CCCommand(description="Returns the FilterInventory of this Module")
    @Nonnull
    public ItemIdentifierInventory getFilterInventory() {
        return this._filterInventory;
    }

    @CCCommand(description="Returns true if the module is a default route")
    public boolean isDefaultRoute() {
        return this._isDefaultRoute;
    }

    @CCCommand(description="Sets the default route status of this module")
    public void setDefaultRoute(Boolean isDefaultRoute) {
        this._isDefaultRoute = isDefaultRoute;
        if (!this.localModeWatchers.isEmpty()) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ItemSinkDefault.class).setFlag(this._isDefaultRoute).setModulePos(this), this.localModeWatchers);
        }
    }

    @Override
    public void registerPosition(LogisticsModule.ModulePositionType slot, int positionInt) {
        super.registerPosition(slot, positionInt);
        this._sinkReply = new SinkReply(SinkReply.FixedPriority.ItemSink, 0, true, false, 1, 0, new PipeLogisticsChassi.ChassiTargetInformation(this.getPositionInt()));
        this._sinkReplyDefault = new SinkReply(SinkReply.FixedPriority.DefaultRoute, 0, true, true, 1, 0, new PipeLogisticsChassi.ChassiTargetInformation(this.getPositionInt()));
    }

    @Override
    public SinkReply sinksItem(@Nonnull ItemStack stack, ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit, boolean forcePassive) {
        if (this._isDefaultRoute && !allowDefault) {
            return null;
        }
        if (bestPriority > this._sinkReply.fixedPriority.ordinal() || bestPriority == this._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReply.customPriority) {
            return null;
        }
        if (this._filterInventory.containsUndamagedItem(item.getUndamaged())) {
            if (this._service.canUseEnergy(1)) {
                return this._sinkReply;
            }
            return null;
        }
        ISlotUpgradeManager upgradeManager = this.getUpgradeManager();
        if (upgradeManager != null && upgradeManager.isFuzzyUpgrade()) {
            for (Pair<ItemIdentifierStack, Integer> filter2 : this._filterInventory) {
                if (filter2 == null || filter2.getValue1() == null) continue;
                ItemIdentifier ident1 = item;
                ItemIdentifier ident2 = filter2.getValue1().getItem();
                if (this.ignoreData.get(filter2.getValue2())) {
                    ident1 = ident1.getIgnoringData();
                    ident2 = ident2.getIgnoringData();
                }
                if (this.ignoreNBT.get(filter2.getValue2())) {
                    ident1 = ident1.getIgnoringNBT();
                    ident2 = ident2.getIgnoringNBT();
                }
                if (!ident1.equals(ident2)) continue;
                if (this._service.canUseEnergy(5)) {
                    return this._sinkReply;
                }
                return null;
            }
        }
        if (this._isDefaultRoute) {
            if (bestPriority > this._sinkReplyDefault.fixedPriority.ordinal() || bestPriority == this._sinkReplyDefault.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReplyDefault.customPriority) {
                return null;
            }
            if (this._service.canUseEnergy(1)) {
                return this._sinkReplyDefault;
            }
            return null;
        }
        return null;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbttagcompound) {
        this._filterInventory.readFromNBT(nbttagcompound, "");
        this._isDefaultRoute = nbttagcompound.func_74767_n("defaultdestination");
        if (nbttagcompound.func_74764_b("ignoreData")) {
            this.ignoreData = BitSet.valueOf(nbttagcompound.func_74770_j("ignoreData"));
            this.ignoreNBT = BitSet.valueOf(nbttagcompound.func_74770_j("ignoreNBT"));
        }
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbttagcompound) {
        this._filterInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.func_74757_a("defaultdestination", this.isDefaultRoute());
        nbttagcompound.func_74773_a("ignoreData", this.ignoreData.toByteArray());
        nbttagcompound.func_74773_a("ignoreNBT", this.ignoreNBT.toByteArray());
    }

    @Override
    public void tick() {
    }

    @Override
    @Nonnull
    public List<String> getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Default: " + (this.isDefaultRoute() ? "Yes" : "No"));
        list.add("Filter: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ModuleInventory.class).setIdentList(ItemIdentifierStack.getListFromInventory(this._filterInventory)).setModulePos(this), player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ItemSinkDefault.class).setFlag(this._isDefaultRoute).setModulePos(this), player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public void InventoryChanged(IInventory inventory) {
        if (MainProxy.isServer((IBlockAccess)this._world.getWorld())) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ModuleInventory.class).setIdentList(ItemIdentifierStack.getListFromInventory(inventory)).setModulePos(this), this.localModeWatchers);
        }
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return this.HUD;
    }

    @Override
    public void handleInvContent(Collection<ItemIdentifierStack> list) {
        this._filterInventory.handleItemIdentifierList(list);
    }

    @Override
    public boolean hasGenericInterests() {
        return this._isDefaultRoute;
    }

    @Override
    public void collectSpecificInterests(@Nonnull Collection<ItemIdentifier> itemidCollection) {
        if (this._isDefaultRoute) {
            return;
        }
        Map<ItemIdentifier, Integer> mapIC = this._filterInventory.getItemsAndCount();
        itemidCollection.addAll(mapIC.keySet());
        mapIC.keySet().stream().map(ItemIdentifier::getUndamaged).forEach(itemidCollection::add);
        if (this.getUpgradeManager() != null && this.getUpgradeManager().isFuzzyUpgrade()) {
            for (Pair<ItemIdentifierStack, Integer> stack : this._filterInventory) {
                if (stack.getValue1() == null) continue;
                ItemIdentifier ident = stack.getValue1().getItem();
                if (this.ignoreData.get(stack.getValue2())) {
                    itemidCollection.add(ident.getIgnoringData());
                }
                if (this.ignoreNBT.get(stack.getValue2())) {
                    itemidCollection.add(ident.getIgnoringNBT());
                }
                if (!this.ignoreData.get(stack.getValue2()) || !this.ignoreNBT.get(stack.getValue2())) continue;
                itemidCollection.add(ident.getIgnoringData().getIgnoringNBT());
            }
        }
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    public void setIgnoreData(BitSet ignoreData) {
        this.ignoreData = ignoreData;
    }

    public void setIgnoreNBT(BitSet ignoreNBT) {
        this.ignoreNBT = ignoreNBT;
    }

    public boolean isIgnoreData(int pos) {
        return this.ignoreData.get(pos);
    }

    public boolean isIgnoreNBT(int pos) {
        return this.ignoreNBT.get(pos);
    }

    public void setIgnoreData(int slot, EntityPlayer player) {
        if (slot < 0 || slot >= 9) {
            return;
        }
        if (MainProxy.isClient((IBlockAccess)this._world.getWorld())) {
            if (player == null) {
                MainProxy.sendPacketToServer(PacketHandler.getPacket(ItemSinkFuzzy.class).setPos(slot).setNBT(false).setModulePos(this));
            }
        } else {
            this.sendIgnoreUpdate(slot, player, this.ignoreData);
        }
    }

    public void setIgnoreNBT(int slot, EntityPlayer player) {
        if (slot < 0 || slot >= 9) {
            return;
        }
        if (MainProxy.isClient((IBlockAccess)this._world.getWorld())) {
            if (player == null) {
                MainProxy.sendPacketToServer(PacketHandler.getPacket(ItemSinkFuzzy.class).setPos(slot).setNBT(true).setModulePos(this));
            }
        } else {
            this.sendIgnoreUpdate(slot, player, this.ignoreNBT);
        }
    }

    public void sendIgnoreUpdate(int slot, @Nullable EntityPlayer player, @Nonnull BitSet ignoreNBT) {
        ignoreNBT.set(slot, !ignoreNBT.get(slot));
        ModuleCoordinatesPacket pak = PacketHandler.getPacket(ItemSinkFuzzy.class).setIgnoreData(this.ignoreData).setIgnoreNBT(ignoreNBT).setModulePos(this);
        if (player != null) {
            MainProxy.sendPacketToPlayer(pak, player);
        }
        MainProxy.sendPacketToAllWatchingChunk(this, (ModernPacket)pak);
    }

    public void importFromInventory() {
        if (this._service == null) {
            return;
        }
        IInventoryUtil inv = this._service.getPointedInventory();
        if (inv == null) {
            return;
        }
        int count2 = 0;
        for (ItemIdentifier item : inv.getItems()) {
            this._filterInventory.setInventorySlotContents(count2, item.makeStack(1));
            if (++count2 < this._filterInventory.func_70302_i_()) continue;
            break;
        }
    }

    @Override
    @Nonnull
    public ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        return NewGuiHandler.getGui(ItemSinkSlot.class).setDefaultRoute(this._isDefaultRoute).setIgnoreData(this.ignoreData).setIgnoreNBT(this.ignoreNBT).setHasFuzzyUpgrade(this.getUpgradeManager().isFuzzyUpgrade());
    }

    @Override
    @Nonnull
    public ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(ItemSinkInHand.class);
    }
}

