/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import javax.annotation.Nonnull;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ModulePolymorphicItemSink
extends LogisticsModule {
    private SinkReply _sinkReply;

    public static String getName() {
        return "item_sink_polymorphic";
    }

    @Override
    public void registerPosition(LogisticsModule.ModulePositionType slot, int positionInt) {
        super.registerPosition(slot, positionInt);
        this._sinkReply = new SinkReply(SinkReply.FixedPriority.ItemSink, 0, true, false, 3, 0, new PipeLogisticsChassi.ChassiTargetInformation(this.getPositionInt()));
    }

    @Override
    public SinkReply sinksItem(@Nonnull ItemStack stack, ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit, boolean forcePassive) {
        if (bestPriority > this._sinkReply.fixedPriority.ordinal() || bestPriority == this._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReply.customPriority) {
            return null;
        }
        IInventoryUtil targetInventory = this._service.getSneakyInventory(this.slot, this.positionInt);
        if (targetInventory == null) {
            return null;
        }
        if (!targetInventory.containsUndamagedItem(item.getUndamaged())) {
            return null;
        }
        if (this._service.canUseEnergy(3)) {
            return this._sinkReply;
        }
        return null;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbttagcompound) {
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbttagcompound) {
    }

    @Override
    public void tick() {
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return true;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return true;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }
}

