/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.gui;

import logisticspipes.LogisticsPipes;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class GuiReopenPacket
extends CoordinatesPacket {
    private int guiID;

    public GuiReopenPacket(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeInt(this.getGuiID());
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.guiID = input.readInt();
    }

    @Override
    public void processPacket(EntityPlayer player) {
        player.openGui((Object)LogisticsPipes.instance, this.getGuiID(), player.field_70170_p, this.getPosX(), this.getPosY(), this.getPosZ());
    }

    @Override
    public ModernPacket template() {
        return new GuiReopenPacket(this.getId());
    }

    public int getGuiID() {
        return this.guiID;
    }

    public GuiReopenPacket setGuiID(int guiID) {
        this.guiID = guiID;
        return this;
    }
}

