/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.cc;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.shared.computer.blocks.TileComputer;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import java.lang.reflect.Field;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.cc.LPPeripheralProvider;
import logisticspipes.proxy.cc.wrapper.CCCommandWrapper;
import logisticspipes.proxy.computers.wrapper.CCObjectWrapper;
import logisticspipes.proxy.interfaces.ICCProxy;
import logisticspipes.recipes.CraftingParts;
import net.minecraft.tileentity.TileEntity;

public class CCProxy
implements ICCProxy {
    private Field target;

    public CCProxy() throws NoSuchFieldException, SecurityException {
        ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)new LPPeripheralProvider());
        this.target = Thread.class.getDeclaredField("target");
        this.target.setAccessible(true);
    }

    @Override
    public boolean isTurtle(TileEntity tile) {
        return tile instanceof TileTurtle;
    }

    @Override
    public boolean isComputer(TileEntity tile) {
        return tile instanceof TileComputer;
    }

    @Override
    public boolean isCC() {
        return true;
    }

    private Runnable getTaget(Thread thread2) {
        try {
            return (Runnable)this.target.get(thread2);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isLuaThread(Thread thread2) {
        Runnable tar = this.getTaget(thread2);
        if (tar == null) {
            return false;
        }
        return tar.getClass().getName().contains("org.luaj.vm2.LuaThread");
    }

    @Override
    public void queueEvent(String event, Object[] arguments, LogisticsTileGenericPipe tile) {
        for (IComputerAccess computer : tile.connections.keySet()) {
            computer.queueEvent(event, arguments);
        }
    }

    @Override
    public void setTurtleConnect(boolean flag, LogisticsTileGenericPipe tile) {
        tile.turtleConnect[tile.connections.get((Object)tile.currentPC).ordinal()] = flag;
        tile.scheduleNeighborChange();
    }

    @Override
    public boolean getTurtleConnect(LogisticsTileGenericPipe tile) {
        return tile.turtleConnect[tile.connections.get(tile.currentPC).ordinal()];
    }

    @Override
    public int getLastCCID(LogisticsTileGenericPipe tile) {
        if (tile.currentPC == null) {
            return -1;
        }
        return tile.currentPC.getID();
    }

    @Override
    public void handleMesssage(int computerId, Object message, LogisticsTileGenericPipe tile, int sourceId) {
        tile.connections.keySet().stream().filter(computer -> computer.getID() == computerId).forEach(computer -> computer.queueEvent("LP_MESSAGE", new Object[]{sourceId, message}));
    }

    @Override
    public void addCraftingRecipes(CraftingParts parts) {
    }

    @Override
    public Object getAnswer(Object object) {
        return CCObjectWrapper.getWrappedObject(object, CCCommandWrapper.WRAPPER);
    }
}

