/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.computers.objects;

import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCQueued;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;

@CCType(name="FilterInventory")
public class CCFilterInventory {
    private final ItemIdentifierInventory inv;

    public CCFilterInventory(ItemIdentifierInventory inv) {
        this.inv = inv;
    }

    @CCCommand(description="Returns the size of this FilterInventory")
    public int getSizeInventory() {
        return this.inv.func_70302_i_();
    }

    @CCCommand(description="Returns the ItemIdentifier in the given slot")
    @CCQueued
    public ItemIdentifier getItemIdentifier(Double slot) {
        int s = slot.intValue();
        if (s <= 0 || s > this.getSizeInventory()) {
            throw new UnsupportedOperationException("Slot out of Inventory");
        }
        if ((double)s != slot) {
            throw new UnsupportedOperationException("Slot not an Integer");
        }
        if (this.inv.getIDStackInSlot(--s) == null) {
            return null;
        }
        return this.inv.getIDStackInSlot(s).getItem();
    }

    @CCCommand(description="Sets the ItemIdentifier at the given slot")
    @CCQueued
    public void setItemIdentifier(Double slot, ItemIdentifier ident) {
        int s = slot.intValue();
        if (s <= 0 || s > this.getSizeInventory()) {
            throw new UnsupportedOperationException("Slot out of Inventory");
        }
        if ((double)s != slot) {
            throw new UnsupportedOperationException("Slot not an Integer");
        }
        this.inv.setInventorySlotContents(--s, ident.makeStack(1));
    }

    @CCCommand(description="Sets the ItemIdentifierStack at the given slot")
    @CCQueued
    public void clearSlot(Double slot) {
        int s = slot.intValue();
        if (s <= 0 || s > this.getSizeInventory()) {
            throw new UnsupportedOperationException("Slot out of Inventory");
        }
        if ((double)s != slot) {
            throw new UnsupportedOperationException("Slot not an Integer");
        }
        this.inv.setInventorySlotContents(--s, null);
    }
}

