/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.computers.objects;

import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCQueued;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;

@CCType(name="FilterInventory")
public class CCItemIdentifierInventory {
    private final ItemIdentifierInventory inv;

    public CCItemIdentifierInventory(ItemIdentifierInventory inv) {
        this.inv = inv;
    }

    @CCCommand(description="Returns the size of this FilterInventory")
    public int getSizeInventory() {
        return this.inv.func_70302_i_();
    }

    @CCCommand(description="Returns the ItemIdentifierStack in the given slot")
    @CCQueued
    public ItemIdentifierStack getItemIdentifierStack(Double slot) {
        int s = slot.intValue();
        if (s <= 0 || s > this.getSizeInventory()) {
            throw new UnsupportedOperationException("Slot out of Inventory");
        }
        if ((double)s != slot) {
            throw new UnsupportedOperationException("Slot not an Integer");
        }
        return this.inv.getIDStackInSlot(--s);
    }

    @CCCommand(description="Sets the ItemIdentifierStack at the given slot")
    @CCQueued
    public void setItemIdentifierStack(Double slot, ItemIdentifierStack stack) {
        int s = slot.intValue();
        if (s <= 0 || s > this.getSizeInventory()) {
            throw new UnsupportedOperationException("Slot out of Inventory");
        }
        if ((double)s != slot) {
            throw new UnsupportedOperationException("Slot not an Integer");
        }
        this.inv.setInventorySlotContents(--s, stack);
    }

    @CCCommand(description="Sets the ItemIdentifierStack at the given slot")
    @CCQueued
    public void clearSlot(Double slot) {
        int s = slot.intValue();
        if (s <= 0 || s > this.getSizeInventory()) {
            throw new UnsupportedOperationException("Slot out of Inventory");
        }
        if ((double)s != slot) {
            throw new UnsupportedOperationException("Slot not an Integer");
        }
        this.inv.setInventorySlotContents(--s, null);
    }
}

