/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.td;

import cofh.core.util.helpers.BlockHelper;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.GridItem;
import cofh.thermaldynamics.duct.item.TravelingItem;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.IDuctHolder;
import cofh.thermaldynamics.duct.tiles.TileDuctItem;
import cofh.thermaldynamics.multiblock.IGridTile;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.multiblock.RouteCache;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import logisticspipes.asm.td.ILPTravelingItemInfo;
import logisticspipes.asm.te.ILPTEInformation;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.td.LPDuctUnitItem;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.routing.pathfinder.IRouteProvider;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.CacheHolder;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.tuples.Pair;
import logisticspipes.utils.tuples.Triplet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import network.rs485.logisticspipes.world.CoordinateUtils;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public class TDDuctInformationProvider
implements IPipeInformationProvider,
IRouteProvider {
    private final TileDuctItem duct;

    public TDDuctInformationProvider(TileDuctItem duct) {
        this.duct = duct;
    }

    @Override
    public boolean isCorrect(IPipeInformationProvider.ConnectionPipeType type) {
        return this.duct != null && !this.duct.func_145837_r() && SimpleServiceLocator.thermalDynamicsProxy.isActive();
    }

    @Override
    public int getX() {
        return this.duct.func_174877_v().func_177958_n();
    }

    @Override
    public int getY() {
        return this.duct.func_174877_v().func_177956_o();
    }

    @Override
    public int getZ() {
        return this.duct.func_174877_v().func_177952_p();
    }

    @Override
    public World getWorld() {
        return this.duct.func_145831_w();
    }

    @Override
    public boolean isRouterInitialized() {
        return !this.duct.func_145837_r();
    }

    @Override
    public boolean isRoutingPipe() {
        return false;
    }

    @Override
    public CoreRoutedPipe getRoutingPipe() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TileEntity getNextConnectedTile(EnumFacing direction) {
        return BlockHelper.getAdjacentTileEntity((TileEntity)this.duct, (EnumFacing)direction);
    }

    @Override
    public boolean isFirewallPipe() {
        return false;
    }

    @Override
    public IFilter getFirewallFilter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TileEntity getTile() {
        return this.duct;
    }

    @Override
    public boolean divideNetwork() {
        return false;
    }

    @Override
    public boolean powerOnly() {
        return false;
    }

    @Override
    public boolean isOnewayPipe() {
        return false;
    }

    @Override
    public boolean isOutputOpen(EnumFacing direction) {
        return ((DuctUnitItem)this.duct.getDuct(DuctToken.ITEMS)).isSideConnected((byte)direction.ordinal());
    }

    @Override
    public boolean canConnect(TileEntity to, EnumFacing direction, boolean ignoreSystemDisconnect) {
        TileEntity connection = CoordinateUtils.add(new DoubleCoordinates(this.duct.func_174877_v()), direction).getTileEntity((IBlockAccess)this.duct.func_145831_w());
        if (this.duct.isSideBlocked((int)((byte)direction.ordinal()))) {
            return false;
        }
        if (!(connection instanceof IDuctHolder)) {
            return false;
        }
        DuctUnitItem connectedDuct = (DuctUnitItem)((IDuctHolder)connection).getDuct(DuctToken.ITEMS);
        if (connectedDuct instanceof LPDuctUnitItem) {
            return !((LPDuctUnitItem)connectedDuct).isLPBlockedSide(direction.func_176734_d().ordinal(), ignoreSystemDisconnect);
        }
        return !connectedDuct.parent.isSideBlocked(direction.func_176734_d().ordinal());
    }

    @Override
    public double getDistance() {
        return Math.max(((DuctUnitItem)this.duct.getDuct(DuctToken.ITEMS)).getDuctLength(), 0);
    }

    @Override
    public double getDistanceWeight() {
        return Math.max(((DuctUnitItem)this.duct.getDuct(DuctToken.ITEMS)).getWeight(), 0);
    }

    @Override
    public boolean isItemPipe() {
        return true;
    }

    @Override
    public boolean isFluidPipe() {
        return false;
    }

    @Override
    public boolean isPowerPipe() {
        return false;
    }

    @Override
    public double getDistanceTo(int destinationint, EnumFacing ignore, ItemIdentifier ident, boolean isActive, double traveled, double max, List<DoubleCoordinates> visited) {
        if (traveled >= max) {
            return 2.147483647E9;
        }
        IRouter destination = SimpleServiceLocator.routerManager.getRouter(destinationint);
        if (destination == null) {
            return 2.147483647E9;
        }
        LinkedList paramIterable = ((DuctUnitItem)this.duct.getDuct((DuctToken)DuctToken.ITEMS)).getCache((boolean)true).outputRoutes;
        double closesedConnection = 2.147483647E9;
        for (Route localRoute1 : paramIterable) {
            DoubleCoordinates pos;
            if (!(localRoute1.endPoint instanceof LPDuctUnitItem)) continue;
            LPDuctUnitItem lpDuct = (LPDuctUnitItem)localRoute1.endPoint;
            if (traveled + (double)localRoute1.pathWeight > max || visited.contains(pos = new DoubleCoordinates(lpDuct.pipe))) continue;
            visited.add(pos);
            double distance = lpDuct.pipe.getDistanceTo(destinationint, EnumFacing.func_82600_a((int)localRoute1.pathDirections.get(localRoute1.pathDirections.size() - 1)).func_176734_d(), ident, isActive, traveled + (double)localRoute1.pathWeight, Math.min(max, closesedConnection), visited);
            visited.remove(pos);
            if (distance == 2.147483647E9 || !(distance + (double)localRoute1.pathWeight < closesedConnection)) continue;
            closesedConnection = distance + (double)localRoute1.pathWeight;
        }
        return closesedConnection;
    }

    @Override
    public boolean acceptItem(LPTravelingItem item, TileEntity from) {
        if (item instanceof LPTravelingItem.LPTravelingItemServer) {
            IRouter destination;
            LPTravelingItem.LPTravelingItemServer serverItem = (LPTravelingItem.LPTravelingItemServer)item;
            int id = serverItem.getInfo().destinationint;
            if (id == -1) {
                id = SimpleServiceLocator.routerManager.getIDforUUID(serverItem.getInfo().destinationUUID);
            }
            if ((destination = SimpleServiceLocator.routerManager.getRouter(id)) == null) {
                return false;
            }
            RouteCache routes = ((DuctUnitItem)this.duct.getDuct(DuctToken.ITEMS)).getCache(true);
            LinkedList paramIterable = routes.outputRoutes;
            Route route = null;
            Object cache = null;
            Triplet<Integer, ItemIdentifier, Boolean> key = new Triplet<Integer, ItemIdentifier, Boolean>(id, item.getItemIdentifierStack().getItem(), serverItem.getInfo()._transportMode == IRoutedItem.TransportMode.Active);
            if (this.duct instanceof ILPTEInformation && ((ILPTEInformation)this.duct).getObject() != null) {
                cache = ((ILPTEInformation)this.duct).getObject().getCacheHolder().getCacheFor(CacheHolder.CacheTypes.Routing, key);
            }
            if (cache instanceof Route && !routes.outputRoutes.contains(route = (Route)cache)) {
                route = null;
            }
            if (route == null) {
                Pair<Double, Route> closesedConnection = null;
                ArrayList<DoubleCoordinates> visited = new ArrayList<DoubleCoordinates>();
                visited.add(new DoubleCoordinates(from));
                for (Route localRoute1 : paramIterable) {
                    DoubleCoordinates pos;
                    if (!(localRoute1.endPoint instanceof LPDuctUnitItem)) continue;
                    LPDuctUnitItem lpDuct = (LPDuctUnitItem)localRoute1.endPoint;
                    double max = 2.147483647E9;
                    if (closesedConnection != null) {
                        max = (Double)closesedConnection.getValue1();
                    }
                    if (visited.contains(pos = new DoubleCoordinates(lpDuct.pipe))) continue;
                    visited.add(pos);
                    double distance = lpDuct.pipe.getDistanceTo(id, EnumFacing.func_82600_a((int)localRoute1.pathDirections.get(localRoute1.pathDirections.size() - 1)).func_176734_d(), item.getItemIdentifierStack().getItem(), serverItem.getInfo()._transportMode == IRoutedItem.TransportMode.Active, localRoute1.pathWeight, max, visited);
                    visited.remove(pos);
                    if (distance == 2.147483647E9 || closesedConnection != null && !(distance + (double)localRoute1.pathDirections.size() < (Double)closesedConnection.getValue1())) continue;
                    closesedConnection = new Pair<Double, Route>(distance + (double)localRoute1.pathWeight, localRoute1);
                }
                if (closesedConnection != null) {
                    route = (Route)closesedConnection.getValue2();
                }
            }
            if (route != null) {
                if (this.duct instanceof ILPTEInformation && ((ILPTEInformation)this.duct).getObject() != null) {
                    ((ILPTEInformation)this.duct).getObject().getCacheHolder().setCache(CacheHolder.CacheTypes.Routing, key, route);
                }
                TravelingItem travelItem = new TravelingItem(item.getItemIdentifierStack().makeNormalStack(), (IGridTile)this.duct.getDuct(DuctToken.ITEMS), route.copy(), (byte)serverItem.output.ordinal(), 1);
                ((ILPTravelingItemInfo)travelItem).setLPRoutingInfoAddition(serverItem.getInfo());
                ((DuctUnitItem)this.duct.getDuct(DuctToken.ITEMS)).insertNewItem(travelItem);
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    @Override
    public void refreshTileCacheOnSide(EnumFacing side) {
        if (((DuctUnitItem)this.duct.getDuct(DuctToken.ITEMS)).getGrid() == null) {
            return;
        }
        ((GridItem)((DuctUnitItem)this.duct.getDuct(DuctToken.ITEMS)).getGrid()).destroyAndRecreate();
    }

    @Override
    public boolean isMultiBlock() {
        return false;
    }

    @Override
    public Stream<TileEntity> getPartsOfPipe() {
        return Stream.empty();
    }

    @Override
    public List<IRouteProvider.RouteInfo> getConnectedPipes(EnumFacing from) {
        ArrayList<IRouteProvider.RouteInfo> list = new ArrayList<IRouteProvider.RouteInfo>();
        if (((DuctUnitItem)this.duct.getDuct(DuctToken.ITEMS)).getGrid() == null) {
            return null;
        }
        LinkedList paramIterable = ((DuctUnitItem)this.duct.getDuct((DuctToken)DuctToken.ITEMS)).getCache((boolean)true).outputRoutes;
        for (Route localRoute1 : paramIterable) {
            if (!(localRoute1.endPoint instanceof LPDuctUnitItem)) continue;
            LPDuctUnitItem lpDuct = (LPDuctUnitItem)localRoute1.endPoint;
            list.add(new IRouteProvider.RouteInfo(lpDuct.pipe, localRoute1.pathWeight, EnumFacing.func_82600_a((int)localRoute1.pathDirections.get(localRoute1.pathDirections.size() - 1))));
        }
        return list;
    }
}

