/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request.resources;

import com.google.common.base.Objects;
import java.util.BitSet;
import javax.annotation.Nonnull;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.request.resources.IResource;
import logisticspipes.routing.IRouter;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.string.ChatColor;
import net.minecraft.item.ItemStack;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

public class DictResource
implements IResource {
    private final Object[] ccTypeHolder = new Object[1];
    private final IRequestItems requester;
    public ItemIdentifierStack stack;
    public boolean use_od = false;
    public boolean ignore_dmg = false;
    public boolean ignore_nbt = false;
    public boolean use_category = false;

    public DictResource(ItemIdentifierStack stack, IRequestItems requester) {
        this.stack = stack;
        this.requester = requester;
    }

    public DictResource(LPDataInput input) {
        this.stack = input.readItemIdentifierStack();
        this.requester = null;
        BitSet bits = input.readBitSet();
        this.use_od = bits.get(0);
        this.ignore_dmg = bits.get(1);
        this.ignore_nbt = bits.get(2);
        this.use_category = bits.get(3);
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeItemIdentifierStack(this.stack);
        BitSet bits = new BitSet();
        bits.set(0, this.use_od);
        bits.set(1, this.ignore_dmg);
        bits.set(2, this.ignore_nbt);
        bits.set(3, this.use_category);
        output.writeBitSet(bits);
    }

    @Override
    public ItemIdentifier getAsItem() {
        return this.stack.getItem();
    }

    @Override
    public int getRequestedAmount() {
        return this.stack.getStackSize();
    }

    @Override
    public boolean matches(ItemIdentifier other, IResource.MatchSettings settings) {
        if ((this.use_od || this.use_category) && this.stack.getItem().getDictIdentifiers() != null && other.getDictIdentifiers() != null && this.stack.getItem().getDictIdentifiers().canMatch(other.getDictIdentifiers(), true, this.use_category)) {
            return true;
        }
        ItemStack stack_n = this.stack.makeNormalStack();
        ItemStack other_n = other.makeNormalStack(1);
        if (stack_n.func_77973_b() != other_n.func_77973_b()) {
            return false;
        }
        if (stack_n.func_77952_i() != other_n.func_77952_i()) {
            if (stack_n.func_77981_g()) {
                return false;
            }
            if (!this.ignore_dmg) {
                return false;
            }
        }
        if (this.ignore_nbt) {
            return true;
        }
        if (stack_n.func_77942_o() ^ other_n.func_77942_o()) {
            return false;
        }
        if (!stack_n.func_77942_o() && !other_n.func_77942_o()) {
            return true;
        }
        return ItemStack.func_77970_a((ItemStack)stack_n, (ItemStack)other_n);
    }

    @Override
    @Nonnull
    public IRouter getRouter() {
        return this.requester.getRouter();
    }

    @Override
    public IResource clone(int multiplier) {
        ItemIdentifierStack stack = this.stack.clone();
        stack.setStackSize(stack.getStackSize() * multiplier);
        DictResource clone = new DictResource(stack, this.requester);
        clone.use_od = this.use_od;
        clone.ignore_dmg = this.ignore_dmg;
        clone.ignore_nbt = this.ignore_nbt;
        clone.use_category = this.use_category;
        return clone;
    }

    public DictResource clone() {
        DictResource clone = new DictResource(this.stack.clone(), this.requester);
        clone.use_od = this.use_od;
        clone.ignore_dmg = this.ignore_dmg;
        clone.ignore_nbt = this.ignore_nbt;
        clone.use_category = this.use_category;
        return clone;
    }

    public IRequestItems getTarget() {
        return this.requester;
    }

    public ItemIdentifier getItem() {
        return this.stack.getItem();
    }

    public ItemIdentifierStack getItemStack() {
        return this.stack;
    }

    @Override
    public boolean mergeForDisplay(IResource resource, int withAmount) {
        if (resource instanceof DictResource && ((DictResource)resource).use_od == this.use_od && ((DictResource)resource).ignore_dmg == this.ignore_dmg && ((DictResource)resource).ignore_nbt == this.ignore_nbt && ((DictResource)resource).use_category == this.use_category && ((DictResource)resource).getItem().equals(this.getItem())) {
            this.stack.setStackSize(this.stack.getStackSize() + withAmount);
            return true;
        }
        return false;
    }

    @Override
    public IResource copyForDisplayWith(int amount) {
        ItemIdentifierStack stack = this.stack.clone();
        stack.setStackSize(amount);
        DictResource clone = new DictResource(stack, null);
        clone.use_od = this.use_od;
        clone.ignore_dmg = this.ignore_dmg;
        clone.ignore_nbt = this.ignore_nbt;
        clone.use_category = this.use_category;
        return clone;
    }

    @Override
    public String getDisplayText(IResource.ColorCode code) {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)ChatColor.GRAY);
        builder.append("{");
        if (code != IResource.ColorCode.NONE) {
            builder.append((Object)(code == IResource.ColorCode.MISSING ? ChatColor.RED : ChatColor.GREEN));
        }
        builder.append(this.stack.getFriendlyName());
        if (code != IResource.ColorCode.NONE) {
            builder.append((Object)ChatColor.GRAY);
        }
        builder.append(" [");
        builder.append((Object)(this.use_od ? ChatColor.GREEN : ChatColor.RED));
        builder.append("OreDict");
        builder.append((Object)ChatColor.GRAY);
        builder.append(", ");
        builder.append((Object)(this.use_category ? ChatColor.GREEN : ChatColor.RED));
        builder.append("OreCat");
        builder.append((Object)ChatColor.GRAY);
        builder.append(", ");
        builder.append((Object)(this.ignore_dmg ? ChatColor.GREEN : ChatColor.RED));
        builder.append("IgnDmg");
        builder.append((Object)ChatColor.GRAY);
        builder.append(", ");
        builder.append((Object)(this.ignore_nbt ? ChatColor.GREEN : ChatColor.RED));
        builder.append("IgnNBT");
        builder.append((Object)ChatColor.GRAY);
        return builder.append("]}").toString();
    }

    @Override
    public ItemIdentifierStack getDisplayItem() {
        return this.stack;
    }

    public DictResource loadFromBitSet(BitSet bits) {
        this.use_od = bits.get(0);
        this.ignore_dmg = bits.get(1);
        this.ignore_nbt = bits.get(2);
        this.use_category = bits.get(3);
        return this;
    }

    public BitSet getBitSet() {
        BitSet bits = new BitSet();
        bits.set(0, this.use_od);
        bits.set(1, this.ignore_dmg);
        bits.set(2, this.ignore_nbt);
        bits.set(3, this.use_category);
        return bits;
    }

    public Identifier getIdentifier() {
        return new Identifier();
    }

    @Override
    public Object[] getTypeHolder() {
        return this.ccTypeHolder;
    }

    public class Identifier {
        private ItemIdentifier getItem() {
            return DictResource.this.stack.getItem();
        }

        private BitSet getBitSet() {
            return DictResource.this.getBitSet();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getItem(), this.getBitSet()});
        }

        public boolean equals(Object obj) {
            if (obj instanceof Identifier) {
                Identifier id = (Identifier)obj;
                return id.getItem().equals(this.getItem()) && id.getBitSet().equals(this.getBitSet());
            }
            return false;
        }
    }
}

