/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.transport;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.transport.PipeTransportLogistics;

public class LPItemList
implements Iterable<LPTravelingItem> {
    private final BiMap<Integer, LPTravelingItem> items = HashBiMap.create();
    private final Set<LPTravelingItem> toLoad = new HashSet<LPTravelingItem>();
    private final Set<LPTravelingItem> toAdd = new HashSet<LPTravelingItem>();
    private final Set<LPTravelingItem> toRemove = new HashSet<LPTravelingItem>();
    private int delay = 0;
    private final PipeTransportLogistics pipe;
    private boolean iterating = false;

    public LPItemList(PipeTransportLogistics pipe) {
        this.pipe = pipe;
    }

    public void add(LPTravelingItem item) {
        if (this.iterating) {
            this.toAdd.add(item);
            return;
        }
        if (this.items.containsValue((Object)item)) {
            return;
        }
        item.setContainer(this.pipe.container);
        this.items.put((Object)item.getId(), (Object)item);
    }

    private void addAll(Collection<? extends LPTravelingItem> collection) {
        collection.forEach(this::add);
    }

    public LPTravelingItem get(int id) {
        return (LPTravelingItem)this.items.get((Object)id);
    }

    void scheduleLoad(LPTravelingItem item) {
        this.delay = 10;
        this.toLoad.add(item);
    }

    private void loadScheduledItems() {
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        this.addAll(this.toLoad);
        this.toLoad.clear();
    }

    public void scheduleAdd() {
        this.iterating = true;
    }

    public void addScheduledItems() {
        this.iterating = false;
        this.addAll(this.toAdd);
        this.toAdd.clear();
    }

    public boolean scheduleRemoval(LPTravelingItem item) {
        return this.toRemove.add(item);
    }

    public boolean unscheduleRemoval(LPTravelingItem item) {
        return this.toRemove.remove(item);
    }

    void removeScheduledItems() {
        this.items.values().removeAll(this.toRemove);
        this.toRemove.clear();
    }

    void purgeBadItems() {
        Iterator it = this.items.values().iterator();
        while (it.hasNext()) {
            LPTravelingItem item = (LPTravelingItem)it.next();
            if (item.isCorrupted()) {
                it.remove();
                continue;
            }
            if (item.getContainer() == this.pipe.container) continue;
            it.remove();
        }
    }

    public void flush() {
        this.loadScheduledItems();
        this.removeScheduledItems();
        this.purgeBadItems();
    }

    @Override
    @Nonnull
    public Iterator<LPTravelingItem> iterator() {
        return this.items.values().iterator();
    }

    void clear() {
        this.items.clear();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }
}

