/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.transport;

import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.pipe.PipeFluidUpdate;
import logisticspipes.pipes.basic.fluid.FluidRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.transport.PipeTransportLogistics;
import logisticspipes.utils.SafeTimeTracker;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class PipeFluidTransportLogistics
extends PipeTransportLogistics {
    public FluidTank[] sideTanks = new FluidTank[EnumFacing.field_82609_l.length];
    public FluidTank internalTank = new FluidTank(this.getInnerCapacity());
    public FluidStack[] renderCache = new FluidStack[7];
    private final SafeTimeTracker tracker = new SafeTimeTracker(10L);
    private long clientSyncCounter = 30L;
    public byte initClient = 0;
    private static final EnumFacing[] orientations = EnumFacing.values();

    public PipeFluidTransportLogistics() {
        super(true);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            this.sideTanks[dir.ordinal()] = new FluidTank(this.getSideCapacity());
        }
    }

    public IFluidHandler getIFluidHandler(EnumFacing face) {
        return new FluidHandler(face);
    }

    private FluidRoutedPipe getFluidPipe() {
        return (FluidRoutedPipe)this.getPipe();
    }

    public IFluidTankProperties[] getTankProperties(EnumFacing from) {
        if (from == null) {
            return this.internalTank.getTankProperties();
        }
        return this.sideTanks[from.ordinal()].getTankProperties();
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (from.ordinal() < EnumFacing.field_82609_l.length && this.getFluidPipe().canReceiveFluid()) {
            return this.sideTanks[from.ordinal()].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (from.ordinal() < EnumFacing.field_82609_l.length) {
            return this.sideTanks[from.ordinal()].drain(maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (this.sideTanks[from.ordinal()].getFluid() == null || !this.sideTanks[from.ordinal()].getFluid().isFluidEqual(resource)) {
            return new FluidStack(resource.getFluid(), 0);
        }
        return this.drain(from, resource.amount, doDrain);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            if (!nbttagcompound.func_74764_b("tank[" + direction.ordinal() + "]")) continue;
            this.sideTanks[direction.ordinal()].readFromNBT(nbttagcompound.func_74775_l("tank[" + direction.ordinal() + "]"));
        }
        if (nbttagcompound.func_74764_b("tank[middle]")) {
            this.internalTank.readFromNBT(nbttagcompound.func_74775_l("tank[middle]"));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            NBTTagCompound subTag = new NBTTagCompound();
            this.sideTanks[direction.ordinal()].writeToNBT(subTag);
            nbttagcompound.func_74782_a("tank[" + direction.ordinal() + "]", (NBTBase)subTag);
        }
        NBTTagCompound subTag = new NBTTagCompound();
        this.internalTank.writeToNBT(subTag);
        nbttagcompound.func_74782_a("tank[middle]", (NBTBase)subTag);
    }

    public int getInnerCapacity() {
        return 10000;
    }

    public int getSideCapacity() {
        return 5000;
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            FluidStack stack;
            if (MainProxy.checkPipesConnections(this.container, this.container.getTile(orientations[direction.ordinal()]), orientations[direction.ordinal()])) continue;
            if (MainProxy.isServer((IBlockAccess)this.getWorld()) && (stack = this.sideTanks[direction.ordinal()].getFluid()) != null) {
                this.sideTanks[direction.ordinal()].setFluid(null);
                this.internalTank.fill(stack, true);
            }
            if (this.renderCache[direction.ordinal()] == null) continue;
            this.renderCache[direction.ordinal()].amount = 1;
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        this.updateFluid();
    }

    private void updateFluid() {
        if (MainProxy.isClient((IBlockAccess)this.getWorld())) {
            return;
        }
        if (this.tracker.markTimeIfDelay(this.getWorld())) {
            ModernPacket packet;
            boolean init = false;
            if (++this.clientSyncCounter > 40L) {
                this.clientSyncCounter = 0L;
                init = true;
            }
            if (this.clientSyncCounter < 0L) {
                this.clientSyncCounter = 0L;
            }
            if ((packet = this.computeFluidUpdate(init, true)) != null) {
                MainProxy.sendPacketToAllWatchingChunk(this.container, packet);
            }
        }
    }

    private ModernPacket computeFluidUpdate(boolean initPacket, boolean persistChange) {
        boolean changed = false;
        if (this.initClient > 0) {
            this.initClient = (byte)(this.initClient - 1);
            if (this.initClient == 1) {
                changed = true;
            }
        }
        FluidStack[] renderCache = (FluidStack[])this.renderCache.clone();
        for (EnumFacing dir : orientations) {
            FluidStack current = dir != null ? this.sideTanks[dir.ordinal()].getFluid() : this.internalTank.getFluid();
            FluidStack prev = renderCache[dir.ordinal()];
            if (prev == null && current == null) continue;
            if (prev == null && current != null) {
                changed = true;
                renderCache[dir.ordinal()] = current.copy();
                continue;
            }
            if (prev != null && current == null) {
                changed = true;
                renderCache[dir.ordinal()] = null;
                continue;
            }
            if (prev.getFluid() != current.getFluid() || initPacket) {
                changed = true;
                renderCache[dir.ordinal()] = new FluidStack(current.getFluid(), renderCache[dir.ordinal()].amount);
            }
            if (prev.amount == current.amount && !initPacket) continue;
            changed = true;
            renderCache[dir.ordinal()].amount = current.amount;
        }
        if (persistChange) {
            this.renderCache = renderCache;
        }
        if (changed || initPacket) {
            return PacketHandler.getPacket(PipeFluidUpdate.class).setRenderCache(renderCache).setTilePos(this.container).setChunkDataPacket(initPacket);
        }
        return null;
    }

    @Override
    protected boolean isItemExitable(ItemIdentifierStack stack) {
        return true;
    }

    @Override
    protected boolean isPipeCheck(TileEntity tile) {
        return SimpleServiceLocator.pipeInformationManager.isPipe(tile);
    }

    public class FluidHandler
    implements IFluidHandler {
        private EnumFacing from;

        FluidHandler(EnumFacing from) {
            this.from = from;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (this.from.ordinal() < EnumFacing.field_82609_l.length && PipeFluidTransportLogistics.this.getFluidPipe().canReceiveFluid()) {
                return PipeFluidTransportLogistics.this.sideTanks[this.from.ordinal()].fill(resource, doFill);
            }
            return 0;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (this.from.ordinal() < EnumFacing.field_82609_l.length) {
                return PipeFluidTransportLogistics.this.sideTanks[this.from.ordinal()].drain(maxDrain, doDrain);
            }
            return null;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (PipeFluidTransportLogistics.this.sideTanks[this.from.ordinal()].getFluid() == null || !PipeFluidTransportLogistics.this.sideTanks[this.from.ordinal()].getFluid().isFluidEqual(resource)) {
                return new FluidStack(resource.getFluid(), 0);
            }
            return this.drain(resource.amount, doDrain);
        }

        public IFluidTankProperties[] getTankProperties() {
            if (this.from.ordinal() < EnumFacing.field_82609_l.length) {
                return PipeFluidTransportLogistics.this.sideTanks[this.from.ordinal()].getTankProperties();
            }
            return null;
        }
    }
}

