/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.item;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.ISaveState;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import network.rs485.logisticspipes.util.items.ItemStackLoader;

public class SimpleStackInventory
implements IInventory,
ISaveState,
Iterable<Pair<ItemStack, Integer>> {
    private static final TextComponentString TEXT_COMPONENT_EMPTY = new TextComponentString("");
    private final NonNullList<ItemStack> stackList;
    private final String _name;
    private final int _stackLimit;
    private final LinkedList<ISimpleInventoryEventHandler> _listener = new LinkedList();

    public SimpleStackInventory(int size, String name, int stackLimit) {
        this.stackList = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        this._name = name;
        this._stackLimit = stackLimit;
    }

    public int func_70302_i_() {
        return this.stackList.size();
    }

    public boolean func_191420_l() {
        return this.stackList.stream().allMatch(ItemStack::func_190926_b);
    }

    @Nonnull
    public ItemStack func_70301_a(int i) {
        return (ItemStack)this.stackList.get(i);
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int count2) {
        ItemStack stack = (ItemStack)this.stackList.get(slot);
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190916_E() > count2) {
            ItemStack ret = stack.func_77946_l();
            ret.func_190920_e(count2);
            stack.func_190920_e(stack.func_190916_E() - count2);
            return ret;
        }
        return (ItemStack)this.stackList.set(slot, (Object)ItemStack.field_190927_a);
    }

    public void func_70299_a(int slot, @Nonnull ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            this.stackList.set(slot, (Object)ItemStack.field_190927_a);
        } else {
            this.stackList.set(slot, (Object)itemstack.func_77946_l());
        }
    }

    @Nonnull
    public String func_70005_c_() {
        return this._name;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return TEXT_COMPONENT_EMPTY;
    }

    public int func_70297_j_() {
        return this._stackLimit;
    }

    public void func_70296_d() {
        for (ISimpleInventoryEventHandler handler : this._listener) {
            handler.InventoryChanged(this);
        }
    }

    public boolean func_70300_a(@Nonnull EntityPlayer entityplayer) {
        return false;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound, "");
    }

    public void readFromNBT(NBTTagCompound nbttagcompound, String prefix) {
        NBTTagList nbttaglist = nbttagcompound.func_150295_c(prefix + "items", (int)nbttagcompound.func_74732_a());
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound nbttagcompound2 = nbttaglist.func_150305_b(j);
            int index = nbttagcompound2.func_74762_e("index");
            if (index < this.stackList.size()) {
                this.stackList.set(index, (Object)ItemStackLoader.loadAndFixItemStackFromNBT(nbttagcompound2));
                continue;
            }
            LogisticsPipes.log.fatal("SimpleInventory: java.lang.ArrayIndexOutOfBoundsException: " + index + " of " + this.stackList.size());
        }
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbttagcompound) {
        this.writeToNBT(nbttagcompound, "");
    }

    public void writeToNBT(NBTTagCompound nbttagcompound, String prefix) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int j = 0; j < this.stackList.size(); ++j) {
            ItemStack stack = (ItemStack)this.stackList.get(j);
            if (stack.func_190926_b()) continue;
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttaglist.func_74742_a((NBTBase)nbttagcompound2);
            nbttagcompound2.func_74768_a("index", j);
            stack.func_77955_b(nbttagcompound2);
        }
        nbttagcompound.func_74782_a(prefix + "items", (NBTBase)nbttaglist);
        nbttagcompound.func_74768_a(prefix + "itemsCount", this.stackList.size());
    }

    public void dropContents(World world, BlockPos pos) {
        if (MainProxy.isServer((IBlockAccess)world)) {
            for (int i = 0; i < this.stackList.size(); ++i) {
                this.dropSlot(i, world, pos);
            }
        }
    }

    private void dropSlot(int slot, World world, BlockPos pos) {
        ItemStack slotStack = (ItemStack)this.stackList.get(slot);
        IntStream.range(0, slotStack.func_190916_E() / slotStack.func_77976_d() + 1).mapToObj(i -> this.func_70298_a(slot, slotStack.func_77976_d())).filter(dropStack -> !dropStack.func_190926_b()).forEach(dropStack -> {
            float f1 = 0.7f;
            double d = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, dropStack);
            entityitem.func_174869_p();
            world.func_72838_d((Entity)entityitem);
        });
    }

    public void addListener(ISimpleInventoryEventHandler listner) {
        if (!this._listener.contains(listner)) {
            this._listener.add(listner);
        }
    }

    public void removeListener(ISimpleInventoryEventHandler listner) {
        this._listener.remove(listner);
    }

    @Nonnull
    public ItemStack func_70304_b(int i) {
        return (ItemStack)this.stackList.set(i, (Object)ItemStack.field_190927_a);
    }

    private int tryAddToSlot(int i, @Nonnull ItemStack stack, int realstacklimit) {
        ItemStack slotStack = (ItemStack)this.stackList.get(i);
        if (slotStack.func_190926_b()) {
            ItemStack copy = stack.func_77946_l();
            this.stackList.set(i, (Object)copy);
            copy.func_190920_e(Math.min(copy.func_190916_E(), realstacklimit));
            return copy.func_190916_E();
        }
        ItemIdentifier stackIdent = ItemIdentifier.get(stack);
        ItemIdentifier slotIdent = ItemIdentifier.get(slotStack);
        if (slotIdent.equals(stackIdent)) {
            slotStack.func_190920_e(slotStack.func_190916_E() + stack.func_190916_E());
            if (slotStack.func_190916_E() > realstacklimit) {
                int ans = stack.func_190916_E() - (slotStack.func_190916_E() - realstacklimit);
                slotStack.func_190920_e(realstacklimit);
                return ans;
            }
            return stack.func_190916_E();
        }
        return 0;
    }

    public int addCompressed(@Nonnull ItemStack stack, boolean ignoreMaxStackSize) {
        int added;
        int i;
        if (stack.func_190926_b()) {
            return 0;
        }
        stack = stack.func_77946_l();
        ItemIdentifier stackIdent = ItemIdentifier.get(stack);
        int stacklimit = this._stackLimit;
        if (!ignoreMaxStackSize) {
            stacklimit = Math.min(stacklimit, stackIdent.getMaxStackSize());
        }
        for (i = 0; i < this.stackList.size() && stack.func_190916_E() > 0; ++i) {
            if (((ItemStack)this.stackList.get(i)).func_190926_b()) continue;
            added = this.tryAddToSlot(i, stack, stacklimit);
            stack.func_190920_e(stack.func_190916_E() - added);
        }
        for (i = 0; i < this.stackList.size() && stack.func_190916_E() > 0; ++i) {
            added = this.tryAddToSlot(i, stack, stacklimit);
            stack.func_190920_e(stack.func_190916_E() - added);
        }
        this.func_70296_d();
        return stack.func_190916_E();
    }

    public boolean func_94041_b(int i, @Nonnull ItemStack itemstack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public void clearInventorySlotContents(int i) {
        this.stackList.set(i, (Object)ItemStack.field_190927_a);
    }

    public boolean func_145818_k_() {
        return true;
    }

    @Override
    @Nonnull
    public Iterator<Pair<ItemStack, Integer>> iterator() {
        final Iterator iter = this.stackList.iterator();
        return new Iterator<Pair<ItemStack, Integer>>(){
            int pos = -1;

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Pair<ItemStack, Integer> next() {
                ++this.pos;
                return new Pair<ItemStack, Integer>((ItemStack)iter.next(), this.pos);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

