/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.guidebook;

import java.io.IOException;
import logisticspipes.LogisticsPipes;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.utils.MinecraftColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import network.rs485.logisticspipes.gui.guidebook.Drawable;
import network.rs485.logisticspipes.gui.guidebook.GuiGuideBook;
import network.rs485.logisticspipes.util.math.Rectangle;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableImage;", "Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "imageResource", "Lnet/minecraft/util/ResourceLocation;", "(Lnet/minecraft/util/ResourceLocation;)V", "broken", "", "getBroken", "()Z", "imageSize", "Lnet/minecraft/client/renderer/texture/PngSizeInfo;", "draw", "", "mouseX", "", "mouseY", "delta", "", "visibleArea", "Lnetwork/rs485/logisticspipes/util/math/Rectangle;", "setPos", "x", "y", "logisticspipes"})
public final class DrawableImage
extends Drawable {
    private PngSizeInfo imageSize;
    private ResourceLocation imageResource;

    public final boolean getBroken() {
        return this.imageSize == null;
    }

    @Override
    public void draw(int mouseX, int mouseY, float delta, @NotNull Rectangle visibleArea) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        if (this.imageSize != null) {
            GuiGuideBook.Companion.drawImage(this.getAbsoluteBody(), visibleArea, this.imageResource);
        } else {
            GuiGuideBook.Companion.drawRectangleOutline(this.getAbsoluteBody(), (int)5.0, MinecraftColor.WHITE.getColorCode());
        }
    }

    @Override
    public int setPos(int x, int y) {
        if (this.imageSize != null) {
            Rectangle rectangle = this.getRelativeBody$logisticspipes();
            PngSizeInfo pngSizeInfo = this.imageSize;
            Intrinsics.checkNotNull(pngSizeInfo);
            int n = pngSizeInfo.field_188533_a;
            PngSizeInfo pngSizeInfo2 = this.imageSize;
            Intrinsics.checkNotNull(pngSizeInfo2);
            rectangle.setSize(n, pngSizeInfo2.field_188534_b);
            PngSizeInfo pngSizeInfo3 = this.imageSize;
            Intrinsics.checkNotNull(pngSizeInfo3);
            int n2 = pngSizeInfo3.field_188533_a;
            Drawable drawable = this.getParent();
            Intrinsics.checkNotNull(drawable);
            if (n2 > drawable.getWidth()) {
                Drawable drawable2 = this.getParent();
                Intrinsics.checkNotNull(drawable2);
                double downScaleFactor = (double)drawable2.getWidth() / (double)this.getWidth();
                this.getRelativeBody$logisticspipes().scale(downScaleFactor);
            }
        } else {
            this.getRelativeBody$logisticspipes().setSize(20, 20);
        }
        return super.setPos(x, y);
    }

    public DrawableImage(@NotNull ResourceLocation imageResource) {
        PngSizeInfo pngSizeInfo;
        DrawableImage drawableImage;
        Intrinsics.checkNotNullParameter(imageResource, "imageResource");
        this.imageResource = imageResource;
        DrawableImage drawableImage2 = this;
        try {
            drawableImage = drawableImage2;
            Minecraft minecraft = Minecraft.func_71410_x();
            Intrinsics.checkNotNullExpressionValue(minecraft, "Minecraft.getMinecraft()");
            IResource resource = minecraft.func_110442_L().func_110536_a(this.imageResource);
            pngSizeInfo = PngSizeInfo.func_188532_a((IResource)resource);
        }
        catch (IOException iOException) {
            drawableImage = drawableImage2;
            LogisticsPipes.log.error("File not found: " + this.imageResource.func_110623_a());
            pngSizeInfo = null;
        }
        drawableImage.imageSize = pngSizeInfo;
    }
}

