/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.guidebook;

import java.util.EnumSet;
import java.util.Set;
import logisticspipes.LPItems;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.utils.MinecraftColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import network.rs485.logisticspipes.gui.LPFontRenderer;
import network.rs485.logisticspipes.gui.guidebook.Drawable;
import network.rs485.logisticspipes.gui.guidebook.GuiGuideBook;
import network.rs485.logisticspipes.util.math.Rectangle;
import network.rs485.markdown.TextFormat;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rH\u0016J,\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\r2\n\u0010\u0016\u001a\u00060\u0017R\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableMenuListEntry;", "Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "linkedPage", "", "pageName", "icon", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "iconScale", "", "iconSize", "", "itemOffset", "itemRect", "Lnetwork/rs485/logisticspipes/util/math/Rectangle;", "draw", "", "mouseX", "mouseY", "delta", "", "visibleArea", "mouseClicked", "guideActionListener", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuiGuideBook$ActionListener;", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuiGuideBook;", "setPos", "x", "y", "logisticspipes"})
public final class DrawableMenuListEntry
extends Drawable {
    private final double iconScale;
    private final int iconSize;
    private final Rectangle itemRect;
    private final int itemOffset;
    private final String linkedPage;
    private final String pageName;
    private final String icon;

    @Override
    public void mouseClicked(int mouseX, int mouseY, @NotNull Rectangle visibleArea, @NotNull GuiGuideBook.ActionListener guideActionListener) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        Intrinsics.checkNotNullParameter(guideActionListener, "guideActionListener");
        guideActionListener.onMenuButtonClick(this.linkedPage);
    }

    @Override
    public void draw(int mouseX, int mouseY, float delta, @NotNull Rectangle visibleArea) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        boolean hovered = this.isHovering(mouseX, mouseY, visibleArea);
        GuiGuideBook.Companion.drawRectangleTile(this.getAbsoluteBody(), visibleArea, 4.0, true, hovered, MinecraftColor.WHITE.getColorCode());
        this.itemRect.setPos(this.getLeft() + this.itemOffset, this.getTop() + this.itemOffset);
        if (this.itemRect.intersects(visibleArea)) {
            int textColor = !hovered ? MinecraftColor.WHITE.getColorCode() : (int)0xFFFFFFA0L;
            int textVerticalOffset = (this.getHeight() - GuiGuideBook.Companion.getLpFontRenderer().getFontHeight(1.0)) / 2;
            LPFontRenderer lPFontRenderer = GuiGuideBook.Companion.getLpFontRenderer();
            int n = this.itemRect.getRight() + this.itemOffset;
            int n2 = this.getTop() + textVerticalOffset;
            EnumSet<Enum> enumSet = EnumSet.of((Enum)TextFormat.Shadow);
            Intrinsics.checkNotNullExpressionValue(enumSet, "EnumSet.of(TextFormat.Shadow)");
            lPFontRenderer.drawString(this.pageName, n, n2, textColor, (Set<? extends TextFormat>)enumSet, 1.0);
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(this.icon));
            if (item == null) {
                item = LPItems.blankModule;
            }
            Item item2 = item;
            RenderHelper.func_74520_c();
            Minecraft minecraft = Minecraft.func_71410_x();
            Intrinsics.checkNotNullExpressionValue(minecraft, "Minecraft.getMinecraft()");
            RenderItem renderItem = minecraft.func_175599_af();
            float prevZ = renderItem.field_77023_b;
            renderItem.field_77023_b = -145.0f;
            GlStateManager.func_179097_i();
            renderItem.func_180450_b(new ItemStack(item2), this.itemRect.getLeft(), this.itemRect.getTop());
            GlStateManager.func_179126_j();
            renderItem.field_77023_b = prevZ;
            RenderHelper.func_74518_a();
        }
        if (hovered) {
            GuiGuideBook.Companion.drawLinkIndicator(mouseX, mouseY);
        }
    }

    @Override
    public int setPos(int x, int y) {
        this.getRelativeBody$logisticspipes().setPos(x, y);
        this.itemRect.setPos(this.getLeft() + this.itemOffset, this.getTop() + this.itemOffset);
        return super.setPos(x, y);
    }

    public DrawableMenuListEntry(@NotNull String linkedPage, @NotNull String pageName, @NotNull String icon) {
        Intrinsics.checkNotNullParameter(linkedPage, "linkedPage");
        Intrinsics.checkNotNullParameter(pageName, "pageName");
        Intrinsics.checkNotNullParameter(icon, "icon");
        this.linkedPage = linkedPage;
        this.pageName = pageName;
        this.icon = icon;
        this.iconScale = 1.0;
        this.iconSize = (int)((double)16 * this.iconScale);
        this.itemRect = new Rectangle();
        this.itemOffset = (24 - this.iconSize) / 2;
        this.getRelativeBody$logisticspipes().setSize(4 * this.itemOffset + this.iconSize + GuiGuideBook.Companion.getLpFontRenderer().getStringWidth(this.pageName), 24);
        this.itemRect.setSize(this.iconSize, this.iconSize);
    }
}

