/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.guidebook;

import com.charleskorn.kaml.Yaml;
import com.charleskorn.kaml.YamlException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import logisticspipes.LogisticsPipes;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.collections.MapsKt;
import logisticspipes.kotlin.io.TextStreamsKt;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlin.text.Charsets;
import logisticspipes.kotlin.text.Regex;
import logisticspipes.kotlin.text.RegexOption;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import network.rs485.logisticspipes.guidebook.LoadedPage;
import network.rs485.logisticspipes.guidebook.PageInfoProvider;
import network.rs485.logisticspipes.guidebook.YamlPageMetadata;
import network.rs485.markdown.HeaderParagraph;
import network.rs485.markdown.ImageParagraph;
import network.rs485.markdown.MarkdownParser;
import network.rs485.markdown.Paragraph;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u001a\u0018\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002\u001a\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"MISSING_META", "Lnetwork/rs485/logisticspipes/guidebook/YamlPageMetadata;", "getMISSING_META", "()Lnetwork/rs485/logisticspipes/guidebook/YamlPageMetadata;", "metadataRegex", "Llogisticspipes/kotlin/text/Regex;", "loadPage", "Lnetwork/rs485/logisticspipes/guidebook/PageInfoProvider;", "path", "", "lang", "parseMetadata", "metadataString", "markdownFile", "resolveAbsoluteLocation", "resolvedLocation", "Ljava/nio/file/Path;", "language", "logisticspipes"})
public final class BookContentsKt {
    @NotNull
    private static final YamlPageMetadata MISSING_META = new YamlPageMetadata("[404] the metadata was not found :P", "logisticspipes:unrouted_pipe", null, 4, null);
    private static final Regex metadataRegex;

    @NotNull
    public static final YamlPageMetadata getMISSING_META() {
        return MISSING_META;
    }

    @NotNull
    public static final PageInfoProvider loadPage(@NotNull String path, @NotNull String lang) {
        PageInfoProvider pageInfoProvider;
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(lang, "lang");
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue(path2, "Paths.get(path)");
        String resolvedLocation = BookContentsKt.resolveAbsoluteLocation(path2, lang);
        try {
            IResource bookFile;
            Minecraft minecraft = Minecraft.func_71410_x();
            Intrinsics.checkNotNullExpressionValue(minecraft, "Minecraft.getMinecraft()");
            IResource iResource = bookFile = minecraft.func_110442_L().func_110536_a(new ResourceLocation("logisticspipes", resolvedLocation));
            Intrinsics.checkNotNullExpressionValue(iResource, "bookFile");
            InputStream inputStream = iResource.func_110527_b();
            Intrinsics.checkNotNullExpressionValue(inputStream, "bookFile.inputStream");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Closeable closeable = inputStream2;
            int n = 0;
            closeable = new InputStreamReader((InputStream)closeable, charset);
            n = 8192;
            boolean bl2 = false;
            pageInfoProvider = new LoadedPage(path, lang, CollectionsKt.joinToString$default(TextStreamsKt.readLines(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)), "\n", null, null, 0, null, null, 62, null));
        }
        catch (IOException error) {
            PageInfoProvider pageInfoProvider2;
            if (Intrinsics.areEqual(lang, "en_us") ^ true) {
                if (LogisticsPipes.isDEBUG()) {
                    LogisticsPipes.log.error("Language " + lang + " for the current file (" + resolvedLocation + ") was not found. Defaulting to en_us.");
                }
                pageInfoProvider2 = BookContentsKt.loadPage(path, "en_us");
            } else {
                String translatedError = MessageFormat.format(StringUtils.translate("misc.guide_book.missing_page"), resolvedLocation);
                pageInfoProvider2 = new PageInfoProvider(lang, translatedError){
                    private final boolean bookmarkable;
                    @NotNull
                    private final String language;
                    @NotNull
                    private final String fileLocation;
                    @NotNull
                    private final YamlPageMetadata metadata;
                    @NotNull
                    private final List<Paragraph> paragraphs;
                    final /* synthetic */ String $lang;
                    final /* synthetic */ String $translatedError;

                    public boolean getBookmarkable() {
                        return this.bookmarkable;
                    }

                    @NotNull
                    public String getLanguage() {
                        return this.language;
                    }

                    @NotNull
                    public String getFileLocation() {
                        return this.fileLocation;
                    }

                    @NotNull
                    public YamlPageMetadata getMetadata() {
                        return this.metadata;
                    }

                    @NotNull
                    public List<Paragraph> getParagraphs() {
                        return this.paragraphs;
                    }
                    {
                        this.$lang = $captured_local_variable$0;
                        this.$translatedError = $captured_local_variable$1;
                        this.language = $captured_local_variable$0;
                        this.fileLocation = "";
                        String string = StringUtils.translate("misc.guide_book.missing_page_title");
                        Intrinsics.checkNotNullExpressionValue(string, "StringUtils.translate(\"m\u2026book.missing_page_title\")");
                        this.metadata = new YamlPageMetadata(string, "logisticspipes:itemcard", MapsKt.emptyMap());
                        Paragraph[] paragraphArray = new Paragraph[2];
                        paragraphArray[0] = new ImageParagraph("Not found image not found?", "guide_book_404");
                        String string2 = $captured_local_variable$1;
                        Intrinsics.checkNotNullExpressionValue(string2, "translatedError");
                        paragraphArray[1] = new HeaderParagraph(MarkdownParser.INSTANCE.splitSpacesAndWords$logisticspipes(string2), 1);
                        this.paragraphs = CollectionsKt.listOf(paragraphArray);
                    }

                    @NotNull
                    public Path resolveLocation(@NotNull String location) {
                        Intrinsics.checkNotNullParameter(location, "location");
                        return PageInfoProvider.DefaultImpls.resolveLocation(this, location);
                    }

                    @NotNull
                    public String resolveAbsoluteLocation(@NotNull String location) {
                        Intrinsics.checkNotNullParameter(location, "location");
                        return PageInfoProvider.DefaultImpls.resolveAbsoluteLocation(this, location);
                    }

                    @NotNull
                    public ResourceLocation resolveResource(@NotNull String location) {
                        Intrinsics.checkNotNullParameter(location, "location");
                        return PageInfoProvider.DefaultImpls.resolveResource(this, location);
                    }
                };
            }
            pageInfoProvider = pageInfoProvider2;
        }
        return pageInfoProvider;
    }

    private static final YamlPageMetadata parseMetadata(String metadataString, String markdownFile) {
        Object object;
        Object object2 = metadataString;
        boolean bl = false;
        if (object2.length() > 0) {
            try {
                object2 = (YamlPageMetadata)Yaml.Companion.getDefault().decodeFromString(YamlPageMetadata.Companion.serializer(), metadataString);
            }
            catch (YamlException e) {
                LogisticsPipes.log.error("The following Yaml in " + markdownFile + " is malformed! \n" + metadataString, (Throwable)e);
                object2 = MISSING_META;
            }
            object = object2;
        } else {
            object = MISSING_META;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String resolveAbsoluteLocation(@NotNull Path resolvedLocation, @NotNull String language) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(resolvedLocation, "resolvedLocation");
        Intrinsics.checkNotNullParameter(language, "language");
        Path path = Paths.get("book/" + language, new String[0]);
        boolean bl = false;
        boolean bl2 = false;
        Path base = path;
        boolean bl3 = false;
        Path path2 = resolvedLocation.normalize();
        Intrinsics.checkNotNullExpressionValue(path2, "resolvedLocation.normalize()");
        Iterable $this$filter$iv = path2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path path3 = (Path)element$iv$iv;
            boolean bl4 = false;
            if (!(!path3.startsWith(".."))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$fold$iv = (List)destination$iv$iv;
        boolean $i$f$fold = false;
        Path accumulator$iv = base;
        for (Object element$iv : $this$fold$iv) {
            void p2;
            Path path4 = (Path)element$iv;
            Path p1 = accumulator$iv;
            boolean bl5 = false;
            accumulator$iv = p1.resolve((Path)p2);
        }
        return ((Object)accumulator$iv).toString();
    }

    static {
        String string = "^\\s*<!---\\s*\\n(.*?)\\n\\s*--->\\s*(.*)$";
        RegexOption regexOption = RegexOption.DOT_MATCHES_ALL;
        boolean bl = false;
        metadataRegex = new Regex(string, regexOption);
    }

    public static final /* synthetic */ Regex access$getMetadataRegex$p() {
        return metadataRegex;
    }

    public static final /* synthetic */ YamlPageMetadata access$parseMetadata(String metadataString, String markdownFile) {
        return BookContentsKt.parseMetadata(metadataString, markdownFile);
    }
}

