/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.util.math;

import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Pair;
import logisticspipes.kotlin.TuplesKt;
import logisticspipes.kotlin.jvm.internal.DefaultConstructorMarker;
import logisticspipes.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 G2\u00020\u0001:\u0001GB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006B/\b\u0012\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0002\u0010\nB)\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0004\u0012\b\b\u0002\u0010\f\u001a\u00020\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\rJ\u0016\u0010+\u001a\u00020,2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0000J7\u0010.\u001a\u00020,2*\u0010/\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\b00\"\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0002\u00101J7\u00102\u001a\u00020,2*\u0010/\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\b00\"\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0002\u00101J\u0016\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0004J\u000e\u00106\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0000J\u000e\u00107\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0000J\u000e\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020:J\u000e\u00108\u001a\u00020\u00002\u0006\u0010;\u001a\u00020<J\u001a\u0010=\u001a\u00020\u00002\b\b\u0002\u0010\u001e\u001a\u00020\u00042\b\b\u0002\u0010%\u001a\u00020\u0004J\u000e\u0010>\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0000J\u001a\u0010?\u001a\u00020\u00002\b\b\u0002\u0010\u001b\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u0004J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0000J\b\u0010A\u001a\u00020BH\u0016J\u0016\u0010C\u001a\u00020\u00002\u0006\u0010D\u001a\u00020\u00042\u0006\u0010E\u001a\u00020\u0004J\u0016\u0010F\u001a\u00020\u00002\u0006\u0010D\u001a\u00020\u00042\u0006\u0010E\u001a\u00020\u0004J\u000e\u0010F\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0000R\u0011\u0010\u000e\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0010\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\u0017\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010R\u0011\u0010\u0019\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010R$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0010\"\u0004\b\u001d\u0010\u0014R$\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0010\"\u0004\b!\u0010\u0014R\u001e\u0010#\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0010R$\u0010&\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0010\"\u0004\b(\u0010\u0014R\u001e\u0010)\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0010\u00a8\u0006H"}, d2={"Lnetwork/rs485/logisticspipes/util/math/Rectangle;", "", "()V", "width", "", "height", "(II)V", "firstPoint", "Llogisticspipes/kotlin/Pair;", "secondPoint", "(Lkotlin/Pair;Lkotlin/Pair;)V", "x", "y", "(IIII)V", "bottom", "getBottom", "()I", "newHeight", "getHeight", "setHeight", "(I)V", "left", "getLeft", "right", "getRight", "top", "getTop", "newWidth", "getWidth", "setWidth", "newX", "x0", "getX0", "setX0", "<set-?>", "x1", "getX1", "newY", "y0", "getY0", "setY0", "y1", "getY1", "contains", "", "rect", "containsAll", "coords", "", "([Lkotlin/Pair;)Z", "containsAny", "grow", "growX", "growY", "intersects", "overlap", "scale", "dMultiplier", "", "fMultiplier", "", "setPos", "setPosFromRectangle", "setSize", "setSizeFromRectangle", "toString", "", "translate", "translateX", "translateY", "translated", "Companion", "logisticspipes"})
public final class Rectangle {
    private int x0;
    private int y0;
    private int width;
    private int height;
    private int x1;
    private int y1;
    public static final Companion Companion = new Companion(null);

    public final int getX0() {
        return this.x0;
    }

    public final void setX0(int newX) {
        this.x0 = newX;
        this.x1 = newX + this.width;
    }

    public final int getY0() {
        return this.y0;
    }

    public final void setY0(int newY) {
        this.y0 = newY;
        this.y1 = newY + this.height;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int newWidth) {
        this.width = newWidth;
        this.x1 = this.x0 + newWidth;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int newHeight) {
        this.height = newHeight;
        this.y1 = this.y0 + newHeight;
    }

    public final int getX1() {
        return this.x1;
    }

    public final int getY1() {
        return this.y1;
    }

    public final int getLeft() {
        return this.x0;
    }

    public final int getRight() {
        return this.x1;
    }

    public final int getTop() {
        return this.y0;
    }

    public final int getBottom() {
        return this.y1;
    }

    @NotNull
    public final Rectangle setSize(int newWidth, int newHeight) {
        this.setWidth(newWidth);
        this.setHeight(newHeight);
        return this;
    }

    public static /* synthetic */ Rectangle setSize$default(Rectangle rectangle, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = rectangle.width;
        }
        if ((n3 & 2) != 0) {
            n2 = rectangle.height;
        }
        return rectangle.setSize(n, n2);
    }

    @NotNull
    public final Rectangle setSizeFromRectangle(@NotNull Rectangle rect) {
        Intrinsics.checkNotNullParameter(rect, "rect");
        this.setSize(rect.width, rect.height);
        return this;
    }

    @NotNull
    public final Rectangle setPos(int newX, int newY) {
        this.setX0(newX);
        this.setY0(newY);
        return this;
    }

    public static /* synthetic */ Rectangle setPos$default(Rectangle rectangle, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = rectangle.x0;
        }
        if ((n3 & 2) != 0) {
            n2 = rectangle.y0;
        }
        return rectangle.setPos(n, n2);
    }

    @NotNull
    public final Rectangle setPosFromRectangle(@NotNull Rectangle rect) {
        Intrinsics.checkNotNullParameter(rect, "rect");
        this.setPos(rect.x0, rect.y0);
        return this;
    }

    @NotNull
    public final Rectangle scale(float fMultiplier) {
        return this.scale((double)fMultiplier);
    }

    @NotNull
    public final Rectangle scale(double dMultiplier) {
        double d = dMultiplier * (double)this.width;
        boolean bl = false;
        this.setWidth((int)Math.ceil(d));
        d = dMultiplier * (double)this.height;
        bl = false;
        this.setHeight((int)Math.ceil(d));
        return this;
    }

    @NotNull
    public final Rectangle grow(int growX, int growY) {
        Rectangle rectangle = this;
        rectangle.setWidth(rectangle.width + growX);
        Rectangle rectangle2 = this;
        rectangle2.setHeight(rectangle2.height + growY);
        return this;
    }

    @NotNull
    public final Rectangle translate(int translateX, int translateY) {
        Rectangle rectangle = this;
        rectangle.setX0(rectangle.x0 + translateX);
        Rectangle rectangle2 = this;
        rectangle2.setY0(rectangle2.y0 + translateY);
        return this;
    }

    @NotNull
    public final Rectangle translated(int translateX, int translateY) {
        return Companion.fromRectangle(this).translate(translateX, translateY);
    }

    @NotNull
    public final Rectangle translated(@NotNull Rectangle rect) {
        Intrinsics.checkNotNullParameter(rect, "rect");
        return Companion.fromRectangle(this).translate(rect.x0, rect.y0);
    }

    public final boolean contains(int x, int y) {
        int n = x;
        return this.x0 <= n && this.x1 >= n && this.y0 <= (n = y) && this.y1 >= n;
    }

    public final boolean containsAny(Pair<Integer, Integer> ... coords) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter(coords, "coords");
            Pair<Integer, Integer>[] $this$any$iv = coords;
            boolean $i$f$any = false;
            Pair<Integer, Integer>[] pairArray = $this$any$iv;
            int n = pairArray.length;
            for (int i = 0; i < n; ++i) {
                Pair<Integer, Integer> element$iv;
                Pair<Integer, Integer> it = element$iv = pairArray[i];
                boolean bl2 = false;
                if (!this.contains(((Number)it.getFirst()).intValue(), ((Number)it.getSecond()).intValue())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public final boolean containsAll(Pair<Integer, Integer> ... coords) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter(coords, "coords");
            Pair<Integer, Integer>[] $this$all$iv = coords;
            boolean $i$f$all = false;
            Pair<Integer, Integer>[] pairArray = $this$all$iv;
            int n = pairArray.length;
            for (int i = 0; i < n; ++i) {
                Pair<Integer, Integer> element$iv;
                Pair<Integer, Integer> it = element$iv = pairArray[i];
                boolean bl2 = false;
                if (this.contains(((Number)it.getFirst()).intValue(), ((Number)it.getSecond()).intValue())) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    public final boolean contains(@NotNull Rectangle rect) {
        Intrinsics.checkNotNullParameter(rect, "rect");
        return this.contains(rect.x0, rect.y0) && this.contains(rect.x1, rect.y1);
    }

    public final boolean intersects(@NotNull Rectangle rect) {
        Intrinsics.checkNotNullParameter(rect, "rect");
        return this.getRight() >= rect.getLeft() && rect.getRight() >= this.getLeft() && this.getBottom() >= rect.getTop() && rect.getBottom() >= this.getTop();
    }

    @NotNull
    public final Rectangle overlap(@NotNull Rectangle rect) {
        Intrinsics.checkNotNullParameter(rect, "rect");
        return new Rectangle(TuplesKt.to(Integer.max(this.x0, rect.x0), Integer.max(this.y0, rect.y0)), TuplesKt.to(Integer.min(this.x1, rect.x1), Integer.min(this.y1, rect.y1)));
    }

    @NotNull
    public String toString() {
        return "Rectangle(x = " + this.x0 + ", y = " + this.y0 + ", width = " + this.width + ", height = " + this.height + ')';
    }

    public Rectangle(int x, int y, int width, int height) {
        this.x0 = x;
        this.y0 = y;
        this.width = width;
        this.height = height;
        this.x1 = this.x0 + width;
        this.y1 = this.y0 + height;
    }

    public /* synthetic */ Rectangle(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 1) != 0) {
            n = 0;
        }
        if ((n5 & 2) != 0) {
            n2 = 0;
        }
        this(n, n2, n3, n4);
    }

    public Rectangle() {
        this(0, 0, 0, 0);
    }

    public Rectangle(int width, int height) {
        this(0, 0, width, height);
    }

    private Rectangle(Pair<Integer, Integer> firstPoint, Pair<Integer, Integer> secondPoint) {
        this(((Number)firstPoint.getFirst()).intValue(), ((Number)firstPoint.getSecond()).intValue(), ((Number)secondPoint.getFirst()).intValue() - ((Number)firstPoint.getFirst()).intValue(), ((Number)secondPoint.getSecond()).intValue() - ((Number)firstPoint.getSecond()).intValue());
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lnetwork/rs485/logisticspipes/util/math/Rectangle$Companion;", "", "()V", "fromRectangle", "Lnetwork/rs485/logisticspipes/util/math/Rectangle;", "rect", "logisticspipes"})
    public static final class Companion {
        @NotNull
        public final Rectangle fromRectangle(@NotNull Rectangle rect) {
            Intrinsics.checkNotNullParameter(rect, "rect");
            return new Rectangle(rect.getX0(), rect.getY0(), rect.getWidth(), rect.getHeight());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

