/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.markdown;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Lazy;
import logisticspipes.kotlin.LazyKt;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Pair;
import logisticspipes.kotlin.Triple;
import logisticspipes.kotlin.TuplesKt;
import logisticspipes.kotlin.Unit;
import logisticspipes.kotlin._Assertions;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.collections.IntIterator;
import logisticspipes.kotlin.comparisons.ComparisonsKt;
import logisticspipes.kotlin.jvm.functions.Function0;
import logisticspipes.kotlin.jvm.functions.Function1;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlin.jvm.internal.Ref;
import logisticspipes.kotlin.ranges.IntRange;
import logisticspipes.kotlin.ranges.RangesKt;
import logisticspipes.kotlin.sequences.Sequence;
import logisticspipes.kotlin.sequences.SequencesKt;
import logisticspipes.kotlin.text.CharsKt;
import logisticspipes.kotlin.text.Charsets;
import logisticspipes.kotlin.text.MatchGroup;
import logisticspipes.kotlin.text.MatchGroupCollection;
import logisticspipes.kotlin.text.MatchResult;
import logisticspipes.kotlin.text.Regex;
import logisticspipes.kotlin.text.RegexOption;
import logisticspipes.kotlin.text.StringsKt;
import network.rs485.markdown.Break;
import network.rs485.markdown.HeaderParagraph;
import network.rs485.markdown.HorizontalLineParagraph;
import network.rs485.markdown.ImageParagraph;
import network.rs485.markdown.InlineElement;
import network.rs485.markdown.Link;
import network.rs485.markdown.LinkFormatting;
import network.rs485.markdown.MarkdownParser;
import network.rs485.markdown.MenuParagraph;
import network.rs485.markdown.MenuParagraphType;
import network.rs485.markdown.PageLink;
import network.rs485.markdown.Paragraph;
import network.rs485.markdown.RegularParagraph;
import network.rs485.markdown.Space;
import network.rs485.markdown.TextFormat;
import network.rs485.markdown.TextFormatting;
import network.rs485.markdown.WebLink;
import network.rs485.markdown.Word;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002,-B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\u000e\u001a\u00020\r2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002J,\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\b\b\u0002\u0010\u0016\u001a\u00020\u00062\b\b\u0002\u0010\u0017\u001a\u00020\u0006H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00042\u0006\u0010\u0015\u001a\u00020\rJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\rH\u0002J\u001b\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\"J4\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u001c\u0010#\u001a\u0018\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00040$j\u0002`%H\u0002J\u001b\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b'J0\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u001f0$j\u0002`)H\u0002J\u001b\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b+R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lnetwork/rs485/markdown/MarkdownParser;", "", "()V", "boldItalicRegexes", "", "Llogisticspipes/kotlin/Pair;", "", "Llogisticspipes/kotlin/text/Regex;", "htmlBreakRegex", "linkRegex", "pathRegex", "webLinkRegex", "bufferOrReturnLine", "", "line", "buffer", "Ljava/lang/StringBuilder;", "Llogisticspipes/kotlin/text/StringBuilder;", "countChars", "char", "", "str", "index", "maximum", "parseLinks", "Lnetwork/rs485/markdown/InlineElement;", "inputChars", "", "parseParagraphs", "Lnetwork/rs485/markdown/Paragraph;", "parseTextElement", "Lnetwork/rs485/markdown/Word;", "word", "splitAndFormatWords", "splitAndFormatWords$logisticspipes", "wordSplitter", "Llogisticspipes/kotlin/Function1;", "Lnetwork/rs485/markdown/TextToElements;", "splitSpacesAndWords", "splitSpacesAndWords$logisticspipes", "makeWord", "Lnetwork/rs485/markdown/WordCreator;", "splitWhitespaceCharactersAndWords", "splitWhitespaceCharactersAndWords$logisticspipes", "LinkMatcher", "ReplacedCharSequence", "logisticspipes"})
public final class MarkdownParser {
    private static final Regex linkRegex;
    private static final Regex webLinkRegex;
    private static final List<Pair<Integer, Regex>> boldItalicRegexes;
    private static final Regex pathRegex;
    private static final Regex htmlBreakRegex;
    public static final MarkdownParser INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<InlineElement> splitWhitespaceCharactersAndWords$logisticspipes(@NotNull CharSequence inputChars) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(inputChars, "inputChars");
        String chars = htmlBreakRegex.replace(inputChars, "\n");
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)chars, new char[]{'\n'}, false, 0, 6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void words;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List list = CollectionsKt.plus((Collection)INSTANCE.splitAndFormatWords$logisticspipes((CharSequence)words), (Iterable)CollectionsKt.listOf(Break.INSTANCE));
            collection.add(list);
        }
        return CollectionsKt.dropLast(CollectionsKt.flatten((List)destination$iv$iv), 1);
    }

    /*
     * WARNING - void declaration
     */
    private final List<InlineElement> splitAndFormatWords(CharSequence inputChars, Function1<? super CharSequence, ? extends List<? extends InlineElement>> wordSplitter) {
        void startIdx;
        CharSequence textLine = StringsKt.trimEnd(inputChars);
        ReplacedCharSequence replacingChars = new ReplacedCharSequence(textLine);
        Iterable $this$forEach$iv = boldItalicRegexes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EnumSet<Enum> enumSet;
            void level;
            Pair $dstr$level$regex = (Pair)element$iv;
            boolean bl = false;
            int n = ((Number)$dstr$level$regex.component1()).intValue();
            Regex regex = (Regex)$dstr$level$regex.component2();
            switch (level) {
                case 3: {
                    enumSet = EnumSet.of((Enum)TextFormat.Italic, (Enum)TextFormat.Bold);
                    break;
                }
                case 2: {
                    enumSet = EnumSet.of((Enum)TextFormat.Bold);
                    break;
                }
                case 1: {
                    enumSet = EnumSet.of((Enum)TextFormat.Italic);
                    break;
                }
                default: {
                    enumSet = TextFormat.Companion.getNone();
                }
            }
            EnumSet<Enum> format = enumSet;
            Sequence $this$forEach$iv2 = Regex.findAll$default(regex, replacingChars, 0, 2, null);
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                MatchGroup textGroup;
                Object element$iv2 = iterator2.next();
                MatchResult match = (MatchResult)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull(match.getGroups().get(1));
                IntRange intRange = match.getRange();
                IntRange intRange2 = textGroup.getRange();
                EnumSet<Enum> enumSet2 = format;
                Intrinsics.checkNotNullExpressionValue(enumSet2, "format");
                replacingChars.addReplacement(intRange, intRange2, enumSet2);
            }
            replacingChars.commit();
        }
        $i$f$forEach = false;
        ArrayList mappedWords = new ArrayList();
        Function1<IntRange, Unit> $fun$addMappedWords$2 = new Function1<IntRange, Unit>(mappedWords, wordSplitter, textLine){
            final /* synthetic */ ArrayList $mappedWords;
            final /* synthetic */ Function1 $wordSplitter;
            final /* synthetic */ CharSequence $textLine;

            public final void invoke(@NotNull IntRange originalRange) {
                Intrinsics.checkNotNullParameter(originalRange, "originalRange");
                if (originalRange.isEmpty()) {
                    return;
                }
                this.$mappedWords.addAll((Collection)this.$wordSplitter.invoke(StringsKt.subSequence(this.$textLine, originalRange)));
            }
            {
                this.$mappedWords = arrayList;
                this.$wordSplitter = function1;
                this.$textLine = charSequence;
                super(1);
            }
        };
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        replacingChars.forEachReplace((Function1<? super Pair<IntRange, ? extends InlineElement>, Unit>)new Function1<Pair<? extends IntRange, ? extends InlineElement>, Unit>($fun$addMappedWords$2, (Ref.IntRef)startIdx, mappedWords){
            final /* synthetic */ splitAndFormatWords.2 $addMappedWords$2;
            final /* synthetic */ Ref.IntRef $startIdx;
            final /* synthetic */ ArrayList $mappedWords;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Pair<IntRange, ? extends InlineElement> $dstr$range$inlineElem) {
                void range;
                Intrinsics.checkNotNullParameter($dstr$range$inlineElem, "<name for destructuring parameter 0>");
                IntRange intRange = $dstr$range$inlineElem.component1();
                InlineElement inlineElem = $dstr$range$inlineElem.component2();
                this.$addMappedWords$2.invoke(RangesKt.until(this.$startIdx.element, range.getFirst()));
                this.$mappedWords.add(inlineElem);
                this.$startIdx.element = range.getLast() + 1;
            }
            {
                this.$addMappedWords$2 = var1_1;
                this.$startIdx = intRef;
                this.$mappedWords = arrayList;
                super(1);
            }
        });
        int n = startIdx.element;
        $fun$addMappedWords$2.invoke(new IntRange(n, StringsKt.getLastIndex(replacingChars.getOriginal())));
        return mappedWords;
    }

    @NotNull
    public final List<InlineElement> splitAndFormatWords$logisticspipes(@NotNull CharSequence inputChars) {
        Intrinsics.checkNotNullParameter(inputChars, "inputChars");
        return this.splitAndFormatWords(inputChars, (Function1<? super CharSequence, ? extends List<? extends InlineElement>>)new Function1<CharSequence, List<? extends InlineElement>>(this){

            @NotNull
            public final List<InlineElement> invoke(@NotNull CharSequence p1) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                return ((MarkdownParser)this.receiver).splitSpacesAndWords$logisticspipes(p1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List<InlineElement> splitSpacesAndWords(CharSequence inputChars, Function1<? super String, Word> makeWord) {
        List list;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = StringsKt.split$default(inputChars, new char[]{' '}, false, 0, 6, null);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String word = (String)element$iv$iv;
            boolean bl = false;
            list$iv$iv = CollectionsKt.listOfNotNull(makeWord.invoke(word));
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        Iterable $this$zipWithNext$iv = CollectionsKt.plus((Collection)((List)destination$iv$iv2), Space.INSTANCE);
        boolean $i$f$zipWithNext = false;
        Iterator iterator$iv = $this$zipWithNext$iv.iterator();
        if (!iterator$iv.hasNext()) {
            list = CollectionsKt.emptyList();
        } else {
            boolean destination$iv$iv2 = false;
            List result$iv = new ArrayList();
            Object current$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void right;
                void left;
                Object element$iv$iv;
                Object next$iv = iterator$iv.next();
                element$iv$iv = (InlineElement)next$iv;
                list$iv$iv = (InlineElement)current$iv;
                List list2 = result$iv;
                boolean bl = false;
                List<void> list3 = left instanceof Word && right instanceof Word ? CollectionsKt.listOf(left, Space.INSTANCE) : CollectionsKt.listOf(left);
                list2.add(list3);
                current$iv = next$iv;
            }
            list = result$iv;
        }
        return CollectionsKt.flatten(list);
    }

    @NotNull
    public final List<InlineElement> splitSpacesAndWords$logisticspipes(@NotNull CharSequence inputChars) {
        Intrinsics.checkNotNullParameter(inputChars, "inputChars");
        return this.splitSpacesAndWords(inputChars, (Function1<? super String, Word>)new Function1<String, Word>(this){

            @Nullable
            public final Word invoke(@NotNull String p1) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                return MarkdownParser.access$parseTextElement((MarkdownParser)this.receiver, p1);
            }
        });
    }

    private final Word parseTextElement(String word) {
        CharSequence charSequence = word;
        boolean bl = false;
        return !StringsKt.isBlank(charSequence) ? new Word(word) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<InlineElement> parseLinks(CharSequence inputChars) {
        void lastCharLookedAt;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        Function0 postfixGetter2 = new Function0<CharSequence>((Ref.IntRef)lastCharLookedAt, inputChars){
            final /* synthetic */ Ref.IntRef $lastCharLookedAt;
            final /* synthetic */ CharSequence $inputChars;

            @NotNull
            public final CharSequence invoke() {
                return this.$lastCharLookedAt.element < this.$inputChars.length() ? this.$inputChars.subSequence(this.$lastCharLookedAt.element, this.$inputChars.length()) : (CharSequence)"";
            }
            {
                this.$lastCharLookedAt = intRef;
                this.$inputChars = charSequence;
                super(0);
            }
        };
        Function0 isLastWhitespace2 = new Function0<Boolean>(inputChars, (Ref.IntRef)lastCharLookedAt){
            final /* synthetic */ CharSequence $inputChars;
            final /* synthetic */ Ref.IntRef $lastCharLookedAt;

            public final boolean invoke() {
                int n = this.$lastCharLookedAt.element;
                return 1 <= n && this.$inputChars.length() > n && CharsKt.isWhitespace(this.$inputChars.charAt(this.$lastCharLookedAt.element));
            }
            {
                this.$inputChars = charSequence;
                this.$lastCharLookedAt = intRef;
                super(0);
            }
        };
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)SequencesKt.toList(SequencesKt.flatMapIterable(SequencesKt.map(Regex.findAll$default(linkRegex, inputChars, 0, 2, null), parseLinks.1.INSTANCE), (Function1)new Function1<LinkMatcher, List<? extends InlineElement>>(inputChars, (Ref.IntRef)lastCharLookedAt, isLastWhitespace2){
            final /* synthetic */ CharSequence $inputChars;
            final /* synthetic */ Ref.IntRef $lastCharLookedAt;
            final /* synthetic */ Function0 $isLastWhitespace;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<InlineElement> invoke(@NotNull LinkMatcher link) {
                List<T> list;
                List[] listArray;
                List<InlineElement> it;
                boolean bl;
                boolean bl2;
                List<InlineElement> list2;
                block8: {
                    block7: {
                        void linkRef;
                        List[] listArray2;
                        Object object;
                        List<T> list3;
                        List[] listArray3;
                        Intrinsics.checkNotNullParameter(link, "link");
                        CharSequence before = this.$inputChars.subSequence(this.$lastCharLookedAt.element, link.getMatch().getRange().getFirst());
                        list2 = MarkdownParser.INSTANCE.splitWhitespaceCharactersAndWords$logisticspipes(before);
                        bl2 = false;
                        bl = false;
                        List<InlineElement> list4 = list2;
                        int n = 0;
                        List[] listArray4 = listArray3 = new List[2];
                        boolean bl3 = false;
                        listArray3[n] = list3 = (Boolean)this.$isLastWhitespace.invoke() == false && it.isEmpty() ? CollectionsKt.emptyList() : CollectionsKt.plus((Collection)it, (Iterable)CollectionsKt.listOf(Space.INSTANCE));
                        List[] listArray5 = listArray4;
                        listArray = listArray4;
                        int n2 = 1;
                        if (link.isPageLink()) {
                            String string = link.getPath();
                            Intrinsics.checkNotNull(string);
                            object = new PageLink(string);
                        } else if (link.isWebLink()) {
                            String string = link.getLink();
                            Intrinsics.checkNotNull(string);
                            object = new WebLink(string);
                        } else {
                            object = list = null;
                        }
                        if (object == null) break block7;
                        list2 = list;
                        bl2 = false;
                        bl = false;
                        it = list2;
                        n = n2;
                        listArray3 = listArray5;
                        listArray4 = listArray;
                        boolean bl4 = false;
                        Word word = new Word("!");
                        boolean bl5 = false;
                        boolean bl6 = false;
                        Word word2 = word;
                        int n3 = 0;
                        List[] listArray6 = listArray2 = new List[4];
                        boolean bl7 = false;
                        boolean bl8 = link.getImageLinkFlag();
                        listArray2[n3] = CollectionsKt.listOfNotNull(bl8 ? word : null);
                        List[] listArray7 = listArray6;
                        listArray6[1] = CollectionsKt.listOf(new LinkFormatting((Link)linkRef));
                        String string = link.getText();
                        Intrinsics.checkNotNull(string);
                        listArray7[2] = MarkdownParser.INSTANCE.splitAndFormatWords$logisticspipes(string);
                        listArray7[3] = CollectionsKt.listOf(new LinkFormatting(null));
                        list3 = CollectionsKt.flatten((Iterable)CollectionsKt.listOf(listArray7));
                        listArray = listArray4;
                        listArray5 = listArray3;
                        n2 = n;
                        list = list3;
                        if (list != null) break block8;
                    }
                    list = MarkdownParser.INSTANCE.splitWhitespaceCharactersAndWords$logisticspipes(link.getMatch().getValue());
                }
                listArray5[n2] = list;
                list2 = CollectionsKt.flatten((Iterable)CollectionsKt.listOf(listArray));
                bl2 = false;
                bl = false;
                it = list2;
                boolean bl9 = false;
                this.$lastCharLookedAt.element = link.getMatch().getRange().getLast() + 1;
                return list2;
            }
            {
                this.$inputChars = charSequence;
                this.$lastCharLookedAt = intRef;
                this.$isLastWhitespace = function0;
                super(1);
            }
        })), (Iterable)((Boolean)isLastWhitespace2.invoke() != false ? CollectionsKt.listOf(Space.INSTANCE) : CollectionsKt.emptyList())), (Iterable)this.splitWhitespaceCharactersAndWords$logisticspipes((CharSequence)postfixGetter2.invoke()));
    }

    private final int countChars(char c, String str, int index, int maximum) {
        int count2;
        if (str.charAt(index) != c) {
            return 0;
        }
        int actualMax = Integer.min(str.length() - index, maximum);
        for (count2 = 1; count2 < actualMax && str.charAt(index + count2) == c; ++count2) {
        }
        return count2;
    }

    static /* synthetic */ int countChars$default(MarkdownParser markdownParser, char c, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = string.length();
        }
        return markdownParser.countChars(c, string, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Paragraph> parseParagraphs(@NotNull String str) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(str, "str");
        ArrayList<Paragraph> paragraphs2 = new ArrayList<Paragraph>();
        StringBuilder sb = new StringBuilder();
        List lines = StringsKt.split$default((CharSequence)str, new char[]{'\n'}, false, 0, 6, null);
        Function0<Unit> $fun$completeParagraph$1 = new Function0<Unit>(sb, paragraphs2){
            final /* synthetic */ StringBuilder $sb;
            final /* synthetic */ ArrayList $paragraphs;

            public final void invoke() {
                CharSequence charSequence = this.$sb;
                boolean bl = false;
                if (!StringsKt.isBlank(charSequence)) {
                    this.$paragraphs.add(new RegularParagraph(MarkdownParser.access$parseLinks(MarkdownParser.INSTANCE, this.$sb)));
                }
                StringsKt.clear(this.$sb);
            }
            {
                this.$sb = stringBuilder;
                this.$paragraphs = arrayList;
                super(0);
            }
        };
        Iterable $this$flatMap$iv = lines;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String line = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = INSTANCE.bufferOrReturnLine(line, sb);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object it;
            Object element$iv$iv;
            String dirtyLine = (String)element$iv;
            boolean bl = false;
            element$iv$iv = dirtyLine;
            boolean list$iv$iv = false;
            Object object = element$iv$iv;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String line = ((Object)StringsKt.trimStart((CharSequence)object)).toString();
            Function0<Unit> $fun$dumpLineToBuffer$1 = new Function0<Unit>(line, sb, $fun$completeParagraph$1, paragraphs2){
                final /* synthetic */ String $line;
                final /* synthetic */ StringBuilder $sb$inlined;
                final /* synthetic */ parseParagraphs.1 $completeParagraph$1$inlined;
                final /* synthetic */ ArrayList $paragraphs$inlined;
                {
                    this.$line = string;
                    this.$sb$inlined = stringBuilder;
                    this.$completeParagraph$1$inlined = var3_3;
                    this.$paragraphs$inlined = arrayList;
                    super(0);
                }

                public final void invoke() {
                    CharSequence charSequence = this.$sb$inlined;
                    boolean bl = false;
                    if (charSequence.length() > 0) {
                        this.$sb$inlined.append(' ');
                    }
                    this.$sb$inlined.append(this.$line);
                }
            };
            Object var15_19 = null;
            Lazy lineLinkMatch2 = LazyKt.lazy((Function0)new Function0<LinkMatcher>(line){
                final /* synthetic */ String $line;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final LinkMatcher invoke() {
                    MatchResult matchResult = Regex.find$default(MarkdownParser.access$getLinkRegex$p(MarkdownParser.INSTANCE), this.$line, 0, 2, null);
                    MatchResult matchResult2 = matchResult;
                    if (matchResult == null) return null;
                    MatchResult matchResult3 = matchResult2;
                    boolean bl = false;
                    boolean bl2 = false;
                    MatchResult it = matchResult3;
                    boolean bl3 = false;
                    String string = this.$line;
                    boolean bl4 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    if (!Intrinsics.areEqual(it.getValue(), ((Object)StringsKt.trimEnd((CharSequence)string2)).toString())) return null;
                    MatchResult matchResult4 = matchResult3;
                    matchResult2 = matchResult4;
                    if (matchResult4 == null) return null;
                    matchResult3 = matchResult2;
                    bl = false;
                    bl2 = false;
                    it = matchResult3;
                    boolean bl5 = false;
                    LinkMatcher linkMatcher = new LinkMatcher(it);
                    return linkMatcher;
                }
                {
                    this.$line = string;
                    super(0);
                }
            });
            Object object2 = line;
            boolean bl2 = false;
            if (object2.length() == 0) {
                $fun$completeParagraph$1.invoke();
                continue;
            }
            if (StringsKt.startsWith$default((CharSequence)line, '#', false, 2, null)) {
                int charCount = MarkdownParser.countChars$default(INSTANCE, '#', line, 0, 6, 4, null);
                String text = StringsKt.trimStart(line, '#');
                if (StringsKt.isBlank(text)) {
                    $fun$dumpLineToBuffer$1.invoke();
                    continue;
                }
                if (text.charAt(0) == ' ') {
                    $fun$completeParagraph$1.invoke();
                    paragraphs2.add(new HeaderParagraph(INSTANCE.parseLinks(StringsKt.trimEnd(text, '#')), charCount));
                    continue;
                }
                $fun$dumpLineToBuffer$1.invoke();
                continue;
            }
            if (StringsKt.startsWith$default(line, "===", false, 2, null)) {
                Paragraph paragraph;
                if (StringsKt.isBlank(sb)) {
                    paragraph = HorizontalLineParagraph.INSTANCE;
                } else {
                    String string = sb.toString();
                    Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
                    paragraph = new HeaderParagraph(INSTANCE.parseLinks(string), 1);
                }
                paragraphs2.add(paragraph);
                StringsKt.clear(sb);
                continue;
            }
            if (StringsKt.startsWith$default(line, "---", false, 2, null)) {
                Paragraph paragraph;
                if (StringsKt.isBlank(sb)) {
                    paragraph = HorizontalLineParagraph.INSTANCE;
                } else {
                    String string = sb.toString();
                    Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
                    paragraph = new HeaderParagraph(INSTANCE.parseLinks(string), 2);
                }
                paragraphs2.add(paragraph);
                StringsKt.clear(sb);
                continue;
            }
            object2 = lineLinkMatch2;
            Object var17_24 = null;
            boolean bl3 = false;
            LinkMatcher linkMatcher = (LinkMatcher)object2.getValue();
            if ((linkMatcher != null ? linkMatcher.getMenuType() : null) != null) {
                object2 = lineLinkMatch2;
                var17_24 = null;
                bl3 = false;
                LinkMatcher linkMatcher2 = (LinkMatcher)object2.getValue();
                Intrinsics.checkNotNull(linkMatcher2);
                if (!linkMatcher2.getImageLinkFlag()) {
                    object2 = lineLinkMatch2;
                    var17_24 = null;
                    bl3 = false;
                    LinkMatcher linkMatcher3 = (LinkMatcher)object2.getValue();
                    if (linkMatcher3 != null) {
                        object2 = linkMatcher3;
                        boolean bl4 = false;
                        bl3 = false;
                        it = object2;
                        boolean bl5 = false;
                        $fun$completeParagraph$1.invoke();
                        String string = ((LinkMatcher)it).getText();
                        Intrinsics.checkNotNull(string);
                        String string2 = ((LinkMatcher)it).getPath();
                        Intrinsics.checkNotNull(string2);
                        MenuParagraphType menuParagraphType = ((LinkMatcher)it).getMenuType();
                        Intrinsics.checkNotNull((Object)menuParagraphType);
                        paragraphs2.add(new MenuParagraph(string, string2, menuParagraphType));
                    }
                    continue;
                }
            }
            object2 = lineLinkMatch2;
            var17_24 = null;
            bl3 = false;
            LinkMatcher linkMatcher4 = (LinkMatcher)object2.getValue();
            if (linkMatcher4 != null) {
                if (linkMatcher4.isImageLink()) {
                    object2 = lineLinkMatch2;
                    var17_24 = null;
                    bl3 = false;
                    LinkMatcher linkMatcher5 = (LinkMatcher)object2.getValue();
                    Intrinsics.checkNotNull(linkMatcher5);
                    if (linkMatcher5.getImageLinkFlag()) {
                        object2 = lineLinkMatch2;
                        var17_24 = null;
                        bl3 = false;
                        LinkMatcher linkMatcher6 = (LinkMatcher)object2.getValue();
                        if (linkMatcher6 != null) {
                            object2 = linkMatcher6;
                            boolean bl6 = false;
                            bl3 = false;
                            it = object2;
                            boolean bl7 = false;
                            $fun$completeParagraph$1.invoke();
                            String string = ((LinkMatcher)it).getText();
                            Intrinsics.checkNotNull(string);
                            String string3 = ((LinkMatcher)it).getPath();
                            Intrinsics.checkNotNull(string3);
                            paragraphs2.add(new ImageParagraph(string, string3));
                        }
                        continue;
                    }
                }
            }
            $fun$dumpLineToBuffer$1.invoke();
        }
        $fun$completeParagraph$1.invoke();
        return paragraphs2;
    }

    private final List<String> bufferOrReturnLine(String line, StringBuilder buffer) {
        if (StringsKt.endsWith$default((CharSequence)line, '\\', false, 2, null)) {
            String string = line;
            int n = 0;
            int n2 = line.length() - 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            buffer.append(string3);
            return CollectionsKt.emptyList();
        }
        if (StringsKt.endsWith$default(line, "  ", false, 2, null)) {
            String string = line;
            int n = 0;
            int n3 = line.length() - 2;
            boolean bl = false;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, n3);
            Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            buffer.append(string5);
            buffer.append('\n');
        } else {
            buffer.append(line);
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue(string, "buffer.toString()");
        String concatLine = string;
        StringsKt.clear(buffer);
        return CollectionsKt.listOf(concatLine);
    }

    private MarkdownParser() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        MarkdownParser markdownParser;
        INSTANCE = markdownParser = new MarkdownParser();
        linkRegex = new Regex("!?\\[(.+?)]\\((.+?)\\)");
        webLinkRegex = new Regex("^https?://.+", RegexOption.IGNORE_CASE);
        Iterable $this$flatMap$iv = RangesKt.downTo(3, 1);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv2;
            int element$iv$iv;
            int times = element$iv$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            Iterable $this$map$iv2 = CollectionsKt.listOf("_", "\\*");
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                Pair<Integer, String> pair = TuplesKt.to(times, StringsKt.repeat((CharSequence)it, times));
                collection.add(pair);
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void times;
            void $dstr$times$formatChain;
            list$iv$iv = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int $this$map$iv2 = ((Number)$dstr$times$formatChain.component1()).intValue();
            String formatChain = (String)$dstr$times$formatChain.component2();
            Pair<Integer, Regex> pair = TuplesKt.to((int)times, new Regex("(?!\\\\)" + formatChain + "(.+?)(?!\\\\)" + formatChain));
            collection.add(pair);
        }
        boldItalicRegexes = (List)destination$iv$iv;
        pathRegex = new Regex("^.*?://([^?]+)");
        htmlBreakRegex = new Regex("<br(\\s*/)?>");
    }

    public static final /* synthetic */ Regex access$getPathRegex$p(MarkdownParser $this) {
        MarkdownParser markdownParser = $this;
        return pathRegex;
    }

    public static final /* synthetic */ Regex access$getWebLinkRegex$p(MarkdownParser $this) {
        MarkdownParser markdownParser = $this;
        return webLinkRegex;
    }

    public static final /* synthetic */ Word access$parseTextElement(MarkdownParser $this, String word) {
        return $this.parseTextElement(word);
    }

    public static final /* synthetic */ List access$parseLinks(MarkdownParser $this, CharSequence inputChars) {
        return $this.parseLinks(inputChars);
    }

    public static final /* synthetic */ Regex access$getLinkRegex$p(MarkdownParser $this) {
        MarkdownParser markdownParser = $this;
        return linkRegex;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0006\u0010 \u001a\u00020\u0006J\u0006\u0010!\u001a\u00020\u0006J\u0006\u0010\"\u001a\u00020\u0006J\u0006\u0010#\u001a\u00020\u0006R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\fR\u001d\u0010\u0018\u001a\u0004\u0018\u00010\u00198FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006$"}, d2={"Lnetwork/rs485/markdown/MarkdownParser$LinkMatcher;", "", "match", "Llogisticspipes/kotlin/text/MatchResult;", "(Lkotlin/text/MatchResult;)V", "imageLinkFlag", "", "getImageLinkFlag", "()Z", "link", "", "getLink", "()Ljava/lang/String;", "getMatch", "()Lkotlin/text/MatchResult;", "path", "getPath", "queryComponents", "", "Lorg/apache/http/NameValuePair;", "getQueryComponents", "()Ljava/util/List;", "text", "getText", "uri", "Ljava/net/URI;", "getUri", "()Ljava/net/URI;", "uri$delegate", "Llogisticspipes/kotlin/Lazy;", "getMenuType", "Lnetwork/rs485/markdown/MenuParagraphType;", "isImageLink", "isItemLink", "isPageLink", "isWebLink", "logisticspipes"})
    private static final class LinkMatcher {
        @Nullable
        private final Lazy uri$delegate;
        @NotNull
        private final MatchResult match;

        @Nullable
        public final String getText() {
            MatchGroup matchGroup = this.match.getGroups().get(1);
            return matchGroup != null ? matchGroup.getValue() : null;
        }

        @Nullable
        public final String getLink() {
            MatchGroup matchGroup = this.match.getGroups().get(2);
            return matchGroup != null ? matchGroup.getValue() : null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final String getPath() {
            String string = this.getLink();
            Object object = string;
            if (string == null) return null;
            String string2 = object;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            MatchResult matchResult = Regex.find$default(MarkdownParser.access$getPathRegex$p(INSTANCE), it, 0, 2, null);
            object = matchResult;
            if (matchResult == null) return null;
            MatchGroupCollection matchGroupCollection = object.getGroups();
            object = matchGroupCollection;
            if (matchGroupCollection == null) return null;
            MatchGroup matchGroup = object.get(1);
            object = matchGroup;
            if (matchGroup == null) return null;
            String string3 = ((MatchGroup)object).getValue();
            return string3;
        }

        public final boolean getImageLinkFlag() {
            String string = this.match.getValue();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            return StringsKt.startsWith$default((CharSequence)((Object)StringsKt.trimStart((CharSequence)string2)).toString(), '!', false, 2, null);
        }

        @Nullable
        public final URI getUri() {
            Lazy lazy = this.uri$delegate;
            LinkMatcher linkMatcher = this;
            Object var3_3 = null;
            boolean bl = false;
            return (URI)lazy.getValue();
        }

        @NotNull
        public final List<NameValuePair> getQueryComponents() {
            Object object;
            block3: {
                block2: {
                    object = this.getUri();
                    if (object == null) break block2;
                    URI uRI = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    URI it = uRI;
                    boolean bl3 = false;
                    object = URLEncodedUtils.parse((String)it.getQuery(), (Charset)Charsets.UTF_8);
                    if (object != null) break block3;
                }
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        @Nullable
        public final MenuParagraphType getMenuType() {
            MenuParagraphType menuParagraphType;
            URI uRI = this.getUri();
            if (Intrinsics.areEqual(uRI != null ? uRI.getScheme() : null, "menu")) {
                Object v1;
                boolean bl;
                Iterable iterable;
                block3: {
                    iterable = this.getQueryComponents();
                    bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (Object t : iterable2) {
                        NameValuePair it = (NameValuePair)t;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(it.getName(), "type")) continue;
                        v1 = t;
                        break block3;
                    }
                    v1 = null;
                }
                iterable = v1;
                bl = false;
                boolean bl4 = false;
                NameValuePair type = (NameValuePair)iterable;
                boolean bl5 = false;
                menuParagraphType = type == null ? MenuParagraphType.LIST : (Intrinsics.areEqual(type.getValue(), "list") ? MenuParagraphType.LIST : (Intrinsics.areEqual(type.getValue(), "tile") ? MenuParagraphType.TILE : null));
            } else {
                menuParagraphType = null;
            }
            return menuParagraphType;
        }

        public final boolean isPageLink() {
            String string = this.getLink();
            return string != null ? StringsKt.startsWith(string, "page://", true) : false;
        }

        public final boolean isWebLink() {
            boolean bl;
            String string = this.getLink();
            if (string != null) {
                CharSequence charSequence = string;
                Regex regex = MarkdownParser.access$getWebLinkRegex$p(INSTANCE);
                boolean bl2 = false;
                bl = regex.matches(charSequence);
            } else {
                bl = false;
            }
            return bl;
        }

        public final boolean isImageLink() {
            String string = this.getLink();
            return string != null ? StringsKt.startsWith(string, "image://", true) : false;
        }

        public final boolean isItemLink() {
            String string = this.getLink();
            return string != null ? StringsKt.startsWith(string, "item://", true) : false;
        }

        @NotNull
        public final MatchResult getMatch() {
            return this.match;
        }

        public LinkMatcher(@NotNull MatchResult match) {
            Intrinsics.checkNotNullParameter(match, "match");
            this.match = match;
            this.uri$delegate = LazyKt.lazy((Function0)new Function0<URI>(this){
                final /* synthetic */ LinkMatcher this$0;

                @Nullable
                public final URI invoke() {
                    URI uRI;
                    String string = this.this$0.getLink();
                    if (string != null) {
                        URI uRI2;
                        String string2 = string;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string2;
                        boolean bl3 = false;
                        try {
                            uRI2 = new URI(it);
                        }
                        catch (URISyntaxException error) {
                            uRI2 = null;
                        }
                        uRI = uRI2;
                    } else {
                        uRI = null;
                    }
                    return uRI;
                }
                {
                    this.this$0 = linkMatcher;
                    super(0);
                }
            });
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0016J\u0006\u0010!\u001a\u00020\u001aJ\u001e\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0$H\u0002J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002J&\u0010)\u001a\u00020\u001a2\u001e\u0010*\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u000b\u0012\u0004\u0012\u00020\u001a0+J\u0011\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\fH\u0096\u0002J\b\u0010/\u001a\u00020\fH\u0016J\u000e\u00100\u001a\u00020&2\u0006\u0010.\u001a\u00020\fJ6\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u000b2\u0006\u0010.\u001a\u00020\f2\u0006\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u0016H\u0002J\u0018\u00105\u001a\u00020&2\u0006\u0010.\u001a\u00020\f2\u0006\u00104\u001a\u00020\u0016H\u0002J\u0010\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020\fH\u0002J\u0018\u00108\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u0016H\u0002J\u0018\u00109\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\f2\u0006\u0010;\u001a\u00020\fH\u0016J\b\u0010<\u001a\u00020\u0005H\u0016J\u001c\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010>\u001a\u00020\fH\u0002J\b\u0010?\u001a\u00020\u0005H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0017\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00180\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lnetwork/rs485/markdown/MarkdownParser$ReplacedCharSequence;", "", "original", "(Ljava/lang/CharSequence;)V", "cache", "", "current", "getCurrent", "()Ljava/lang/String;", "formattingStart", "", "Llogisticspipes/kotlin/Pair;", "", "Ljava/util/EnumSet;", "Lnetwork/rs485/markdown/TextFormat;", "length", "getLength", "()I", "getOriginal", "()Ljava/lang/CharSequence;", "replacementMap", "Llogisticspipes/kotlin/ranges/IntRange;", "Lnetwork/rs485/markdown/InlineElement;", "stagingReplacementMap", "Llogisticspipes/kotlin/Triple;", "addReplacement", "", "fullRange", "innerRange", "format", "chars", "Ljava/util/stream/IntStream;", "codePoints", "commit", "enhanceExistingReplacements", "range", "", "equals", "", "other", "", "forEachReplace", "action", "Llogisticspipes/kotlin/Function1;", "get", "", "index", "hashCode", "isWhitespaceAt", "replaceFormattingIfApplicable", "lowRange", "highRange", "element", "replacementIndexIsTextFormatting", "spaceReplacement", "cutIndex", "stageReplacingElement", "subSequence", "startIndex", "endIndex", "toString", "translateIndex", "start", "updateCachedSequence", "logisticspipes"})
    public static final class ReplacedCharSequence
    implements CharSequence {
        private final List<Pair<Integer, EnumSet<TextFormat>>> formattingStart;
        private final List<Pair<IntRange, InlineElement>> replacementMap;
        private final List<Triple<Integer, IntRange, InlineElement>> stagingReplacementMap;
        private String cache;
        @NotNull
        private final CharSequence original;

        @NotNull
        public final String getCurrent() {
            String string = this.cache;
            if (string == null) {
                string = this.updateCachedSequence();
            }
            return string;
        }

        private final String updateCachedSequence() {
            StringBuilder sb = new StringBuilder();
            Function1 append2 = new Function1<IntRange, IntRange>(this, sb){
                final /* synthetic */ ReplacedCharSequence this$0;
                final /* synthetic */ StringBuilder $sb;

                @Nullable
                public final IntRange invoke(@NotNull IntRange range) {
                    IntRange intRange;
                    Intrinsics.checkNotNullParameter(range, "range");
                    IntRange intRange2 = range;
                    boolean bl = false;
                    boolean bl2 = false;
                    IntRange it = intRange2;
                    boolean bl3 = false;
                    IntRange intRange3 = !it.isEmpty() ? intRange2 : null;
                    if (intRange3 != null) {
                        intRange2 = intRange3;
                        bl = false;
                        bl2 = false;
                        it = intRange2;
                        boolean bl4 = false;
                        this.$sb.append(StringsKt.subSequence(this.this$0.getOriginal(), it));
                        intRange = intRange2;
                    } else {
                        intRange = null;
                    }
                    return intRange;
                }
                {
                    this.this$0 = replacedCharSequence;
                    this.$sb = stringBuilder;
                    super(1);
                }
            };
            int lastIdx = 0;
            Iterable $this$forEach$iv = this.replacementMap;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair $dstr$range$_u24__u24 = (Pair)element$iv;
                boolean bl = false;
                IntRange range = (IntRange)$dstr$range$_u24__u24.component1();
                boolean bl2 = range.getFirst() >= lastIdx;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl4 = false;
                    String string = "trying to replace already replaced index " + lastIdx + " in " + this.replacementMap;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                append2.invoke(RangesKt.until(lastIdx, range.getFirst()));
                lastIdx = range.getLast() + 1;
            }
            append2.invoke(RangesKt.until(lastIdx, this.original.length()));
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
            String string2 = string;
            boolean bl = false;
            boolean bl5 = false;
            String it = string2;
            boolean bl6 = false;
            this.cache = it;
            return string2;
        }

        private final boolean spaceReplacement(int cutIndex) {
            boolean bl = this.isWhitespaceAt(cutIndex);
            boolean bl2 = false;
            boolean bl3 = false;
            boolean isSpace = bl;
            boolean bl4 = false;
            if (isSpace) {
                int n = cutIndex;
                this.stageReplacingElement(new IntRange(n, cutIndex), Space.INSTANCE);
            }
            return bl;
        }

        public final void addReplacement(@NotNull IntRange fullRange, @NotNull IntRange innerRange, @NotNull EnumSet<TextFormat> format) {
            Intrinsics.checkNotNullParameter(fullRange, "fullRange");
            Intrinsics.checkNotNullParameter(innerRange, "innerRange");
            Intrinsics.checkNotNullParameter(format, "format");
            if (fullRange.getFirst() > 0 && !this.spaceReplacement(innerRange.getFirst())) {
                this.spaceReplacement(fullRange.getFirst() - 1);
            }
            int n = innerRange.getLast() + 1;
            this.stageReplacingElement(new IntRange(n, fullRange.getLast()), new TextFormatting(TextFormat.Companion.getNone()));
            IntRange intRange = RangesKt.until(fullRange.getFirst(), innerRange.getFirst());
            Object object = format.clone();
            Intrinsics.checkNotNullExpressionValue(object, "format.clone()");
            this.stageReplacingElement(intRange, new TextFormatting((EnumSet<TextFormat>)object));
            this.enhanceExistingReplacements(innerRange, (Set<? extends TextFormat>)format);
            if (fullRange.getLast() + 1 < this.length() && !this.spaceReplacement(innerRange.getLast())) {
                this.spaceReplacement(fullRange.getLast() + 1);
            }
        }

        private final void enhanceExistingReplacements(IntRange range, Set<? extends TextFormat> format) {
            Pair<Integer, Integer> pair = this.translateIndex(range.getLast());
            int endReplacementMapIdx = ((Number)pair.component1()).intValue();
            if (endReplacementMapIdx == -1) {
                return;
            }
            Pair<Integer, Integer> pair2 = this.translateIndex(range.getFirst());
            int startReplacementMapIdx = ((Number)pair2.component1()).intValue();
            Iterable $this$forEach$iv = this.replacementMap.subList(startReplacementMapIdx + 1, endReplacementMapIdx + 1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                Pair it = (Pair)element$iv;
                boolean bl = false;
                Object b = it.getSecond();
                if (!(b instanceof TextFormatting)) {
                    b = null;
                }
                if ((object = (TextFormatting)b) == null || (object = ((TextFormatting)object).getFormat()) == null) continue;
                ((AbstractCollection)object).addAll((Collection)format);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void stageReplacingElement(IntRange range, InlineElement element) {
            void replacementMapIdx;
            int translatedIdx;
            Pair<Integer, Integer> pair = this.translateIndex(range.getFirst());
            int n = ((Number)pair.component1()).intValue();
            int n2 = translatedIdx = ((Number)pair.component2()).intValue();
            this.stagingReplacementMap.add(new Triple<Integer, IntRange, InlineElement>((int)(replacementMapIdx + true), new IntRange(n2, range.getLast() + translatedIdx - range.getFirst()), element));
            if (element instanceof TextFormatting) {
                Pair<Integer, EnumSet<TextFormat>> newFormat = TuplesKt.to(translatedIdx, ((TextFormatting)element).getFormat());
                if (this.formattingStart.isEmpty()) {
                    this.formattingStart.add(newFormat);
                } else {
                    int index;
                    int formatIdx2 = CollectionsKt.binarySearch$default(this.formattingStart, newFormat, stageReplacingElement.formatIdx.1.INSTANCE, 0, 0, 12, null);
                    int n3 = index = formatIdx2 < 0 ? -formatIdx2 - 1 : formatIdx2 + 1;
                    if (index > 0) {
                        newFormat.getSecond().addAll((Collection<TextFormat>)this.formattingStart.get(index - 1).getSecond());
                    }
                    this.formattingStart.add(index, newFormat);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Integer, Integer> translateIndex(int start) {
            void translatedIdx;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = start;
            int replacementMapIdx = -1;
            Sequence $this$forEachIndexed$iv = SequencesKt.takeWhile(CollectionsKt.asSequence((Iterable)this.replacementMap), (Function1)new Function1<Pair<? extends IntRange, ? extends InlineElement>, Boolean>((Ref.IntRef)translatedIdx){
                final /* synthetic */ Ref.IntRef $translatedIdx;

                public final boolean invoke(@NotNull Pair<IntRange, ? extends InlineElement> it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.$translatedIdx.element >= it.getFirst().getFirst();
                }
                {
                    this.$translatedIdx = intRef;
                    super(1);
                }
            });
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            Iterator iterator2 = $this$forEachIndexed$iv.iterator();
            while (iterator2.hasNext()) {
                void $dstr$range$_u24__u24;
                Object item$iv = iterator2.next();
                int n = index$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair pair = (Pair)item$iv;
                int curry = n;
                boolean bl2 = false;
                IntRange range = (IntRange)$dstr$range$_u24__u24.component1();
                translatedIdx.element += CollectionsKt.count(range);
                replacementMapIdx = curry;
            }
            return TuplesKt.to(replacementMapIdx, translatedIdx.element);
        }

        /*
         * WARNING - void declaration
         */
        public final void commit() {
            block6: {
                Collection collection = this.stagingReplacementMap;
                boolean bl = false;
                if (!(!collection.isEmpty())) break block6;
                Iterable $this$sortedByDescending$iv = this.stagingReplacementMap;
                boolean $i$f$sortedByDescending = false;
                boolean bl2 = false;
                Iterable $this$forEach$iv = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        Triple it = (Triple)b;
                        boolean bl2 = false;
                        Comparable comparable = Integer.valueOf(((IntRange)it.getSecond()).getLast());
                        it = (Triple)a;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Integer n = ((IntRange)it.getSecond()).getLast();
                        return ComparisonsKt.compareValues(comparable2, (Comparable)n);
                    }
                });
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Object object;
                    void replaceRange;
                    Pair<IntRange, InlineElement> pair;
                    void index;
                    InlineElement element;
                    block8: {
                        int it;
                        boolean bl3;
                        boolean bl4;
                        Integer n;
                        block7: {
                            Triple $dstr$index$replaceRange$element = (Triple)element$iv;
                            boolean bl5 = false;
                            int n2 = ((Number)$dstr$index$replaceRange$element.component1()).intValue();
                            IntRange intRange = (IntRange)$dstr$index$replaceRange$element.component2();
                            element = (InlineElement)$dstr$index$replaceRange$element.component3();
                            n = (int)(index - true);
                            bl4 = false;
                            bl3 = false;
                            it = ((Number)n).intValue();
                            boolean bl6 = false;
                            pair = this.replacementIndexIsTextFormatting(it, element) ? n : null;
                            if (pair == null) break block7;
                            n = pair;
                            bl4 = false;
                            bl3 = false;
                            int previousIdx = ((Number)n).intValue();
                            boolean bl7 = false;
                            pair = this.replaceFormattingIfApplicable(previousIdx, this.replacementMap.get(previousIdx).getFirst(), (IntRange)replaceRange, element);
                            if (pair != null) break block8;
                        }
                        n = (int)index;
                        bl4 = false;
                        bl3 = false;
                        it = ((Number)n).intValue();
                        boolean bl8 = false;
                        Integer n3 = this.replacementIndexIsTextFormatting((int)index, element) ? n : null;
                        if (n3 != null) {
                            n = n3;
                            bl4 = false;
                            bl3 = false;
                            int idx = ((Number)n).intValue();
                            boolean bl9 = false;
                            pair = this.replaceFormattingIfApplicable(idx, (IntRange)replaceRange, this.replacementMap.get(idx).getFirst(), this.replacementMap.get(idx).getSecond());
                        } else {
                            pair = object = null;
                        }
                    }
                    if (pair != null) continue;
                    this.replacementMap.add((int)index, TuplesKt.to(replaceRange, element));
                    object = Unit.INSTANCE;
                }
                this.cache = null;
                this.stagingReplacementMap.clear();
            }
        }

        private final boolean replacementIndexIsTextFormatting(int index, InlineElement element) {
            int n = index;
            return 0 <= n && ((Collection)this.replacementMap).size() > n && element instanceof TextFormatting && this.replacementMap.get(index).getSecond() instanceof TextFormatting;
        }

        private final Pair<IntRange, InlineElement> replaceFormattingIfApplicable(int index, IntRange lowRange, IntRange highRange, InlineElement element) {
            Pair<IntRange, InlineElement> pair;
            if (lowRange.getLast() + 1 == highRange.getFirst()) {
                int n = lowRange.getFirst();
                Pair<IntRange, InlineElement> pair2 = TuplesKt.to(new IntRange(n, highRange.getLast()), element);
                boolean bl = false;
                boolean bl2 = false;
                Pair<IntRange, InlineElement> it = pair2;
                boolean bl3 = false;
                this.replacementMap.set(index, it);
                pair = pair2;
            } else {
                pair = null;
            }
            return pair;
        }

        public final void forEachReplace(@NotNull Function1<? super Pair<IntRange, ? extends InlineElement>, Unit> action) {
            Intrinsics.checkNotNullParameter(action, "action");
            Iterable $this$forEach$iv = this.replacementMap;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                action.invoke((Pair<IntRange, ? extends InlineElement>)element$iv);
            }
        }

        public int getLength() {
            return this.getCurrent().length();
        }

        public final boolean isWhitespaceAt(int index) {
            return CharsKt.isWhitespace(this.charAt(index));
        }

        public char get(int index) {
            return this.getCurrent().charAt(index);
        }

        @Override
        @NotNull
        public CharSequence subSequence(int startIndex, int endIndex) {
            return this.getCurrent().subSequence(startIndex, endIndex);
        }

        @Override
        @NotNull
        public IntStream chars() {
            IntStream intStream = this.getCurrent().chars();
            Intrinsics.checkNotNullExpressionValue(intStream, "current.chars()");
            return intStream;
        }

        @Override
        @NotNull
        public IntStream codePoints() {
            IntStream intStream = this.getCurrent().codePoints();
            Intrinsics.checkNotNullExpressionValue(intStream, "current.codePoints()");
            return intStream;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof ReplacedCharSequence && Intrinsics.areEqual(this.original, ((ReplacedCharSequence)other).original) && Intrinsics.areEqual(this.replacementMap, ((ReplacedCharSequence)other).replacementMap);
        }

        public int hashCode() {
            return this.original.hashCode() + ((Object)this.replacementMap).hashCode();
        }

        @Override
        @NotNull
        public String toString() {
            return super.toString() + "(original=\"" + StringsKt.take(this.original, 16) + "[\u2026]\"," + "replacementMap=" + StringsKt.take(this.replacementMap.toString(), 16) + "[\u2026])";
        }

        @NotNull
        public final CharSequence getOriginal() {
            return this.original;
        }

        public ReplacedCharSequence(@NotNull CharSequence original) {
            Intrinsics.checkNotNullParameter(original, "original");
            this.original = original;
            boolean bl = false;
            this.formattingStart = new ArrayList();
            bl = false;
            this.replacementMap = new ArrayList();
            bl = false;
            this.stagingReplacementMap = new ArrayList();
        }
    }
}

