/*
 * Decompiled with CFR 0.152.
 */
package uk.binarycraft.moredefaultoptions;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import uk.binarycraft.moredefaultoptions.MoreDefaultOptions;

public class ConfigFile {
    public String sourceFilePath;
    public String destinationFilePath;
    public boolean serverSide;
    public boolean clientSide;

    public ConfigFile(String sourceFilePath, String destinationFilePath, boolean serverSide, boolean clientSide) {
        this.sourceFilePath = sourceFilePath;
        this.destinationFilePath = destinationFilePath;
        this.serverSide = serverSide;
        this.clientSide = clientSide;
    }

    public boolean sourcePathIsValid() {
        return this.checkPathIsValid(this.sourceFilePath, false);
    }

    public boolean destinationPathIsValid() {
        return this.checkPathIsValid(this.destinationFilePath, true);
    }

    public void processClientSide() {
        if (!this.clientSide) {
            System.out.println("Attempt to process a non client side file on the client side. Please report to mod author");
            return;
        }
        this.process();
    }

    public void processServerSide() {
        if (!this.serverSide) {
            System.out.println("Attempt to process a non server side file on the server side. Please report to mod author");
            return;
        }
        this.process();
    }

    private void process() {
        if (!this.destinationPathIsValid()) {
            System.out.println("The destination filepath " + this.destinationFilePath + " is invalid, skipping");
            return;
        }
        if (!this.sourcePathIsValid()) {
            System.out.println("The source filepath " + this.sourceFilePath + " is invalid, skipping");
            return;
        }
        File sourceFile = new File(MoreDefaultOptions.moreDefaultOptionsDirectory + this.sourceFilePath);
        if (!sourceFile.exists()) {
            System.out.println("Source configuration file " + this.sourceFilePath + " doesn't exist, skipping");
            return;
        }
        if (sourceFile.isDirectory()) {
            System.out.println("Source configuration file " + this.sourceFilePath + " appears to be a directory, skipping");
            return;
        }
        File destFile = new File(MoreDefaultOptions.instanceRootDirectory + this.destinationFilePath);
        if (destFile.exists()) {
            System.out.println("Destination configuration file " + this.destinationFilePath + " already exists, skipping default file generation");
            return;
        }
        try {
            Files.createDirectories(destFile.toPath().getParent(), new FileAttribute[0]);
            Files.copy(sourceFile.toPath(), destFile.toPath(), new CopyOption[0]);
            System.out.println("Created default configuration file " + this.destinationFilePath);
        }
        catch (IOException e) {
            System.out.println("Unable to copy configuration file. Is the destination path correct? The following is a hint to the problem:" + e.getMessage());
        }
    }

    private boolean checkPathIsValid(String path, boolean allowDirectories) {
        path = path.trim();
        if ((path = path.replace("\\", "/")).startsWith("/")) {
            return false;
        }
        if (path.contains("..")) {
            return false;
        }
        if (path.contains("./")) {
            return false;
        }
        return allowDirectories || !path.contains("/");
    }
}

