/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.wearsfr;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import tk.zeitheron.solarflux.api.SolarInfo;
import tk.zeitheron.solarflux.block.BlockBaseSolar;
import tk.zeitheron.wearsfr.WearableSolars;

public class SolarPaneInfo {
    public static final String SPTAG = "WearSFRPanel";
    public final SolarInfo solar;

    public SolarPaneInfo(SolarInfo block) {
        this.solar = block;
    }

    public ResourceLocation getTopTex() {
        return this.solar.getTexture();
    }

    public static int getGeneration(ItemStack head, EntityPlayer player) {
        SolarPaneInfo inf = SolarPaneInfo.fromHelmet(head);
        if (inf != null && player.field_70170_p.func_175678_i(player.func_180425_c())) {
            return inf.getCurrentGenerationForPlayer(player);
        }
        return 0;
    }

    public long getMaxGen() {
        return this.solar.getGeneration();
    }

    public int getCurrentGenerationForPlayer(EntityPlayer player) {
        float ints = SolarPaneInfo.computeSunIntensity(player.field_70170_p, player.func_180425_c());
        return Math.round(ints * (float)this.getMaxGen());
    }

    public static SolarPaneInfo fromHelmet(ItemStack head) {
        boolean panel = !head.func_190926_b() && head.func_77942_o() && head.func_77978_p().func_150297_b(SPTAG, 8);
        NBTTagCompound nbt = head.func_77978_p();
        if (panel && head.func_77973_b() instanceof ItemArmor && ((ItemArmor)head.func_77973_b()).field_77881_a == EntityEquipmentSlot.HEAD) {
            return SolarPaneInfo.from(nbt);
        }
        return null;
    }

    public static SolarPaneInfo from(Block sp) {
        if (sp != null && sp instanceof BlockBaseSolar) {
            Item item = Item.func_150898_a((Block)sp);
            if (!WearableSolars.INFOS.containsKey(item)) {
                WearableSolars.LOG.info("Assigned solar panel with it's info: " + sp.getRegistryName());
                WearableSolars.INFOS.put(item, new SolarPaneInfo(((BlockBaseSolar)sp).solarInfo));
            }
            return WearableSolars.INFOS.get(item);
        }
        return null;
    }

    public static SolarPaneInfo from(Item item) {
        return SolarPaneInfo.from(Block.func_149634_a((Item)item));
    }

    public static SolarPaneInfo from(NBTTagCompound nbt) {
        return nbt == null || !nbt.func_150297_b(SPTAG, 8) ? null : SolarPaneInfo.from((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.func_74779_i(SPTAG))));
    }

    public static float computeSunIntensity(World world, BlockPos at) {
        float intens = 0.0f;
        if (world.func_175710_j(at)) {
            float mult = 1.5f;
            float displ = 1.2f;
            float celestialAngleRadians = world.func_72929_e(1.0f);
            if ((double)celestialAngleRadians > Math.PI) {
                celestialAngleRadians = (float)(Math.PI * 2 - (double)celestialAngleRadians);
            }
            intens = mult * MathHelper.func_76134_b((float)(celestialAngleRadians / displ));
            intens = Math.max(0.0f, intens);
            intens = Math.min(1.0f, intens);
        }
        return intens;
    }
}

