/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.wearsfr;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.internal.SimpleRegistration;
import com.zeitheron.hammercore.utils.WorldUtil;
import com.zeitheron.hammercore.utils.charging.AbstractCharge;
import com.zeitheron.hammercore.utils.charging.ItemChargeHelper;
import com.zeitheron.hammercore.utils.charging.fe.FECharge;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Logger;
import tk.zeitheron.solarflux.api.SolarFluxAPI;
import tk.zeitheron.solarflux.block.ItemBlockBaseSolar;
import tk.zeitheron.wearsfr.SolarPaneInfo;
import tk.zeitheron.wearsfr.blocks.BlockSolarEjector;
import tk.zeitheron.wearsfr.blocks.BlockSolarInjector;
import tk.zeitheron.wearsfr.proxy.CommonProxy;

@Mod(modid="wearsfr", name="Solar Flux Additions", version="12.3.2", dependencies="required-after:hammercore@[2.0.6.23,);required-after:solarflux@[12.4.11,)", acceptedMinecraftVersions="[1.12.2]")
public class WearableSolars {
    public static Logger LOG;
    @SidedProxy(clientSide="tk.zeitheron.wearsfr.proxy.ClientProxy", serverSide="tk.zeitheron.wearsfr.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final Map<Item, SolarPaneInfo> INFOS;
    public static final BlockSolarInjector SOLAR_INJECTOR;
    public static final BlockSolarEjector SOLAR_EJECTOR;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        LOG = e.getModLog();
        ModMetadata md = e.getModMetadata();
        md.autogenerated = false;
        md.authorList = HammerCore.AUTHORS;
        md.version = "wearsfr";
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        SimpleRegistration.registerFieldBlocksFrom(this.getClass(), (String)"wearsfr", (CreativeTabs)SolarFluxAPI.tab);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        ForgeRegistries.ITEMS.getValuesCollection().stream().filter(b -> b instanceof ItemBlockBaseSolar).forEach(SolarPaneInfo::from);
        proxy.init();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void armorBreak(LivingAttackEvent e) {
        EntityLivingBase living = e.getEntityLiving();
        if (living != null) {
            ItemStack head;
            float damage = e.getAmount() / 4.0f;
            if (damage < 1.0f) {
                damage = 1.0f;
            }
            if (!(head = living.func_184582_a(EntityEquipmentSlot.HEAD)).func_190926_b() && head.func_77973_b() instanceof ItemArmor && head.func_77973_b().func_77645_m() && (float)head.func_77952_i() + damage >= (float)head.func_77958_k()) {
                SolarPaneInfo inf;
                living.func_70669_a(head);
                boolean panel = head.func_77942_o() && head.func_77978_p().func_150297_b("WearSFRPanel", 8);
                NBTTagCompound nbt = head.func_77978_p();
                if (nbt != null) {
                    nbt = nbt.func_74737_b();
                }
                head.func_190918_g(1);
                if (panel && (inf = SolarPaneInfo.from(nbt)) != null) {
                    ItemStack drop = new ItemStack((Block)inf.solar.getBlock());
                    EntityPlayer player = (EntityPlayer)WorldUtil.cast((Object)living, EntityPlayer.class);
                    if (player == null || !player.func_191521_c(drop)) {
                        WorldUtil.spawnItemStack((World)living.field_70170_p, (BlockPos)living.func_180425_c(), (ItemStack)drop);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase != TickEvent.Phase.START || e.player.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = e.player;
        ItemStack head = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        int generation = SolarPaneInfo.getGeneration(head, player);
        int charged = ((FECharge)ItemChargeHelper.chargePlayer((EntityPlayer)player, (AbstractCharge)new FECharge((int)generation), (boolean)false)).FE;
    }

    static {
        INFOS = new HashMap<Item, SolarPaneInfo>();
        SOLAR_INJECTOR = new BlockSolarInjector();
        SOLAR_EJECTOR = new BlockSolarEjector();
    }
}

