/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.wearsfr.blocks;

import com.zeitheron.hammercore.internal.capabilities.FEEnergyStorage;
import com.zeitheron.hammercore.tile.ITileDroppable;
import com.zeitheron.hammercore.tile.TileSyncableTickable;
import com.zeitheron.hammercore.tile.tooltip.own.IRenderableInfo;
import com.zeitheron.hammercore.tile.tooltip.own.ITooltip;
import com.zeitheron.hammercore.tile.tooltip.own.ITooltipProviderHC;
import com.zeitheron.hammercore.tile.tooltip.own.inf.ItemStackTooltipInfo;
import com.zeitheron.hammercore.tile.tooltip.own.inf.StringTooltipInfo;
import com.zeitheron.hammercore.tile.tooltip.own.inf.TranslationTooltipInfo;
import com.zeitheron.hammercore.utils.WorldUtil;
import com.zeitheron.hammercore.utils.inventory.InventoryDummy;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import tk.zeitheron.wearsfr.InfoWS;
import tk.zeitheron.wearsfr.SolarPaneInfo;

public class TileSolarEjector
extends TileSyncableTickable
implements IEnergyStorage,
ITileDroppable,
ITooltipProviderHC {
    public final InventoryDummy inv = new InventoryDummy(1);
    public final FEEnergyStorage fe = new FEEnergyStorage(4000);
    public int prevProgress = 0;
    public int progress = 0;
    public boolean dirty = false;

    public int getCraftTime() {
        return 10;
    }

    public void tick() {
        this.prevProgress = this.progress;
        if (this.ticksExisted % 8 == 0) {
            this.setTooltipDirty(true);
        }
        if (this.canEject()) {
            if (this.fe.getEnergyStored() >= 100 && this.atTickRate(20) && this.fe.extractEnergy(200, false) >= 100) {
                ++this.progress;
                this.setTooltipDirty(true);
                this.sendChangesToNearby();
            }
            if (!this.field_145850_b.field_72995_K && this.progress >= this.getCraftTime()) {
                this.progress -= this.getCraftTime();
                this.eject();
                this.sendChangesToNearby();
            }
        } else if (this.progress > 0) {
            --this.progress;
        }
    }

    public boolean canEject() {
        return SolarPaneInfo.fromHelmet(this.inv.func_70301_a(0)) != null;
    }

    public void eject() {
        SolarPaneInfo spi = SolarPaneInfo.fromHelmet(this.inv.func_70301_a(0));
        if (spi != null) {
            EntityItem ei;
            ItemStack helm = InfoWS.removeSubTag(this.inv.func_70301_a(0).func_77946_l(), "WearSFRPanel");
            helm.func_190920_e(1);
            this.inv.func_70301_a(0).func_190918_g(1);
            ItemStack sps = new ItemStack((Block)spi.solar.getBlock());
            EnumFacing face = WorldUtil.getFacing((IBlockState)this.getLocation().getState());
            Vec3d nv = new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5 + (double)face.func_82601_c() * 0.65, 0.5, 0.5 + (double)face.func_82599_e() * 0.65);
            if (!this.field_145850_b.field_72995_K) {
                ei = new EntityItem(this.field_145850_b, nv.field_72450_a, nv.field_72448_b, nv.field_72449_c, helm);
                ei.field_70181_x = 0.0;
                ei.field_70159_w = (double)face.func_82601_c() * 0.1;
                ei.field_70179_y = (double)face.func_82599_e() * 0.1;
                this.field_145850_b.func_72838_d((Entity)ei);
            }
            if (!this.field_145850_b.field_72995_K) {
                ei = new EntityItem(this.field_145850_b, nv.field_72450_a, nv.field_72448_b, nv.field_72449_c, sps);
                ei.field_70181_x = 0.0;
                ei.field_70159_w = (double)face.func_82601_c() * 0.1;
                ei.field_70179_y = (double)face.func_82599_e() * 0.1;
                this.field_145850_b.func_72838_d((Entity)ei);
            }
        }
    }

    private void randomizeTraj(EntityItem ei) {
    }

    public void createDrop(EntityPlayer player, World world, BlockPos pos) {
        this.inv.drop(world, pos);
    }

    public void readNBT(NBTTagCompound nbt) {
        this.prevProgress = nbt.func_74762_e("PrevProgress");
        this.inv.readFromNBT(nbt.func_74775_l("Items"));
        this.progress = nbt.func_74762_e("Progress");
        this.fe.readFromNBT(nbt);
        this.setTooltipDirty(true);
    }

    public void writeNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("Items", (NBTBase)this.inv.writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("PrevProgress", this.prevProgress);
        nbt.func_74768_a("Progress", this.progress);
        this.fe.writeToNBT(nbt);
    }

    protected IItemHandler createSidedHandler(EnumFacing side) {
        InvWrapper invWrapper = new InvWrapper((IInventory)this.inv);
        this.itemHandlers[side.ordinal()] = invWrapper;
        return invWrapper;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.fe.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.fe.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.fe.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public boolean isTooltipDirty() {
        return this.dirty;
    }

    public void setTooltipDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void addInformation(ITooltip tip) {
        SolarPaneInfo spi = SolarPaneInfo.fromHelmet(this.inv.func_70301_a(0));
        if (spi != null) {
            ItemStack helm = InfoWS.removeSubTag(this.inv.func_70301_a(0).func_77946_l(), "WearSFRPanel");
            helm.func_190920_e(1);
            ItemStack sps = new ItemStack((Block)spi.solar.getBlock());
            tip.append((IRenderableInfo)new ItemStackTooltipInfo(this.inv.func_70301_a(0), 16, 16));
            tip.append((IRenderableInfo)new StringTooltipInfo(TextFormatting.BOLD + " \u2192 "));
            tip.append((IRenderableInfo)new ItemStackTooltipInfo(helm, 16, 16));
            tip.append((IRenderableInfo)new StringTooltipInfo(" & "));
            tip.append((IRenderableInfo)new ItemStackTooltipInfo(sps, 16, 16));
        }
        tip.newLine();
        tip.append((IRenderableInfo)new TranslationTooltipInfo(InfoWS.info("progress")));
        tip.append((IRenderableInfo)new StringTooltipInfo(": "));
        tip.append((IRenderableInfo)new StringTooltipInfo(Math.round((float)this.progress / (float)this.getCraftTime() * 100.0f) + "%"));
        tip.newLine();
        boolean pro = !this.inv.func_70301_a(0).func_190926_b();
        tip.append((IRenderableInfo)new TranslationTooltipInfo(InfoWS.info(!pro ? "required.helmet.charge" : "processing")));
        if (pro) {
            char[] chs = new char[this.ticksExisted / 8 % 4];
            Arrays.fill(chs, '.');
            tip.append((IRenderableInfo)new StringTooltipInfo(new String(chs)));
        }
    }
}

