/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.wearsfr.blocks;

import com.zeitheron.hammercore.internal.capabilities.FEEnergyStorage;
import com.zeitheron.hammercore.tile.ITileDroppable;
import com.zeitheron.hammercore.tile.TileSyncableTickable;
import com.zeitheron.hammercore.tile.tooltip.own.IRenderableInfo;
import com.zeitheron.hammercore.tile.tooltip.own.ITooltip;
import com.zeitheron.hammercore.tile.tooltip.own.ITooltipProviderHC;
import com.zeitheron.hammercore.tile.tooltip.own.inf.ItemStackTooltipInfo;
import com.zeitheron.hammercore.tile.tooltip.own.inf.StringTooltipInfo;
import com.zeitheron.hammercore.tile.tooltip.own.inf.TranslationTooltipInfo;
import com.zeitheron.hammercore.utils.WorldUtil;
import com.zeitheron.hammercore.utils.inventory.InventoryDummy;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import tk.zeitheron.wearsfr.InfoWS;
import tk.zeitheron.wearsfr.SolarPaneInfo;
import tk.zeitheron.wearsfr.util.TipUts;

public class TileSolarInjector
extends TileSyncableTickable
implements IEnergyStorage,
ITileDroppable,
ITooltipProviderHC {
    public final InventoryDummy inv = new InventoryDummy(2);
    public final FEEnergyStorage fe = new FEEnergyStorage(4000);
    public int prevProgress = 0;
    public int progress = 0;
    public boolean dirty = false;

    public int getCraftTime() {
        return 20;
    }

    public void tick() {
        this.prevProgress = this.progress;
        if (this.ticksExisted % 8 == 0) {
            this.setTooltipDirty(true);
        }
        if (this.canInject()) {
            if (this.fe.getEnergyStored() >= 200 && this.atTickRate(20) && this.fe.extractEnergy(200, false) >= 200) {
                ++this.progress;
                this.setTooltipDirty(true);
                this.sendChangesToNearby();
            }
            if (!this.field_145850_b.field_72995_K && this.progress >= this.getCraftTime()) {
                this.progress -= this.getCraftTime();
                this.inject();
                this.sendChangesToNearby();
            }
        } else if (this.progress > 0) {
            --this.progress;
        }
    }

    public boolean canInject() {
        ItemStack helm = this.inv.func_70301_a(0);
        ItemStack panel = this.inv.func_70301_a(1);
        return !helm.func_190926_b() && helm.func_77973_b() instanceof ItemArmor && ((ItemArmor)helm.func_77973_b()).field_77881_a == EntityEquipmentSlot.HEAD && !panel.func_190926_b() && SolarPaneInfo.from(panel.func_77973_b()) != null;
    }

    public void inject() {
        ItemStack helm = this.inv.func_70301_a(0);
        ItemStack panel = this.inv.func_70301_a(1);
        ItemStack nst = helm.func_77946_l();
        nst.func_190920_e(1);
        NBTTagCompound tag = nst.func_77942_o() ? nst.func_77978_p() : new NBTTagCompound();
        tag.func_74778_a("WearSFRPanel", panel.func_77973_b().getRegistryName().toString());
        nst.func_77982_d(tag);
        helm.func_190918_g(1);
        panel.func_190918_g(1);
        EnumFacing face = WorldUtil.getFacing((IBlockState)this.getLocation().getState());
        Vec3d nv = new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5 + (double)face.func_82601_c() * 0.65, 0.5, 0.5 + (double)face.func_82599_e() * 0.65);
        if (!this.field_145850_b.field_72995_K) {
            EntityItem ei = new EntityItem(this.field_145850_b, nv.field_72450_a, nv.field_72448_b, nv.field_72449_c, nst);
            ei.field_70181_x = 0.0;
            ei.field_70159_w = (double)face.func_82601_c() * 0.1;
            ei.field_70179_y = (double)face.func_82599_e() * 0.1;
            this.field_145850_b.func_72838_d((Entity)ei);
        }
    }

    private void randomizeTraj(EntityItem ei) {
    }

    public void createDrop(EntityPlayer player, World world, BlockPos pos) {
        this.inv.drop(world, pos);
    }

    public void readNBT(NBTTagCompound nbt) {
        this.prevProgress = nbt.func_74762_e("PrevProgress");
        this.inv.readFromNBT(nbt.func_74775_l("Items"));
        this.progress = nbt.func_74762_e("Progress");
        this.fe.readFromNBT(nbt);
        this.setTooltipDirty(true);
    }

    public void writeNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("Items", (NBTBase)this.inv.writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("PrevProgress", this.prevProgress);
        nbt.func_74768_a("Progress", this.progress);
        this.fe.writeToNBT(nbt);
    }

    protected IItemHandler createSidedHandler(EnumFacing side) {
        InvWrapper invWrapper = new InvWrapper((IInventory)this.inv);
        this.itemHandlers[side.ordinal()] = invWrapper;
        return invWrapper;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.fe.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.fe.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.fe.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public boolean isTooltipDirty() {
        return this.dirty;
    }

    public void setTooltipDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void addInformation(ITooltip tip) {
        ArrayList<IRenderableInfo> sum = new ArrayList<IRenderableInfo>();
        if (!this.inv.func_70301_a(0).func_190926_b()) {
            sum.add((IRenderableInfo)new ItemStackTooltipInfo(this.inv.func_70301_a(0), 16, 16));
        }
        if (!this.inv.func_70301_a(1).func_190926_b()) {
            sum.add((IRenderableInfo)new ItemStackTooltipInfo(this.inv.func_70301_a(1), 16, 16));
        }
        TipUts.join(tip, '+', sum);
        if (this.canInject()) {
            ItemStack helm = this.inv.func_70301_a(0);
            ItemStack panel = this.inv.func_70301_a(1);
            ItemStack nst = helm.func_77946_l();
            nst.func_190920_e(1);
            NBTTagCompound tag = nst.func_77942_o() ? nst.func_77978_p() : new NBTTagCompound();
            tag.func_74778_a("WearSFRPanel", panel.func_77973_b().getRegistryName().toString());
            nst.func_77982_d(tag);
            tip.append((IRenderableInfo)new StringTooltipInfo(" = "));
            tip.append((IRenderableInfo)new ItemStackTooltipInfo(nst, 16, 16));
        }
        tip.newLine();
        tip.append((IRenderableInfo)new TranslationTooltipInfo(InfoWS.info("progress")));
        tip.append((IRenderableInfo)new StringTooltipInfo(": "));
        tip.append((IRenderableInfo)new StringTooltipInfo(Math.round((float)this.progress / (float)this.getCraftTime() * 100.0f) + "%"));
        tip.newLine();
        if (this.inv.func_70301_a(0).func_190926_b()) {
            tip.append((IRenderableInfo)new TranslationTooltipInfo(InfoWS.info("required.helmet.normal")));
        } else if (this.inv.func_70301_a(1).func_190926_b()) {
            tip.append((IRenderableInfo)new TranslationTooltipInfo(InfoWS.info("required.solar")));
        } else {
            tip.append((IRenderableInfo)new TranslationTooltipInfo(InfoWS.info("processing")));
            char[] chs = new char[this.ticksExisted / 8 % 4];
            Arrays.fill(chs, '.');
            tip.append((IRenderableInfo)new StringTooltipInfo(new String(chs)));
        }
    }
}

