/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.wearsfr.proxy;

import com.zeitheron.hammercore.bookAPI.fancy.ManualCategories;
import com.zeitheron.hammercore.bookAPI.fancy.ManualEntry;
import com.zeitheron.hammercore.bookAPI.fancy.ManualPage;
import com.zeitheron.hammercore.client.render.item.IItemRender;
import com.zeitheron.hammercore.client.render.item.ItemRenderingHandler;
import com.zeitheron.hammercore.client.utils.RenderUtil;
import com.zeitheron.hammercore.client.utils.UtilsFX;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;
import tk.zeitheron.solarflux.block.BlockBaseSolar;
import tk.zeitheron.wearsfr.InfoWS;
import tk.zeitheron.wearsfr.SolarPaneInfo;
import tk.zeitheron.wearsfr.WearableSolars;
import tk.zeitheron.wearsfr.proxy.CommonProxy;

public class ClientProxy
extends CommonProxy
implements IItemRender {
    @Override
    public void init() {
        ItemRenderingHandler.INSTANCE.applyItemRender((IItemRender)this, it -> it instanceof ItemArmor && ((ItemArmor)it).field_77881_a == EntityEquipmentSlot.HEAD);
        ManualCategories.registerCategory((String)"wearsfr", (ResourceLocation)new ResourceLocation("wearsfr", "textures/mbg.png"), (ResourceLocation)new ResourceLocation("hammercore", "textures/gui/manual_back.png"));
        new ManualEntry("wearsfr", "wearsfr", 0, 0, WearableSolars.INFOS.values().stream().map(p -> {
            ItemStack stack = new ItemStack((Item)Items.field_151161_ac);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("WearSFRPanel", p.solar.getBlock().getRegistryName().toString());
            stack.func_77982_d(nbt);
            return stack;
        }).collect(Collectors.toList())).setPages(new ManualPage[]{new ManualPage("hc.manual_desc.wearsfr")}).setShape(ManualEntry.EnumEntryShape.ROUND).registerEntry();
        new ManualEntry("wearsfr:solar_injector", "wearsfr", 0, 2, new ItemStack((Block)WearableSolars.SOLAR_INJECTOR)).setPages(new ManualPage[]{new ManualPage("hc.manual_desc.wearsfr:solar_injector"), new ManualPage(ManualPage.PageType.NORMAL_CRAFTING, new ItemStack((Block)WearableSolars.SOLAR_INJECTOR))}).setShape(ManualEntry.eEntryShape.HEX).setParents(new String[]{"wearsfr"}).registerEntry();
        new ManualEntry("wearsfr:solar_ejector", "wearsfr", 2, 2, new ItemStack((Block)WearableSolars.SOLAR_EJECTOR)).setPages(new ManualPage[]{new ManualPage("hc.manual_desc.wearsfr:solar_ejector"), new ManualPage(ManualPage.PageType.NORMAL_CRAFTING, new ItemStack((Block)WearableSolars.SOLAR_EJECTOR))}).setShape(ManualEntry.eEntryShape.HEX).setParents(new String[]{"wearsfr:solar_injector"}).registerEntry();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void tooltip(ItemTooltipEvent e) {
        ItemStack stack = e.getItemStack();
        EntityPlayer player = e.getEntityPlayer();
        ItemStack onHead = player != null ? player.field_71071_by.func_70440_f(3) : ItemStack.field_190927_a;
        SolarPaneInfo spi = SolarPaneInfo.fromHelmet(stack);
        if (spi != null) {
            try {
                e.getToolTip().add(I18n.func_135052_a((String)InfoWS.info("panel"), (Object[])new Object[]{spi.solar.getBlock().func_149732_F()}));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            e.getToolTip().add(I18n.func_135052_a((String)InfoWS.info("energy.generation.max"), (Object[])new Object[]{spi.getMaxGen()}));
        }
        if (player != null && onHead == stack) {
            int gen = SolarPaneInfo.getGeneration(stack, player);
            e.getToolTip().add(I18n.func_135052_a((String)"info.solarflux.energy.generation", (Object[])new Object[]{gen}));
        }
    }

    public void renderItem(ItemStack item) {
    }

    public void renderItem(ItemStack stack, IBakedModel bakedmodel, ItemCameraTransforms.TransformType transform) {
        SolarPaneInfo spi;
        if (transform == ItemCameraTransforms.TransformType.GUI && (spi = SolarPaneInfo.fromHelmet(stack)) != null) {
            TextureAtlasSprite s = this.t_top(spi.solar.getBlock());
            UtilsFX.bindTexture((ResourceLocation)TextureMap.field_110575_b);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)2.0f, (float)2.0f, (float)-300.0f);
            GL11.glScalef((float)0.75f, (float)0.75f, (float)1.0f);
            GlStateManager.func_179140_f();
            RenderUtil.drawTexturedModalRect((double)0.0, (double)0.0, (TextureAtlasSprite)s, (double)16.0, (double)16.0);
            GlStateManager.func_179145_e();
            GL11.glPopMatrix();
        }
    }

    public TextureAtlasSprite t_top(BlockBaseSolar block) {
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(block.getRegistryName().func_110624_b() + ":blocks/" + block.getRegistryName().func_110623_a() + "_top");
    }
}

