/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.clochepp.cloche;

import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public class SoilType {
    public static final SoilType DIRT = SoilType.oreDict("dirt", null);
    public static final SoilType SAND = SoilType.oreDict("sand", null);
    private final Predicate<ItemStack> matcher;
    @Nullable
    private final IBlockState display;

    public static SoilType oreDict(String key, @Nullable IBlockState display) {
        int targetId = OreDictionary.getOreID((String)key);
        return new SoilType(s -> {
            for (int id : OreDictionary.getOreIDs((ItemStack)s)) {
                if (id != targetId) continue;
                return true;
            }
            return false;
        }, display);
    }

    public static SoilType exact(ItemStack stack, @Nullable IBlockState display) {
        return new SoilType(s -> ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)s), display);
    }

    public SoilType(Predicate<ItemStack> matcher, @Nullable IBlockState display) {
        this.matcher = matcher;
        this.display = display;
    }

    public boolean test(ItemStack stack) {
        return !stack.func_190926_b() && this.matcher.test(stack);
    }

    @Nullable
    public ResourceLocation getDisplay() {
        Collection textures;
        if (this.display != null && !(textures = Minecraft.func_71410_x().func_175602_ab().func_184389_a(this.display).func_177554_e().getDependencies()).isEmpty()) {
            return (ResourceLocation)textures.iterator().next();
        }
        return null;
    }

    public SoilType or(SoilType ... other) {
        Predicate<ItemStack> m = this.matcher;
        for (SoilType type : other) {
            m = m.or(type.matcher);
        }
        return new SoilType(m, null);
    }
}

