/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.tag;

import com.github.lunatrius.ingameinfo.client.gui.overlay.InfoIcon;
import com.github.lunatrius.ingameinfo.tag.Tag;
import com.github.lunatrius.ingameinfo.tag.registry.TagRegistry;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.resources.ResourcePackRepository;

public abstract class TagMisc
extends Tag {
    protected static final ResourcePackRepository resourcePackRepository = minecraft.func_110438_M();

    @Override
    public String getCategory() {
        return "misc";
    }

    public static void register() {
        TagRegistry.INSTANCE.register(new MemoryMaximum().setName("memmax"));
        TagRegistry.INSTANCE.register(new MemoryTotal().setName("memtotal"));
        TagRegistry.INSTANCE.register(new MemoryFree().setName("memfree"));
        TagRegistry.INSTANCE.register(new MemoryUsed().setName("memused"));
        TagRegistry.INSTANCE.register(new FPS().setName("fps"));
        TagRegistry.INSTANCE.register(new ResourcePack().setName("resourcepack"));
        TagRegistry.INSTANCE.register(new EntitiesRendered().setName("entitiesrendered"));
        TagRegistry.INSTANCE.register(new EntitiesTotal().setName("entitiestotal"));
        TagRegistry.INSTANCE.register(new LoadedChunks().setName("loadedchunks"));
        TagRegistry.INSTANCE.register(new Server().setName("server"));
        TagRegistry.INSTANCE.register(new ServerName().setName("servername"));
        TagRegistry.INSTANCE.register(new ServerIP().setName("serverip"));
        TagRegistry.INSTANCE.register(new ServerPort().setName("serverport"));
        TagRegistry.INSTANCE.register(new Ping().setName("ping"));
        TagRegistry.INSTANCE.register(new PingIcon().setName("pingicon"));
    }

    public static class PingIcon
    extends TagMisc {
        @Override
        public String getValue() {
            try {
                NetworkPlayerInfo playerInfo = minecraft.func_147114_u().func_175102_a(player.func_110124_au());
                int responseTime = playerInfo.func_178853_c();
                int pingIndex = 4;
                if (responseTime < 0) {
                    pingIndex = 5;
                } else if (responseTime < 150) {
                    pingIndex = 0;
                } else if (responseTime < 300) {
                    pingIndex = 1;
                } else if (responseTime < 600) {
                    pingIndex = 2;
                } else if (responseTime < 1000) {
                    pingIndex = 3;
                }
                InfoIcon icon = new InfoIcon("textures/gui/icons.png");
                icon.setDisplayDimensions(0, 0, 10, 8);
                icon.setTextureData(0, 176 + pingIndex * 8, 10, 8, 256, 256);
                info.add(icon);
                return PingIcon.getIconTag(icon);
            }
            catch (Exception exception) {
                return "-1";
            }
        }
    }

    public static class Ping
    extends TagMisc {
        @Override
        public String getValue() {
            try {
                NetworkPlayerInfo playerInfo = minecraft.func_147114_u().func_175102_a(player.func_110124_au());
                return String.valueOf(playerInfo.func_178853_c());
            }
            catch (Exception exception) {
                return "-1";
            }
        }
    }

    public static class ServerPort
    extends TagMisc {
        @Override
        public String getValue() {
            String str = ServerPort.player.field_71174_a.func_147298_b().func_74430_c().toString();
            int i = str.indexOf("/");
            if (i < 0) {
                return "-1";
            }
            return str.substring(str.indexOf(":") + 1);
        }
    }

    public static class ServerIP
    extends TagMisc {
        @Override
        public String getValue() {
            String str = ServerIP.player.field_71174_a.func_147298_b().func_74430_c().toString();
            int i = str.indexOf("/");
            if (i < 0) {
                return "127.0.0.1";
            }
            return str.substring(i + 1, str.indexOf(":"));
        }
    }

    public static class ServerName
    extends TagMisc {
        @Override
        public String getValue() {
            String str = ServerName.player.field_71174_a.func_147298_b().func_74430_c().toString();
            int i = str.indexOf("/");
            if (i < 0) {
                return "localhost";
            }
            if (i == 0) {
                return str.substring(i + 1, str.indexOf(":"));
            }
            return str.substring(0, i);
        }
    }

    public static class Server
    extends TagMisc {
        @Override
        public String getValue() {
            String str = Server.player.field_71174_a.func_147298_b().func_74430_c().toString();
            int i = str.indexOf("/");
            int j = str.indexOf(":");
            if (i < 0) {
                return "localhost";
            }
            String name = i == 0 ? str.substring(i + 1, j) : str.substring(0, i);
            String port = str.substring(j + 1);
            return name + (port.equals("25565") ? "" : ":" + port);
        }
    }

    public static class LoadedChunks
    extends TagMisc {
        @Override
        public String getValue() {
            return String.valueOf(-1);
        }
    }

    public static class EntitiesTotal
    extends TagMisc {
        @Override
        public String getValue() {
            return String.valueOf(EntitiesTotal.minecraft.field_71438_f.field_72748_H);
        }
    }

    public static class EntitiesRendered
    extends TagMisc {
        @Override
        public String getValue() {
            return String.valueOf(EntitiesRendered.minecraft.field_71438_f.field_72749_I);
        }
    }

    public static class ResourcePack
    extends TagMisc {
        @Override
        public String getValue() {
            List repositoryEntries = resourcePackRepository.func_110613_c();
            if (repositoryEntries.size() > 0) {
                return ((ResourcePackRepository.Entry)repositoryEntries.get(0)).func_110515_d();
            }
            return ResourcePack.resourcePackRepository.field_110620_b.func_130077_b();
        }
    }

    public static class FPS
    extends TagMisc {
        @Override
        public String getValue() {
            return String.valueOf(Minecraft.func_175610_ah());
        }
    }

    public static class MemoryUsed
    extends TagMisc {
        @Override
        public String getValue() {
            return String.valueOf(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        }
    }

    public static class MemoryFree
    extends TagMisc {
        @Override
        public String getValue() {
            return String.valueOf(Runtime.getRuntime().freeMemory());
        }
    }

    public static class MemoryTotal
    extends TagMisc {
        @Override
        public String getValue() {
            return String.valueOf(Runtime.getRuntime().totalMemory());
        }
    }

    public static class MemoryMaximum
    extends TagMisc {
        @Override
        public String getValue() {
            return String.valueOf(Runtime.getRuntime().maxMemory());
        }
    }
}

