/*
 * Decompiled with CFR 0.152.
 */
package com.eugenearch.tinkertoolcasts.items;

import com.eugenearch.tinkertoolcasts.util.Constants;
import com.eugenearch.tinkertoolcasts.util.registry.ItemRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class ItemCast
extends Item {
    protected float timeModifier;
    protected int color;
    private final ItemStack castIngot;
    private final ItemStack castNugget;
    private final ItemStack castGem;
    private final ItemStack castPlate;
    private final ItemStack castGear;

    public ItemCast(String name, float timeModifier, int color) {
        this.timeModifier = timeModifier;
        this.color = color;
        this.castIngot = new ItemStack((Item)this, 1, 0);
        this.castNugget = new ItemStack((Item)this, 1, 1);
        this.castGem = new ItemStack((Item)this, 1, 2);
        this.castPlate = new ItemStack((Item)this, 1, 3);
        this.castGear = new ItemStack((Item)this, 1, 4);
        ResourceLocation RS = new ResourceLocation("tinkertoolcasts", name);
        this.field_77787_bX = true;
        this.setRegistryName(RS);
        this.func_77655_b(name);
        this.func_77637_a((CreativeTabs)TinkerRegistry.tabSmeltery);
        ItemRegistry.ITEMS.add(this);
    }

    public void initCastingRecipes() {
        List castingRecipes = TinkerRegistry.getAllTableCastingRecipes();
        for (ICastingRecipe recipe : castingRecipes) {
            if (!(recipe instanceof CastingRecipe)) continue;
            CastingRecipe castingRecipe = (CastingRecipe)recipe;
            if (!(castingRecipe.cast instanceof RecipeMatch.ItemCombination)) continue;
            RecipeMatch.ItemCombination itemCombination = (RecipeMatch.ItemCombination)castingRecipe.cast;
            List inputs = itemCombination.getInputs();
            for (ItemStack input : inputs) {
                if (ItemStack.func_179545_c((ItemStack)input, (ItemStack)TinkerSmeltery.castIngot)) {
                    this.registerTableCasting(castingRecipe, this.castIngot, this.getModifiedTime(recipe.getTime()));
                }
                if (ItemStack.func_179545_c((ItemStack)input, (ItemStack)TinkerSmeltery.castNugget)) {
                    this.registerTableCasting(castingRecipe, this.castNugget, this.getModifiedTime(recipe.getTime()));
                }
                if (ItemStack.func_179545_c((ItemStack)input, (ItemStack)TinkerSmeltery.castGem)) {
                    this.registerTableCasting(castingRecipe, this.castGem, this.getModifiedTime(recipe.getTime()));
                }
                if (ItemStack.func_179545_c((ItemStack)input, (ItemStack)TinkerSmeltery.castPlate)) {
                    this.registerTableCasting(castingRecipe, this.castPlate, this.getModifiedTime(recipe.getTime()));
                }
                if (!ItemStack.func_179545_c((ItemStack)input, (ItemStack)TinkerSmeltery.castGear)) continue;
                this.registerTableCasting(castingRecipe, this.castGear, this.getModifiedTime(recipe.getTime()));
            }
        }
    }

    private void registerTableCasting(CastingRecipe castingRecipe, ItemStack inputCast, int time) {
        ItemStack output = castingRecipe.getResult();
        Fluid fluid = castingRecipe.getFluid().getFluid();
        int liquidAmount = castingRecipe.getFluidAmount();
        if (output == null || output.func_190926_b()) {
            return;
        }
        if (fluid == null) {
            return;
        }
        if (liquidAmount <= 0) {
            return;
        }
        CastingRecipe recipeCasting = new CastingRecipe(output, RecipeMatch.ofNBT((ItemStack)inputCast), fluid, liquidAmount, time);
        TinkerRegistry.registerTableCasting((ICastingRecipe)recipeCasting);
    }

    public int getColor() {
        return this.color;
    }

    private int getModifiedTime(int defaultTime) {
        return Math.max((int)((float)defaultTime * this.timeModifier), Constants.MIN_CAST_TIME);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_74837_a((String)("item." + this.getRegistryName().func_110623_a() + ".tooltip"), (Object[])new Object[]{100 - Math.round(this.timeModifier * 100.0f)}));
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_82837_s()) {
            return super.func_77653_i(stack);
        }
        switch (stack.func_77952_i()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return I18n.func_74838_a((String)("item." + this.getRegistryName().func_110623_a() + "." + stack.func_77952_i() + ".name")).trim();
            }
        }
        return super.func_77653_i(stack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        super.func_150895_a(tab, items);
        if (tab.equals(this.func_77640_w())) {
            for (int i = 1; i <= 4; ++i) {
                items.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }
}

