/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.core.util.vector;

import com.github.lunatrius.core.util.vector.Vector2d;
import com.github.lunatrius.core.util.vector.Vector2f;

public class Vector2i {
    public int x;
    public int y;

    public Vector2i() {
        this(0, 0);
    }

    public Vector2i(Vector2i vec) {
        this(vec.x, vec.y);
    }

    public Vector2i(int num) {
        this(num, num);
    }

    public Vector2i(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final void setX(int x) {
        this.x = x;
    }

    public final void setY(int y) {
        this.y = y;
    }

    public Vector2i set(Vector2i vec) {
        return this.set(vec.x, vec.y);
    }

    public Vector2i set(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public final double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public int lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public final double lengthTo(Vector2i vec) {
        return Math.sqrt(this.lengthSquaredTo(vec));
    }

    public int lengthSquaredTo(Vector2i vec) {
        return this.pow2(this.x - vec.x) + this.pow2(this.y - vec.y);
    }

    protected final int pow2(int num) {
        return num * num;
    }

    public final Vector2i normalize() {
        double len = this.length();
        if (len != 0.0) {
            return this.scale(1.0 / len);
        }
        return this;
    }

    public Vector2i negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public double dot(Vector2i vec) {
        return this.x * vec.x + this.y * vec.y;
    }

    public Vector2i scale(double scale) {
        this.x = (int)((double)this.x * scale);
        this.y = (int)((double)this.y * scale);
        return this;
    }

    public Vector2i add(Vector2i vec) {
        this.x += vec.x;
        this.y += vec.y;
        return this;
    }

    public Vector2i add(int x, int y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vector2i sub(Vector2i vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        return this;
    }

    public Vector2i sub(int x, int y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public Vector2f toVector2f() {
        return new Vector2f(this.x, this.y);
    }

    public Vector2f toVector2f(Vector2f vec) {
        return vec.set(this.x, this.y);
    }

    public Vector2d toVector2d() {
        return new Vector2d(this.x, this.y);
    }

    public Vector2d toVector2d(Vector2d vec) {
        return vec.set(this.x, this.y);
    }

    public Vector2i clone() {
        return new Vector2i(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof Vector2i && this.equals((Vector2i)obj);
    }

    public boolean equals(Vector2i vec) {
        return this.x == vec.x && this.y == vec.y;
    }

    public String toString() {
        return String.format("[%s, %s]", this.x, this.y);
    }
}

