/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.bcoreprocessing.lib.recipes;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.ndrei.bcoreprocessing.api.recipes.IFluidProcessorRecipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\bH\u0016J&\u0010\f\u001a\u0018\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00050\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00030\r2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u001e\u0010\u0011\u001a\u0018\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00050\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00030\rH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u001e\u0010\u0017\u001a\u00020\b*\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/ndrei/bcoreprocessing/lib/recipes/FluidProcessorRecipe;", "Lnet/ndrei/bcoreprocessing/api/recipes/IFluidProcessorRecipe;", "input", "Lnet/minecraftforge/fluids/FluidStack;", "output", "Lnet/minecraft/item/ItemStack;", "residue", "ticks", "", "(Lnet/minecraftforge/fluids/FluidStack;Lnet/minecraft/item/ItemStack;Lnet/minecraftforge/fluids/FluidStack;I)V", "getInputForTick", "tick", "getOutputForTick", "Lkotlin/Pair;", "kotlin.jvm.PlatformType", "getProcessingTicks", "getRecipeInput", "getRecipeOutput", "isInput", "", "stack", "ignoreSize", "processInput", "atTick", "bc-ore-processing"})
public final class FluidProcessorRecipe
implements IFluidProcessorRecipe {
    private final FluidStack input;
    private final ItemStack output;
    private final FluidStack residue;
    private final int ticks;

    @Override
    public boolean isInput(@NotNull FluidStack stack, boolean ignoreSize) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return Intrinsics.areEqual((Object)stack.getFluid(), (Object)this.input.getFluid()) && (ignoreSize || stack.amount >= this.input.amount);
    }

    @Override
    public int getProcessingTicks() {
        return this.ticks;
    }

    @Override
    @NotNull
    public FluidStack getRecipeInput() {
        FluidStack fluidStack = this.input.copy();
        if (fluidStack == null) {
            Intrinsics.throwNpe();
        }
        return fluidStack;
    }

    @Override
    @NotNull
    public Pair<ItemStack, FluidStack> getRecipeOutput() {
        FluidStack fluidStack = this.residue;
        return new Pair((Object)this.output.func_77946_l(), fluidStack != null ? fluidStack.copy() : null);
    }

    @Override
    @Nullable
    public FluidStack processInput(@NotNull FluidStack stack) {
        FluidStack fluidStack;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (!this.isInput(stack, true)) {
            fluidStack = null;
        } else {
            stack.amount -= this.input.amount;
            fluidStack = this.input.copy();
        }
        return fluidStack;
    }

    @Override
    @NotNull
    public Pair<ItemStack, FluidStack> getOutputForTick(int tick) {
        Pair pair;
        int n;
        int n2 = n = tick;
        if (Integer.MIN_VALUE <= n2 && -1 >= n2) {
            pair = new Pair((Object)ItemStack.field_190927_a, null);
        } else {
            int n3 = n;
            if (this.ticks <= n3 && Integer.MAX_VALUE >= n3) {
                pair = new Pair((Object)ItemStack.field_190927_a, null);
            } else {
                FluidStack fluidStack;
                Pair pair2;
                Pair pair3 = pair2;
                pair = pair2;
                ItemStack itemStack = this.ticks == tick + 1 ? this.output.func_77946_l() : ItemStack.field_190927_a;
                FluidStack fluidStack2 = this.residue;
                if (fluidStack2 != null) {
                    FluidStack fluidStack3 = fluidStack2;
                    ItemStack itemStack2 = itemStack;
                    Pair pair4 = pair3;
                    Pair pair5 = pair;
                    FluidStack it = fluidStack3;
                    int amount = this.atTick(it, tick + 1, this.ticks) - this.atTick(it, tick, this.ticks);
                    FluidStack fluidStack4 = amount > 0 ? new FluidStack(it.getFluid(), amount) : null;
                    pair = pair5;
                    pair3 = pair4;
                    itemStack = itemStack2;
                    fluidStack = fluidStack4;
                } else {
                    fluidStack = null;
                }
                pair3((Object)itemStack, fluidStack);
            }
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public FluidStack getInputForTick(int tick) {
        void var3_3;
        FluidStack fluidStack;
        FluidStack it = fluidStack = this.input.copy();
        it.amount = this.atTick(this.input, tick + 1, this.ticks) - this.atTick(this.input, tick, this.ticks);
        it = fluidStack;
        return it.amount == 0 ? null : var3_3;
    }

    private final int atTick(@Nullable FluidStack $receiver, int tick, int ticks) {
        return $receiver == null || tick == 0 ? 0 : (int)((float)$receiver.amount / (float)ticks * (float)tick);
    }

    public FluidProcessorRecipe(@NotNull FluidStack input, @NotNull ItemStack output, @Nullable FluidStack residue, int ticks) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        this.input = input;
        this.output = output;
        this.residue = residue;
        this.ticks = ticks;
    }
}

