/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.bcoreprocessing.lib.recipes;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.ndrei.bcoreprocessing.api.recipes.IOreProcessorRecipe;
import net.ndrei.bcoreprocessing.lib.KotlinmagicKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\n\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u001b\u0010\f\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00030\u00030\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\bH\u0016J\u0018\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u001e\u0010\u0017\u001a\u00020\b*\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/ndrei/bcoreprocessing/lib/recipes/OreProcessorRecipe;", "Lnet/ndrei/bcoreprocessing/api/recipes/IOreProcessorRecipe;", "input", "Lnet/minecraft/item/ItemStack;", "outputs", "Lkotlin/Pair;", "Lnet/minecraftforge/fluids/FluidStack;", "ticks", "", "(Lnet/minecraft/item/ItemStack;Lkotlin/Pair;I)V", "getOutputForTick", "tick", "getPossibleInputs", "", "kotlin.jvm.PlatformType", "()[Lnet/minecraft/item/ItemStack;", "getProcessingTicks", "getTotalOutput", "isInput", "", "stack", "ignoreSize", "processInput", "atTick", "bc-ore-processing"})
public final class OreProcessorRecipe
implements IOreProcessorRecipe {
    private final ItemStack input;
    private final Pair<FluidStack, FluidStack> outputs;
    private final int ticks;

    @Override
    public boolean isInput(@NotNull ItemStack stack, boolean ignoreSize) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return KotlinmagicKt.equalsIgnoreSize(this.input, stack) && (ignoreSize || this.input.func_190916_E() <= stack.func_190916_E());
    }

    @Override
    public int getProcessingTicks() {
        return this.ticks;
    }

    @Override
    @NotNull
    public ItemStack[] getPossibleInputs() {
        return new ItemStack[]{this.input.func_77946_l()};
    }

    @Override
    @NotNull
    public Pair<FluidStack, FluidStack> getTotalOutput() {
        Pair<FluidStack, FluidStack> pair;
        Pair<FluidStack, FluidStack> it = pair = this.outputs;
        FluidStack fluidStack = (FluidStack)it.getFirst();
        FluidStack fluidStack2 = (FluidStack)it.getSecond();
        return new Pair(fluidStack != null ? fluidStack.copy() : null, fluidStack2 != null ? fluidStack2.copy() : null);
    }

    @Override
    @NotNull
    public ItemStack processInput(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (!this.isInput(stack, false)) {
            throw (Throwable)new Exception("Invalid input item stack: " + stack + '.');
        }
        ItemStack result = KotlinmagicKt.copyWithSize(stack, this.input.func_190916_E());
        stack.func_190918_g(this.input.func_190916_E());
        ItemStack itemStack = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"result");
        return itemStack;
    }

    @Override
    @NotNull
    public Pair<FluidStack, FluidStack> getOutputForTick(int tick) {
        Pair pair;
        int n;
        int n2 = n = tick;
        if (Integer.MIN_VALUE <= n2 && -1 >= n2) {
            pair = new Pair(null, null);
        } else {
            int n3 = n;
            if (this.ticks <= n3 && Integer.MAX_VALUE >= n3) {
                pair = new Pair(null, null);
            } else {
                FluidStack fluidStack;
                FluidStack fluidStack2;
                Pair<FluidStack, FluidStack> pair2;
                Pair<FluidStack, FluidStack> it = pair2 = this.outputs;
                int firstAmount = this.atTick((FluidStack)it.getFirst(), tick + 1, this.ticks) - this.atTick((FluidStack)it.getFirst(), tick, this.ticks);
                int secondAmount = this.atTick((FluidStack)it.getSecond(), tick + 1, this.ticks) - this.atTick((FluidStack)it.getSecond(), tick, this.ticks);
                if (firstAmount > 0 && it.getFirst() != null) {
                    Object object = it.getFirst();
                    if (object == null) {
                        Intrinsics.throwNpe();
                    }
                    fluidStack2 = new FluidStack(((FluidStack)object).getFluid(), firstAmount);
                } else {
                    fluidStack2 = null;
                }
                if (secondAmount > 0 && it.getSecond() != null) {
                    Object object = it.getSecond();
                    if (object == null) {
                        Intrinsics.throwNpe();
                    }
                    fluidStack = new FluidStack(((FluidStack)object).getFluid(), secondAmount);
                } else {
                    fluidStack = null;
                }
                pair = new Pair((Object)fluidStack2, fluidStack);
            }
        }
        return pair;
    }

    private final int atTick(@Nullable FluidStack $receiver, int tick, int ticks) {
        return $receiver == null || tick == 0 ? 0 : (int)((float)$receiver.amount / (float)ticks * (float)tick);
    }

    public OreProcessorRecipe(@NotNull ItemStack input, @NotNull Pair<? extends FluidStack, ? extends FluidStack> outputs, int ticks) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull(outputs, (String)"outputs");
        this.input = input;
        this.outputs = outputs;
        this.ticks = ticks;
    }
}

