/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.bcoreprocessing.lib.recipes;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.ndrei.bcoreprocessing.BCOreProcessing;
import net.ndrei.bcoreprocessing.api.recipes.IOreProcessorRecipe;
import net.ndrei.bcoreprocessing.api.recipes.IOreProcessorRecipeManager;
import net.ndrei.bcoreprocessing.lib.fluids.FluidsRegistry;
import net.ndrei.bcoreprocessing.lib.recipes.OreProcessorRecipe;
import net.ndrei.bcoreprocessing.lib.recipes.OreProcessorRecipeManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0016\u0010\u000e\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u0006\u0010\u0019\u001a\u00020\u0017R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/ndrei/bcoreprocessing/lib/recipes/OreProcessorRecipeManager;", "Lnet/ndrei/bcoreprocessing/api/recipes/IOreProcessorRecipeManager;", "()V", "allRecipes", "", "Lnet/ndrei/bcoreprocessing/api/recipes/IOreProcessorRecipe;", "getAllRecipes", "()Ljava/util/List;", "recipes", "", "createRecipe", "Lnet/ndrei/bcoreprocessing/lib/recipes/OreProcessorRecipe;", "input", "Lnet/minecraft/item/ItemStack;", "output", "Lkotlin/Pair;", "Lnet/minecraftforge/fluids/FluidStack;", "ticks", "", "findFirstRecipe", "ignoreSize", "", "registerRecipe", "", "recipe", "registerRecipes", "bc-ore-processing"})
public final class OreProcessorRecipeManager
implements IOreProcessorRecipeManager {
    private static final List<IOreProcessorRecipe> recipes;
    public static final OreProcessorRecipeManager INSTANCE;

    @Override
    public void registerRecipe(@NotNull IOreProcessorRecipe recipe) {
        Intrinsics.checkParameterIsNotNull((Object)recipe, (String)"recipe");
        recipes.add(recipe);
    }

    @Override
    @NotNull
    public OreProcessorRecipe createRecipe(@NotNull ItemStack input, @NotNull Pair<? extends FluidStack, ? extends FluidStack> output, int ticks) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull(output, (String)"output");
        return new OreProcessorRecipe(input, output, ticks);
    }

    @Override
    @Nullable
    public IOreProcessorRecipe findFirstRecipe(@NotNull ItemStack input, boolean ignoreSize) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Iterable $receiver$iv = recipes;
            for (Object element$iv : $receiver$iv) {
                IOreProcessorRecipe it = (IOreProcessorRecipe)element$iv;
                if (!it.isInput(input, ignoreSize)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final void registerRecipes() {
        BCOreProcessing.INSTANCE.getConfigHelper().readExtraRecipesFile("ore_processor", (Function1<? super JsonObject, Unit>)((Function1)registerRecipes.1.INSTANCE));
        Iterable $receiver$iv = FluidsRegistry.INSTANCE.getFluidToProcess();
        for (Object element$iv : $receiver$iv) {
            NonNullList ores;
            FluidsRegistry.ProcessedFluidInfo it = (FluidsRegistry.ProcessedFluidInfo)element$iv;
            if (FluidRegistry.getFluid((String)("bcop-" + it.getFluidName() + "-searing")) == null) {
                continue;
            }
            NonNullList nonNullList = ores = OreDictionary.getOres((String)it.getOreName());
            Intrinsics.checkExpressionValueIsNotNull((Object)nonNullList, (String)"ores");
            Collection collection = (Collection)nonNullList;
            if (!(!collection.isEmpty())) continue;
            NonNullList nonNullList2 = OreDictionary.getOres((String)it.getIngotName());
            Intrinsics.checkExpressionValueIsNotNull((Object)nonNullList2, (String)"OreDictionary.getOres(it.ingotName)");
            if ((ItemStack)CollectionsKt.firstOrNull((List)((List)nonNullList2)) == null) {
                continue;
            }
            Iterable $receiver$iv2 = (Iterable)ores;
            for (Object element$iv2 : $receiver$iv2) {
                Fluid fluid;
                ItemStack it2;
                ItemStack itemStack = it2 = (ItemStack)element$iv2;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"it");
                INSTANCE.registerSimpleRecipe(itemStack, (Pair<? extends FluidStack, ? extends FluidStack>)new Pair((Object)new FluidStack(fluid, 1000), (Object)new FluidStack((Fluid)FluidsRegistry.INSTANCE.getGASEOUS_LAVA()[2], 125)), 40);
            }
        }
    }

    @NotNull
    public final List<IOreProcessorRecipe> getAllRecipes() {
        return CollectionsKt.toList((Iterable)recipes);
    }

    private OreProcessorRecipeManager() {
    }

    static {
        OreProcessorRecipeManager oreProcessorRecipeManager;
        INSTANCE = oreProcessorRecipeManager = new OreProcessorRecipeManager();
        recipes = new ArrayList();
    }

    @Override
    public void registerSimpleRecipe(@NotNull ItemStack input, @NotNull Pair<? extends FluidStack, ? extends FluidStack> output, int ticks) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull(output, (String)"output");
        IOreProcessorRecipeManager.DefaultImpls.registerSimpleRecipe(this, input, output, ticks);
    }
}

