/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.bcoreprocessing.machines;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.mj.MjBattery;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.net.IPayloadReceiver;
import buildcraft.lib.net.IPayloadWriter;
import buildcraft.lib.net.MessageUpdateTile;
import buildcraft.lib.net.PacketBufferBC;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.bcoreprocessing.BCOreProcessing;
import net.ndrei.bcoreprocessing.lib.KotlinmagicKt;
import net.ndrei.bcoreprocessing.lib.fluids.FluidTankEx;
import net.ndrei.bcoreprocessing.lib.render.IFluidStacksHolder;
import net.ndrei.bcoreprocessing.lib.render.IItemStackHolder;
import net.ndrei.bcoreprocessing.machines.BaseOreProcessorBlock;
import net.ndrei.bcoreprocessing.machines.BaseOreProcessorMachine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00c9\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n*\u0003#\u001a\r\b&\u0018\u0000 d2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006:\u0001dB\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u000201H\u0014J\u0010\u00102\u001a\u00020\u00182\u0006\u00103\u001a\u000204H\u0014J\u0010\u00105\u001a\u00020\u00182\u0006\u00100\u001a\u000201H\u0014J\u0010\u00106\u001a\u00020\u00182\u0006\u00103\u001a\u000204H\u0014J\u0012\u00107\u001a\u00020\u00182\b\u00108\u001a\u0004\u0018\u000109H\u0016J-\u0010:\u001a\u0004\u0018\u0001H;\"\u0004\b\u0000\u0010;2\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H;0=2\b\u0010>\u001a\u0004\u0018\u000109H\u0016\u00a2\u0006\u0002\u0010?J,\u0010@\u001a\u00020A2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020*0C2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020*0C2\u0006\u00108\u001a\u000209H\u0016J\u0011\u0010E\u001a\b\u0012\u0004\u0012\u0002010F\u00a2\u0006\u0002\u0010GJ\b\u0010H\u001a\u000204H\u0016J\u0010\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u000204H\u0014J\u0006\u0010L\u001a\u00020JJ\b\u0010M\u001a\u00020NH\u0016J\u001e\u0010O\u001a\u00020\u00182\n\u0010<\u001a\u0006\u0012\u0002\b\u00030=2\b\u0010>\u001a\u0004\u0018\u000109H\u0016J\b\u0010P\u001a\u00020AH\u0014J\b\u0010Q\u001a\u00020\u0018H\u0014J\u0014\u0010R\u001a\u00020A2\n\b\u0002\u0010S\u001a\u0004\u0018\u00010*H\u0004J\u0010\u0010T\u001a\u00020A2\u0006\u0010U\u001a\u00020NH\u0016J\u001a\u0010V\u001a\u0004\u0018\u00010W2\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020[H\u0016J \u0010\\\u001a\u00020A2\u0006\u0010S\u001a\u00020*2\u0006\u0010]\u001a\u00020.2\u0006\u0010^\u001a\u00020\u0005H\u0004J\b\u0010_\u001a\u00020AH\u0002J\b\u0010`\u001a\u00020AH\u0002J\u0006\u0010a\u001a\u00020AJ\u0010\u0010b\u001a\u00020N2\u0006\u0010U\u001a\u00020NH\u0016J\f\u0010c\u001a\u00020**\u000204H\u0002J\f\u0010c\u001a\u00020**\u000201H\u0002R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0010\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010$R\u0014\u0010%\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0012R\u000e\u0010'\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u00050,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010-\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020.0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Lnet/ndrei/bcoreprocessing/machines/BaseOreProcessorMachine;", "Lnet/minecraft/tileentity/TileEntity;", "Lnet/minecraft/util/ITickable;", "Lnet/ndrei/bcoreprocessing/lib/render/IItemStackHolder;", "Lnet/ndrei/bcoreprocessing/lib/render/IFluidStacksHolder;", "Lbuildcraft/lib/net/IPayloadReceiver;", "Lbuildcraft/api/tiles/IDebuggable;", "()V", "battery", "Lbuildcraft/api/mj/MjBattery;", "getBattery", "()Lbuildcraft/api/mj/MjBattery;", "batteryReceiver", "net/ndrei/bcoreprocessing/machines/BaseOreProcessorMachine$batteryReceiver$1", "Lnet/ndrei/bcoreprocessing/machines/BaseOreProcessorMachine$batteryReceiver$1;", "fluidTank", "Lnet/ndrei/bcoreprocessing/lib/fluids/FluidTankEx;", "getFluidTank", "()Lnet/ndrei/bcoreprocessing/lib/fluids/FluidTankEx;", "itemHandler", "Lnet/minecraftforge/items/ItemStackHandler;", "getItemHandler", "()Lnet/minecraftforge/items/ItemStackHandler;", "lastWorkingState", "", "mainFluidCap", "net/ndrei/bcoreprocessing/machines/BaseOreProcessorMachine$mainFluidCap$1", "Lnet/ndrei/bcoreprocessing/machines/BaseOreProcessorMachine$mainFluidCap$1;", "renderAngle", "", "getRenderAngle", "()F", "setRenderAngle", "(F)V", "residueFluidCap", "net/ndrei/bcoreprocessing/machines/BaseOreProcessorMachine$residueFluidCap$1", "Lnet/ndrei/bcoreprocessing/machines/BaseOreProcessorMachine$residueFluidCap$1;", "residueTank", "getResidueTank", "syncEverything", "syncOnNextTick", "", "", "syncReceivers", "", "syncWriters", "Lbuildcraft/lib/net/IPayloadWriter;", "canDrainFluidType", "fluid", "Lnet/minecraftforge/fluids/FluidStack;", "canExtractItem", "item", "Lnet/minecraft/item/ItemStack;", "canFillFluidType", "canInsertItem", "canReceiveEnergyOnSide", "side", "Lnet/minecraft/util/EnumFacing;", "getCapability", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "getDebugInfo", "", "left", "", "right", "getFluidStacks", "", "()[Lnet/minecraftforge/fluids/FluidStack;", "getItemStack", "getItemStackLimit", "", "stack", "getTotalCapacity", "getUpdateTag", "Lnet/minecraft/nbt/NBTTagCompound;", "hasCapability", "innerUpdate", "isWorking", "markForUpdate", "key", "readFromNBT", "compound", "receivePayload", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "ctx", "Lnet/minecraftforge/fml/common/network/simpleimpl/MessageContext;", "buffer", "Lbuildcraft/lib/net/PacketBufferBC;", "registerSyncPart", "writer", "receiver", "sendPayload", "testWorkingState", "update", "writeToNBT", "describe", "Companion", "bc-ore-processing"})
public abstract class BaseOreProcessorMachine
extends TileEntity
implements ITickable,
IItemStackHolder,
IFluidStacksHolder,
IPayloadReceiver,
IDebuggable {
    @NotNull
    private final MjBattery battery = new MjBattery(this, MjAPI.ONE_MINECRAFT_JOULE * (long)1024){
        private long lastPower;
        final /* synthetic */ BaseOreProcessorMachine this$0;

        public void tick(@Nullable World world, @Nullable BlockPos position) {
            super.tick(world, position);
            if (this.getStored() != this.lastPower) {
                this.lastPower = this.getStored();
                this.this$0.markForUpdate("mj_battery");
            }
        }
        {
            this.this$0 = $outer;
            super($super_call_param$1);
            this.lastPower = -1L;
        }
    };
    private final batteryReceiver.1 batteryReceiver = new IMjReceiver(this){
        final /* synthetic */ BaseOreProcessorMachine this$0;

        public boolean canConnect(@NotNull IMjConnector p0) {
            Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
            return true;
        }

        public long getPowerRequested() {
            return this.this$0.getBattery().isFull() ? 0L : this.this$0.getBattery().getCapacity() - this.this$0.getBattery().getStored();
        }

        public long receivePower(long p0, boolean p1) {
            return this.this$0.getBattery().addPower(p0, p1);
        }
        {
            this.this$0 = $outer;
        }
    };
    @NotNull
    private final ItemStackHandler itemHandler = new ItemStackHandler(this, 1){
        final /* synthetic */ BaseOreProcessorMachine this$0;

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack itemStack = this.getStackInSlot(slot);
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"this.getStackInSlot(slot)");
            return this.this$0.canExtractItem(itemStack) ? super.extractItem(slot, amount, simulate) : ItemStack.field_190927_a;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            return this.this$0.canInsertItem(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            return this.this$0.getItemStackLimit(stack);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            this.this$0.markForUpdate("item_handler");
        }
        {
            this.this$0 = $outer;
            super($super_call_param$1);
        }
    };
    @NotNull
    private final FluidTankEx fluidTank = new FluidTankEx(this, 9000){
        final /* synthetic */ BaseOreProcessorMachine this$0;

        public boolean canFillFluidType(@Nullable FluidStack fluid) {
            return fluid != null && this.this$0.canFillFluidType(fluid);
        }

        public boolean canDrainFluidType(@Nullable FluidStack fluid) {
            return fluid != null && this.this$0.canDrainFluidType(fluid);
        }

        protected void onContentsChanged() {
            super.onContentsChanged();
            this.this$0.markForUpdate("fluid_tank");
        }
        {
            this.this$0 = $outer;
            super($super_call_param$1);
        }
    };
    @NotNull
    private final FluidTankEx residueTank = new FluidTankEx(this, 6000){
        final /* synthetic */ BaseOreProcessorMachine this$0;

        public boolean canFillFluidType(@Nullable FluidStack fluid) {
            return false;
        }

        protected void onContentsChanged() {
            super.onContentsChanged();
            this.this$0.markForUpdate("residue_Tank");
        }
        {
            this.this$0 = $outer;
            super($super_call_param$1);
        }
    };
    private boolean syncEverything;
    private final Map<String, IPayloadWriter> syncWriters;
    private final Map<String, IPayloadReceiver> syncReceivers;
    private final Set<String> syncOnNextTick;
    private boolean lastWorkingState;
    private float renderAngle;
    private final residueFluidCap.1 residueFluidCap;
    private final mainFluidCap.1 mainFluidCap;
    private static final String STORAGE_FLUID_TANK = "fluid_tank";
    private static final String STORAGE_RESIDUE_TANK = "residue_Tank";
    private static final String STORAGE_ITEM_STACK = "item_handler";
    private static final String STORAGE_BATTERY = "mj_battery";
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final MjBattery getBattery() {
        return this.battery;
    }

    @NotNull
    protected final ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @NotNull
    protected final FluidTankEx getFluidTank() {
        return this.fluidTank;
    }

    @NotNull
    protected final FluidTankEx getResidueTank() {
        return this.residueTank;
    }

    protected boolean canInsertItem(@NotNull ItemStack item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        return false;
    }

    protected boolean canExtractItem(@NotNull ItemStack item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        return false;
    }

    protected boolean canFillFluidType(@NotNull FluidStack fluid) {
        Intrinsics.checkParameterIsNotNull((Object)fluid, (String)"fluid");
        return false;
    }

    protected boolean canDrainFluidType(@NotNull FluidStack fluid) {
        Intrinsics.checkParameterIsNotNull((Object)fluid, (String)"fluid");
        return false;
    }

    protected int getItemStackLimit(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return 1;
    }

    @Override
    @NotNull
    public ItemStack getItemStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    @Override
    public float getRenderAngle() {
        return this.renderAngle;
    }

    @Override
    public void setRenderAngle(float f) {
        this.renderAngle = f;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final FluidStack[] getFluidStacks() {
        void $receiver$iv$iv;
        Object $receiver$iv = new FluidTankEx[]{this.fluidTank, this.residueTank};
        FluidTankEx[] fluidTankExArray = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (int i = 0; i < ((void)$receiver$iv$iv$iv).length; ++i) {
            FluidStack fluidStack;
            void element$iv$iv$iv;
            void element$iv$iv;
            void it = element$iv$iv = (element$iv$iv$iv = $receiver$iv$iv$iv[i]);
            FluidStack fluidStack2 = it.getFluid();
            Object object = fluidStack2 != null ? fluidStack2.copy() : null;
            if (object == null) continue;
            FluidStack it$iv$iv = fluidStack = object;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        Object thisCollection$iv = $receiver$iv;
        FluidStack[] fluidStackArray = thisCollection$iv.toArray(new FluidStack[thisCollection$iv.size()]);
        if (fluidStackArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return fluidStackArray;
    }

    @Override
    public final int getTotalCapacity() {
        return this.fluidTank.getCapacity() + this.residueTank.getCapacity();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        if (this.canReceiveEnergyOnSide(facing)) {
            if (Intrinsics.areEqual(capability, (Object)MjAPI.CAP_RECEIVER)) return true;
            if (Intrinsics.areEqual(capability, (Object)MjAPI.CAP_CONNECTOR)) return true;
        }
        if (facing != null) {
            Intrinsics.checkExpressionValueIsNotNull((Object)EnumFacing.field_176754_o, (String)"EnumFacing.HORIZONTALS");
            if (ArraysKt.contains((Object[])EnumFacing.field_176754_o, (Object)facing)) {
                if (Intrinsics.areEqual(capability, (Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) return true;
            }
        }
        if (Intrinsics.areEqual((Object)facing, (Object)EnumFacing.UP)) {
            if (Intrinsics.areEqual(capability, (Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) return true;
        }
        if (Intrinsics.areEqual((Object)facing, (Object)EnumFacing.DOWN)) {
            if (Intrinsics.areEqual(capability, (Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) return true;
        }
        if (!super.hasCapability(capability, facing)) return false;
        return true;
    }

    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        if (this.canReceiveEnergyOnSide(facing) && Intrinsics.areEqual(capability, (Object)MjAPI.CAP_CONNECTOR)) {
            return (T)MjAPI.CAP_CONNECTOR.cast((Object)this.batteryReceiver);
        }
        if (this.canReceiveEnergyOnSide(facing) && Intrinsics.areEqual(capability, (Object)MjAPI.CAP_RECEIVER)) {
            return (T)MjAPI.CAP_RECEIVER.cast((Object)this.batteryReceiver);
        }
        if (facing != null) {
            Intrinsics.checkExpressionValueIsNotNull((Object)EnumFacing.field_176754_o, (String)"EnumFacing.HORIZONTALS");
            if (ArraysKt.contains((Object[])EnumFacing.field_176754_o, (Object)facing) && Intrinsics.areEqual(capability, (Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler);
            }
        }
        if (Intrinsics.areEqual((Object)facing, (Object)EnumFacing.UP) && Intrinsics.areEqual(capability, (Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.residueFluidCap);
        }
        if (Intrinsics.areEqual((Object)facing, (Object)EnumFacing.DOWN) && Intrinsics.areEqual(capability, (Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.mainFluidCap);
        }
        return (T)super.getCapability(capability, facing);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canReceiveEnergyOnSide(@Nullable EnumFacing side) {
        if (side == null) return false;
        Intrinsics.checkExpressionValueIsNotNull((Object)EnumFacing.field_176754_o, (String)"EnumFacing.HORIZONTALS");
        if (!ArraysKt.contains((Object[])EnumFacing.field_176754_o, (Object)side)) return false;
        return true;
    }

    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        KotlinmagicKt.deserialize((INBTSerializable<NBTTagCompound>)((INBTSerializable)this.fluidTank), compound, STORAGE_FLUID_TANK);
        KotlinmagicKt.deserialize((INBTSerializable<NBTTagCompound>)((INBTSerializable)this.residueTank), compound, STORAGE_RESIDUE_TANK);
        KotlinmagicKt.deserialize((INBTSerializable<NBTTagCompound>)((INBTSerializable)this.itemHandler), compound, STORAGE_ITEM_STACK);
        KotlinmagicKt.deserialize((INBTSerializable<NBTTagCompound>)((INBTSerializable)this.battery), compound, STORAGE_BATTERY);
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        NBTTagCompound nBTTagCompound;
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        NBTTagCompound it = nBTTagCompound = super.func_189515_b(compound);
        KotlinmagicKt.serialize((INBTSerializable<NBTTagCompound>)((INBTSerializable)this.fluidTank), compound, STORAGE_FLUID_TANK);
        KotlinmagicKt.serialize((INBTSerializable<NBTTagCompound>)((INBTSerializable)this.residueTank), compound, STORAGE_RESIDUE_TANK);
        KotlinmagicKt.serialize((INBTSerializable<NBTTagCompound>)((INBTSerializable)this.itemHandler), compound, STORAGE_ITEM_STACK);
        KotlinmagicKt.serialize((INBTSerializable<NBTTagCompound>)((INBTSerializable)this.battery), compound, STORAGE_BATTERY);
        NBTTagCompound nBTTagCompound2 = nBTTagCompound;
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound2, (String)"super.writeToNBT(compoun\u2026TORAGE_BATTERY)\n        }");
        return nBTTagCompound2;
    }

    protected final void registerSyncPart(@NotNull String key, @NotNull IPayloadWriter writer, @NotNull IPayloadReceiver receiver) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)receiver, (String)"receiver");
        Map<String, IPayloadWriter> map = this.syncWriters;
        IPayloadWriter iPayloadWriter = writer;
        map.put(key, iPayloadWriter);
        map = this.syncReceivers;
        iPayloadWriter = receiver;
        map.put(key, iPayloadWriter);
    }

    @NotNull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nBTTagCompound = super.func_189517_E_();
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"super.getUpdateTag()");
        return this.func_189515_b(nBTTagCompound);
    }

    protected final void markForUpdate(@Nullable String key) {
        block4: {
            World world;
            this.func_70296_d();
            World world2 = this.func_145831_w();
            if (world2 == null) break block4;
            World it = world = world2;
            if (!it.field_72995_K) {
                CharSequence charSequence = key;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    this.syncEverything = true;
                } else {
                    String string = key;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    this.syncOnNextTick.add(string);
                }
            }
        }
    }

    public static /* bridge */ /* synthetic */ void markForUpdate$default(BaseOreProcessorMachine baseOreProcessorMachine, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: markForUpdate");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        baseOreProcessorMachine.markForUpdate(string);
    }

    /*
     * WARNING - void declaration
     */
    private final void sendPayload() {
        PacketBufferBC payload = new PacketBufferBC(Unpooled.buffer());
        if (this.syncEverything) {
            payload.writeBoolean(true);
            payload.func_150786_a(this.func_189517_E_());
        } else {
            Collection collection = this.syncOnNextTick;
            if (!collection.isEmpty()) {
                void $receiver$iv$iv;
                payload.writeBoolean(false);
                Iterable $receiver$iv = this.syncOnNextTick;
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    String it = (String)element$iv$iv;
                    if (!this.syncWriters.containsKey(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List keys = (List)destination$iv$iv;
                $receiver$iv = keys;
                if ($receiver$iv.size() == 0) {
                    return;
                }
                $receiver$iv = keys;
                PacketBufferBC packetBufferBC = payload;
                int n = $receiver$iv.size();
                packetBufferBC.writeInt(n);
                $receiver$iv = keys;
                for (Object element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    payload.func_180714_a(it);
                    IPayloadWriter iPayloadWriter = this.syncWriters.get(it);
                    if (iPayloadWriter == null) {
                        Intrinsics.throwNpe();
                    }
                    iPayloadWriter.write(payload);
                }
            } else {
                return;
            }
        }
        this.syncEverything = false;
        this.syncOnNextTick.clear();
        MessageUtil.sendToAllWatching((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (IMessage)((IMessage)new MessageUpdateTile(this.func_174877_v(), payload)));
    }

    @Nullable
    public IMessage receivePayload(@NotNull MessageContext ctx, @NotNull PacketBufferBC buffer) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        boolean flag = buffer.readBoolean();
        if (flag) {
            NBTTagCompound nBTTagCompound = buffer.func_150793_b();
            if (nBTTagCompound != null) {
                NBTTagCompound nBTTagCompound2;
                NBTTagCompound it;
                NBTTagCompound nBTTagCompound3 = it = (nBTTagCompound2 = nBTTagCompound);
                Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound3, (String)"it");
                this.func_145839_a(nBTTagCompound3);
            }
        } else {
            int keys = buffer.readInt();
            Iterable $receiver$iv = (Iterable)RangesKt.until((int)0, (int)keys);
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int it = element$iv = ((IntIterator)iterator).nextInt();
                String key = buffer.readString();
                if (this.syncReceivers.containsKey(key)) {
                    IPayloadReceiver iPayloadReceiver = this.syncReceivers.get(key);
                    if (iPayloadReceiver == null) {
                        Intrinsics.throwNpe();
                    }
                    iPayloadReceiver.receivePayload(ctx, buffer);
                    continue;
                }
                BCOreProcessing.INSTANCE.getLogger().error('[' + this.getClass().getName() + "] Received unknown sync part: '" + key + "'. Stopping message.");
                return null;
            }
        }
        return null;
    }

    protected boolean isWorking() {
        ItemStack itemStack = this.itemHandler.getStackInSlot(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"this.itemHandler.getStackInSlot(0)");
        return !itemStack.func_190926_b() || this.fluidTank.getFluidAmount() > 0 || this.residueTank.getFluidAmount() > 0;
    }

    private final void testWorkingState() {
        boolean working;
        if (this.func_145831_w().field_72995_K && (working = this.isWorking()) != this.lastWorkingState) {
            Block block = this.func_145838_q();
            if (!(block instanceof BaseOreProcessorBlock)) {
                block = null;
            }
            BaseOreProcessorBlock baseOreProcessorBlock = (BaseOreProcessorBlock)block;
            if (baseOreProcessorBlock != null) {
                World world = this.func_145831_w();
                Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"this.getWorld()");
                BlockPos blockPos = this.func_174877_v();
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"this.getPos()");
                baseOreProcessorBlock.setIsWorking(world, blockPos, working);
            }
            this.lastWorkingState = working;
        }
    }

    public final void func_73660_a() {
        this.innerUpdate();
        if (this.func_145831_w().field_72995_K) {
            this.setRenderAngle((this.getRenderAngle() + 7.2f) % 360.0f);
            this.testWorkingState();
        } else {
            this.battery.tick(this.field_145850_b, this.field_174879_c);
            this.sendPayload();
        }
    }

    protected void innerUpdate() {
    }

    private final String describe(@NotNull FluidStack $receiver) {
        StringBuilder stringBuilder = new StringBuilder().append("").append($receiver.amount).append(" x ");
        Fluid fluid = $receiver.getFluid();
        Intrinsics.checkExpressionValueIsNotNull((Object)fluid, (String)"this.fluid");
        return stringBuilder.append(fluid.getName()).toString();
    }

    private final String describe(@NotNull ItemStack $receiver) {
        String string = $receiver.func_82833_r();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.displayName");
        return string;
    }

    public void getDebugInfo(@NotNull List<String> left, @NotNull List<String> right, @NotNull EnumFacing side) {
        Intrinsics.checkParameterIsNotNull(left, (String)"left");
        Intrinsics.checkParameterIsNotNull(right, (String)"right");
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        right.add("Battery: " + this.battery.getDebugString() + '.');
        StringBuilder stringBuilder = new StringBuilder().append("Fluid: ");
        Object object = this.fluidTank.getFluid();
        if (object == null || (object = this.describe((FluidStack)object)) == null) {
            object = "no fluid";
        }
        right.add(stringBuilder.append((String)object).append('.').toString());
        StringBuilder stringBuilder2 = new StringBuilder().append("Residue: ");
        Object object2 = this.residueTank.getFluid();
        if (object2 == null || (object2 = this.describe((FluidStack)object2)) == null) {
            object2 = "no fluid";
        }
        right.add(stringBuilder2.append((String)object2).append('.').toString());
        StringBuilder stringBuilder3 = new StringBuilder().append("Item: ");
        ItemStack itemStack = this.itemHandler.getStackInSlot(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"this.itemHandler.getStackInSlot(0)");
        right.add(stringBuilder3.append(this.describe(itemStack)).append('.').toString());
    }

    public BaseOreProcessorMachine() {
        BaseOreProcessorMachine baseOreProcessorMachine = this;
        Object object = new LinkedHashMap();
        baseOreProcessorMachine.syncWriters = object;
        baseOreProcessorMachine = this;
        object = new LinkedHashMap();
        baseOreProcessorMachine.syncReceivers = object;
        baseOreProcessorMachine = this;
        baseOreProcessorMachine.syncOnNextTick = object = (Set)new LinkedHashSet();
        Function2<String, FluidTankEx, Unit> registerSyncFluidPart$ = new Function2<String, FluidTankEx, Unit>(){

            public final void invoke(@NotNull String key, final @NotNull FluidTankEx tank) {
                Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                Intrinsics.checkParameterIsNotNull((Object)((Object)tank), (String)"tank");
                this.registerSyncPart(key, new IPayloadWriter(){

                    public final void write(PacketBufferBC buffer) {
                        FluidStack fluid = tank.getFluid();
                        if (fluid == null || fluid.amount == 0) {
                            buffer.writeInt(0);
                        } else {
                            buffer.writeInt(fluid.amount);
                            Fluid fluid2 = fluid.getFluid();
                            Intrinsics.checkExpressionValueIsNotNull((Object)fluid2, (String)"fluid.fluid");
                            buffer.func_180714_a(fluid2.getName());
                        }
                    }
                }, new IPayloadReceiver(){

                    @Nullable
                    public final Void receivePayload(MessageContext $noName_0, PacketBufferBC buffer) {
                        FluidStack fluidStack;
                        int fluidAmount = buffer.readInt();
                        if (fluidAmount > 0) {
                            String fluidName = buffer.readString();
                            fluidStack = new FluidStack(FluidRegistry.getFluid((String)fluidName), fluidAmount);
                        } else {
                            fluidStack = null;
                        }
                        tank.setFluid(fluidStack);
                        return null;
                    }
                });
            }
        };
        registerSyncFluidPart$.invoke(STORAGE_FLUID_TANK, this.fluidTank);
        registerSyncFluidPart$.invoke(STORAGE_RESIDUE_TANK, this.residueTank);
        this.registerSyncPart(STORAGE_ITEM_STACK, new IPayloadWriter(){

            public final void write(PacketBufferBC buffer) {
                buffer.func_150786_a(this.getItemHandler().serializeNBT());
            }
        }, new IPayloadReceiver(){

            @Nullable
            public final Void receivePayload(MessageContext $noName_0, PacketBufferBC buffer) {
                this.getItemHandler().deserializeNBT(buffer.func_150793_b());
                return null;
            }
        });
        this.registerSyncPart(STORAGE_BATTERY, new IPayloadWriter(){

            public final void write(PacketBufferBC buffer) {
                buffer.func_150786_a(this.getBattery().serializeNBT());
            }
        }, new IPayloadReceiver(){

            @Nullable
            public final Void receivePayload(MessageContext $noName_0, PacketBufferBC buffer) {
                this.getBattery().deserializeNBT(buffer.func_150793_b());
                return null;
            }
        });
        this.residueFluidCap = new IFluidHandler(this){
            final /* synthetic */ BaseOreProcessorMachine this$0;

            @Nullable
            public FluidStack drain(@Nullable FluidStack resource, boolean doDrain) {
                return this.this$0.getResidueTank().drain(resource, doDrain);
            }

            @Nullable
            public FluidStack drain(int maxDrain, boolean doDrain) {
                return this.this$0.getResidueTank().drain(maxDrain, doDrain);
            }

            public int fill(@Nullable FluidStack resource, boolean doFill) {
                return 0;
            }

            public IFluidTankProperties[] getTankProperties() {
                return this.this$0.getResidueTank().getTankProperties();
            }
            {
                this.this$0 = $outer;
            }
        };
        this.mainFluidCap = new IFluidHandler(this){
            final /* synthetic */ BaseOreProcessorMachine this$0;

            @Nullable
            public FluidStack drain(@Nullable FluidStack resource, boolean doDrain) {
                return this.this$0.getFluidTank().drain(resource, doDrain);
            }

            @Nullable
            public FluidStack drain(int maxDrain, boolean doDrain) {
                return this.this$0.getFluidTank().drain(maxDrain, doDrain);
            }

            public int fill(@Nullable FluidStack resource, boolean doFill) {
                return this.this$0.getFluidTank().fill(resource, doFill);
            }

            public IFluidTankProperties[] getTankProperties() {
                return this.this$0.getFluidTank().getTankProperties();
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lnet/ndrei/bcoreprocessing/machines/BaseOreProcessorMachine$Companion;", "", "()V", "STORAGE_BATTERY", "", "STORAGE_FLUID_TANK", "STORAGE_ITEM_STACK", "STORAGE_RESIDUE_TANK", "bc-ore-processing"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

