/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.bcoreprocessing.machines.fluidprocessor;

import buildcraft.api.mj.MjAPI;
import buildcraft.lib.net.IPayloadReceiver;
import buildcraft.lib.net.IPayloadWriter;
import buildcraft.lib.net.PacketBufferBC;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.ndrei.bcoreprocessing.lib.KotlinmagicKt;
import net.ndrei.bcoreprocessing.lib.recipes.FluidProcessorRecipeManager;
import net.ndrei.bcoreprocessing.machines.BaseOreProcessorMachine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004H\u0014J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lnet/ndrei/bcoreprocessing/machines/fluidprocessor/FluidProcessorTile;", "Lnet/ndrei/bcoreprocessing/machines/BaseOreProcessorMachine;", "()V", "currentFluid", "Lnet/minecraftforge/fluids/FluidStack;", "currentTick", "", "canExtractItem", "", "item", "Lnet/minecraft/item/ItemStack;", "canFillFluidType", "fluid", "getItemStack", "innerUpdate", "", "readFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "writeToNBT", "Companion", "bc-ore-processing"})
public final class FluidProcessorTile
extends BaseOreProcessorMachine {
    private FluidStack currentFluid;
    private int currentTick;
    @NotNull
    protected static final String STORAGE_CURRENT_FLUID = "current_fluid";
    public static final Companion Companion = new Companion(null);

    @Override
    protected boolean canExtractItem(@NotNull ItemStack item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        return true;
    }

    @Override
    protected boolean canFillFluidType(@NotNull FluidStack fluid) {
        Intrinsics.checkParameterIsNotNull((Object)fluid, (String)"fluid");
        return FluidProcessorRecipeManager.INSTANCE.findFirstRecipe(fluid, true) != null;
    }

    @Override
    @NotNull
    public ItemStack getItemStack() {
        FluidStack fluidStack;
        FluidStack it;
        Pair<ItemStack, FluidStack> pair;
        FluidStack fluidStack2;
        FluidStack fluidStack3 = this.currentFluid;
        if (fluidStack3 == null) {
            fluidStack3 = fluidStack2 = this.getFluidTank().getFluid();
        }
        if (fluidStack3 == null || ((pair = FluidProcessorRecipeManager.INSTANCE.findFirstRecipe(it = (fluidStack = fluidStack2), true)) != null && (pair = pair.getRecipeOutput()) != null ? (ItemStack)pair.getFirst() : (fluidStack2 = null)) == null) {
            ItemStack itemStack = this.getItemHandler().getStackInSlot(0);
            fluidStack2 = itemStack;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"this.itemHandler.getStackInSlot(0)");
        }
        return fluidStack2;
    }

    @Override
    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        this.currentTick = compound.func_150297_b("current_tick", 10) ? compound.func_74762_e("current_tick") : 0;
        this.currentFluid = compound.func_150297_b(STORAGE_CURRENT_FLUID, 10) ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l(STORAGE_CURRENT_FLUID)) : null;
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        NBTTagCompound nBTTagCompound;
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        NBTTagCompound it = nBTTagCompound = super.func_189515_b(compound);
        it.func_74768_a("current_tick", this.currentTick);
        if (this.currentFluid != null) {
            FluidStack fluidStack = this.currentFluid;
            if (fluidStack == null) {
                Intrinsics.throwNpe();
            }
            it.func_74782_a(STORAGE_CURRENT_FLUID, (NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
        }
        return nBTTagCompound;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void innerUpdate() {
        block9: {
            power = (long)6 * MjAPI.ONE_MINECRAFT_JOULE;
            v0 = this.currentFluid;
            if (v0 == null) {
                v0 = inputFluid = this.getFluidTank().getFluid();
            }
            if (inputFluid == null || inputFluid.amount <= 0 || this.getBattery().getStored() < power) break block9;
            v1 = this.getItemHandler().getStackInSlot(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"this.itemHandler.getStackInSlot(0)");
            if (!v1.func_190926_b() || (recipe = FluidProcessorRecipeManager.INSTANCE.findFirstRecipe(inputFluid, true)) == null) break block9;
            outputs = recipe.getOutputForTick(this.currentTick);
            fluidAtTick = recipe.getInputForTick(this.currentTick);
            fluid = (FluidStack)outputs.getSecond();
            v2 = f2ok = fluid == null || fluid.amount == 0 || this.getResidueTank().fillInternal(fluid, false) == fluid.amount;
            if (fluidAtTick == null || fluidAtTick.amount == 0) ** GOTO lbl-1000
            v3 = this.getFluidTank().drainInternal(fluidAtTick, false);
            if (v3 != null) {
                ** if (v3.amount != fluidAtTick.amount) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                v4 = true;
                ** GOTO lbl21
            }
lbl-1000:
            // 2 sources

            {
                v4 = drainOk = false;
            }
lbl21:
            // 2 sources

            if (f2ok && drainOk) {
                if (fluid != null && fluid.amount > 0) {
                    this.getResidueTank().fillInternal(fluid, true);
                }
                if (fluidAtTick != null && fluidAtTick.amount > 0) {
                    this.getFluidTank().drainInternal(fluidAtTick, true);
                    if (this.currentFluid == null) {
                        this.currentFluid = KotlinmagicKt.copyWithSize(fluidAtTick, 1);
                        this.markForUpdate("current_fluid");
                    }
                }
                var10_9 = this.currentTick;
                this.currentTick = var10_9 + 1;
                if (this.currentTick >= recipe.getProcessingTicks()) {
                    this.currentTick = 0;
                    this.currentFluid = null;
                    this.markForUpdate("current_fluid");
                    this.getItemHandler().setStackInSlot(0, (ItemStack)recipe.getRecipeOutput().getFirst());
                }
                this.getBattery().extractPower(power);
            }
        }
    }

    public FluidProcessorTile() {
        super.registerSyncPart(STORAGE_CURRENT_FLUID, new IPayloadWriter(){

            public final void write(PacketBufferBC buffer) {
                FluidStack fluid = currentFluid;
                if (fluid == null || fluid.amount == 0) {
                    buffer.writeInt(0);
                } else {
                    buffer.writeInt(fluid.amount);
                    Fluid fluid2 = fluid.getFluid();
                    Intrinsics.checkExpressionValueIsNotNull((Object)fluid2, (String)"fluid.fluid");
                    buffer.func_180714_a(fluid2.getName());
                }
            }
        }, new IPayloadReceiver(){

            @Nullable
            public final Void receivePayload(MessageContext $noName_0, PacketBufferBC buffer) {
                FluidStack fluidStack;
                int fluidAmount = buffer.readInt();
                if (fluidAmount > 0) {
                    String fluidName = buffer.readString();
                    fluidStack = new FluidStack(FluidRegistry.getFluid((String)fluidName), fluidAmount);
                } else {
                    fluidStack = null;
                }
                currentFluid = fluidStack;
                return null;
            }
        });
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/ndrei/bcoreprocessing/machines/fluidprocessor/FluidProcessorTile$Companion;", "", "()V", "STORAGE_CURRENT_FLUID", "", "bc-ore-processing"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

