/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.bcoreprocessing.machines.oreprocessor;

import buildcraft.api.mj.MjAPI;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.ndrei.bcoreprocessing.api.recipes.IOreProcessorRecipe;
import net.ndrei.bcoreprocessing.lib.recipes.OreProcessorRecipeManager;
import net.ndrei.bcoreprocessing.lib.render.IFluidStacksHolder;
import net.ndrei.bcoreprocessing.lib.render.IItemStackHolder;
import net.ndrei.bcoreprocessing.machines.BaseOreProcessorMachine;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\rH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/ndrei/bcoreprocessing/machines/oreprocessor/OreProcessorTile;", "Lnet/ndrei/bcoreprocessing/machines/BaseOreProcessorMachine;", "Lnet/ndrei/bcoreprocessing/lib/render/IItemStackHolder;", "Lnet/ndrei/bcoreprocessing/lib/render/IFluidStacksHolder;", "()V", "currentTick", "", "canDrainFluidType", "", "fluid", "Lnet/minecraftforge/fluids/FluidStack;", "canInsertItem", "item", "Lnet/minecraft/item/ItemStack;", "getItemStackLimit", "stack", "innerUpdate", "", "readFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "writeToNBT", "bc-ore-processing"})
public final class OreProcessorTile
extends BaseOreProcessorMachine
implements IItemStackHolder,
IFluidStacksHolder {
    private int currentTick;

    @Override
    protected boolean canInsertItem(@NotNull ItemStack item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        return OreProcessorRecipeManager.INSTANCE.findFirstRecipe(item, true) != null;
    }

    @Override
    protected boolean canDrainFluidType(@NotNull FluidStack fluid) {
        Intrinsics.checkParameterIsNotNull((Object)fluid, (String)"fluid");
        return true;
    }

    @Override
    protected int getItemStackLimit(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        ItemStack itemStack = OreProcessorRecipeManager.INSTANCE.findFirstRecipe(stack, true);
        return itemStack != null && (itemStack = itemStack.getPossibleInputs()) != null && (itemStack = (ItemStack)ArraysKt.firstOrNull((Object[])((Object[])itemStack))) != null ? itemStack.func_190916_E() : 0;
    }

    @Override
    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        this.currentTick = compound.func_150297_b("current_tick", 10) ? compound.func_74762_e("current_tick") : 0;
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        NBTTagCompound nBTTagCompound;
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        NBTTagCompound it = nBTTagCompound = super.func_189515_b(compound);
        it.func_74768_a("current_tick", this.currentTick);
        return nBTTagCompound;
    }

    @Override
    protected void innerUpdate() {
        Pair<FluidStack, FluidStack> fluids;
        IOreProcessorRecipe recipe;
        ItemStack currentInput;
        long power = (long)6 * MjAPI.ONE_MINECRAFT_JOULE;
        ItemStack itemStack = currentInput = this.getItemHandler().getStackInSlot(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"currentInput");
        if (!(itemStack.func_190926_b() || this.getBattery().getStored() < power || (recipe = OreProcessorRecipeManager.INSTANCE.findFirstRecipe(currentInput, false)) == null || (fluids = recipe.getOutputForTick(this.currentTick)).getFirst() == null && fluids.getSecond() == null)) {
            boolean f2ok;
            FluidStack fluid1 = (FluidStack)fluids.getFirst();
            boolean f1ok = fluid1 == null || fluid1.amount == 0 || this.getFluidTank().fillInternal(fluid1, false) == fluid1.amount;
            FluidStack fluid2 = (FluidStack)fluids.getSecond();
            boolean bl = f2ok = fluid2 == null || fluid2.amount == 0 || this.getResidueTank().fillInternal(fluid2, false) == fluid2.amount;
            if (f1ok && f2ok) {
                if (fluid1 != null && fluid1.amount > 0) {
                    this.getFluidTank().fillInternal(fluid1, true);
                }
                if (fluid2 != null && fluid2.amount > 0) {
                    this.getResidueTank().fillInternal(fluid2, true);
                }
                int n = this.currentTick;
                this.currentTick = n + 1;
                if (this.currentTick >= recipe.getProcessingTicks()) {
                    this.currentTick = 0;
                    this.getItemHandler().setStackInSlot(0, ItemStack.field_190927_a);
                }
                this.getBattery().extractPower(power);
            }
        }
    }
}

