/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree;

import fr.raksrinana.fallingtree.config.BreakMode;
import fr.raksrinana.fallingtree.config.CommonConfig;
import fr.raksrinana.fallingtree.config.ToolConfiguration;
import fr.raksrinana.fallingtree.config.TreeConfiguration;
import fr.raksrinana.fallingtree.tree.Tree;
import fr.raksrinana.fallingtree.tree.TreeHandler;
import fr.raksrinana.fallingtree.utils.CachedSpeed;
import fr.raksrinana.fallingtree.utils.FallingTreeUtils;
import fr.raksrinana.fallingtree.utils.LeafBreakingSchedule;
import io.netty.util.internal.ConcurrentSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="falling_tree")
public final class ForgeEventSubscriber {
    private static final Set<LeafBreakingSchedule> scheduledLeavesBreaking = new ConcurrentSet();
    private static final Map<UUID, CachedSpeed> speedCache = new HashMap<UUID, CachedSpeed>();

    @SubscribeEvent
    public static void onBreakSpeed(@Nonnull PlayerEvent.BreakSpeed event) {
        CachedSpeed cachedSpeed;
        if (!event.isCanceled() && TreeConfiguration.getBreakMode() == BreakMode.INSTANTANEOUS && ForgeEventSubscriber.isPlayerInRightState(event.getEntityPlayer()) && Objects.nonNull(cachedSpeed = speedCache.compute(event.getEntityPlayer().func_110124_au(), (pos, speed) -> {
            if (Objects.isNull(speed) || !speed.isValid(event.getPos())) {
                speed = ForgeEventSubscriber.getSpeed(event);
            }
            return speed;
        }))) {
            event.setNewSpeed(cachedSpeed.getSpeed());
        }
    }

    private static CachedSpeed getSpeed(PlayerEvent.BreakSpeed event) {
        double speedMultiplicand = ToolConfiguration.getSpeedMultiplicand();
        return speedMultiplicand <= 0.0 ? null : (CachedSpeed)TreeHandler.getTree(event.getEntity().func_130014_f_(), event.getPos()).map(tree -> new CachedSpeed(event.getPos(), event.getOriginalSpeed() / ((float)speedMultiplicand * (float)tree.getLogCount()))).orElse(null);
    }

    @SubscribeEvent
    public static void onBlockBreakEvent(@Nonnull BlockEvent.BreakEvent event) {
        if (!event.isCanceled() && !event.getWorld().field_72995_K && ForgeEventSubscriber.isPlayerInRightState(event.getPlayer())) {
            TreeHandler.getTree(event.getWorld(), event.getPos()).ifPresent(tree -> {
                BreakMode breakMode = TreeConfiguration.getBreakMode();
                if (breakMode == BreakMode.INSTANTANEOUS) {
                    ForgeEventSubscriber.breakInstant(event, tree);
                } else if (breakMode == BreakMode.SHIFT_DOWN) {
                    ForgeEventSubscriber.breakShiftDown(event, tree);
                }
            });
        }
    }

    private static void breakInstant(BlockEvent.BreakEvent event, Tree tree) {
        if (TreeConfiguration.getMaxSize() >= tree.getLogCount()) {
            if (!TreeHandler.destroyInstant(tree, event.getPlayer(), event.getPlayer().func_184586_b(EnumHand.MAIN_HAND))) {
                event.setCanceled(true);
            }
        } else {
            event.getPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("chat.falling_tree.tree_too_big", new Object[]{tree.getLogCount(), TreeConfiguration.getMaxSize()}));
        }
    }

    private static void breakShiftDown(BlockEvent.BreakEvent event, Tree tree) {
        TreeHandler.destroyShift(tree, event.getPlayer(), event.getPlayer().func_184586_b(EnumHand.MAIN_HAND));
        event.setCanceled(true);
    }

    private static boolean isPlayerInRightState(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d && !CommonConfig.isBreakInCreative()) {
            return false;
        }
        if (CommonConfig.isReverseSneaking() != player.func_70093_af()) {
            return false;
        }
        return FallingTreeUtils.canPlayerBreakTree(player);
    }

    @SubscribeEvent
    public static void onNeighborNotifyEvent(BlockEvent.NeighborNotifyEvent event) {
        if (TreeConfiguration.isLeavesBreaking() && !event.getWorld().field_72995_K && event.getWorld() instanceof WorldServer) {
            BlockPos eventPos;
            WorldServer world = (WorldServer)event.getWorld();
            IBlockState eventState = event.getState();
            Block eventBlock = eventState.func_177230_c();
            if (eventBlock.isAir(eventState, (IBlockAccess)world, eventPos = event.getPos())) {
                for (EnumFacing facing : event.getNotifiedSides()) {
                    IBlockState neighborState;
                    BlockPos neighborPos = eventPos.func_177972_a(facing);
                    if (!world.func_175697_a(neighborPos, 1) || !FallingTreeUtils.isLeafBlock((neighborState = event.getWorld().func_180495_p(neighborPos)).func_177230_c())) continue;
                    scheduledLeavesBreaking.add(new LeafBreakingSchedule(world, neighborPos, 4));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END) {
            Iterator<LeafBreakingSchedule> leavesBreak = scheduledLeavesBreaking.iterator();
            while (leavesBreak.hasNext()) {
                LeafBreakingSchedule leafBreakingSchedule = leavesBreak.next();
                WorldServer world = leafBreakingSchedule.getWorld();
                if (leafBreakingSchedule.getRemainingTicks() <= 0) {
                    IBlockState state;
                    Block block;
                    if (world.func_175667_e(leafBreakingSchedule.getBlockPos()) && FallingTreeUtils.isLeafBlock(block = (state = world.func_180495_p(leafBreakingSchedule.getBlockPos())).func_177230_c())) {
                        block.func_180645_a((World)world, leafBreakingSchedule.getBlockPos(), state, world.field_73012_v);
                    }
                    leavesBreak.remove();
                    continue;
                }
                leafBreakingSchedule.tick();
            }
        }
    }
}

